/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.ui.view.recyclers.managers;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import mx.com.atriz.widgets.ui.view.recyclers.managers.CardSliderLayoutManager;

public class DefaultViewUpdater
implements CardSliderLayoutManager.ViewUpdater {
    public static final float SCALE_LEFT = 0.65f;
    public static final float SCALE_CENTER = 0.95f;
    public static final float SCALE_RIGHT = 0.8f;
    public static final float SCALE_CENTER_TO_LEFT = 0.3f;
    public static final float SCALE_CENTER_TO_RIGHT = 0.14999998f;
    public static final int Z_CENTER_1 = 12;
    public static final int Z_CENTER_2 = 16;
    public static final int Z_RIGHT = 8;
    private int cardWidth;
    private int activeCardLeft;
    private int activeCardRight;
    private int activeCardCenter;
    private float cardsGap;
    private int transitionEnd;
    private int transitionDistance;
    private float transitionRight2Center;
    private CardSliderLayoutManager lm;
    private View previewView;

    @Override
    public void onLayoutManagerInitialized(@NonNull CardSliderLayoutManager lm) {
        this.lm = lm;
        this.cardWidth = lm.getCardWidth();
        this.activeCardLeft = lm.getActiveCardLeft();
        this.activeCardRight = lm.getActiveCardRight();
        this.activeCardCenter = lm.getActiveCardCenter();
        this.cardsGap = lm.getCardsGap();
        this.transitionEnd = this.activeCardCenter;
        this.transitionDistance = this.activeCardRight - this.transitionEnd;
        float centerBorder = ((float)this.cardWidth - (float)this.cardWidth * 0.95f) / 2.0f;
        float rightBorder = ((float)this.cardWidth - (float)this.cardWidth * 0.8f) / 2.0f;
        float right2centerDistance = (float)this.activeCardRight + centerBorder - ((float)this.activeCardRight - rightBorder);
        this.transitionRight2Center = right2centerDistance - this.cardsGap;
    }

    @Override
    public void updateView(@NonNull View view, float position) {
        float x;
        float z;
        float alpha;
        float scale;
        if (position < 0.0f) {
            float ratio = (float)this.lm.getDecoratedLeft(view) / (float)this.activeCardLeft;
            scale = 0.65f + 0.3f * ratio;
            alpha = 0.1f + ratio;
            z = 12.0f * ratio;
            x = 0.0f;
        } else if (position < 0.5f) {
            scale = 0.95f;
            alpha = 1.0f;
            z = 12.0f;
            x = 0.0f;
        } else if (position < 1.0f) {
            int viewLeft = this.lm.getDecoratedLeft(view);
            float ratio = (float)(viewLeft - this.activeCardCenter) / (float)(this.activeCardRight - this.activeCardCenter);
            scale = 0.95f - 0.14999998f * ratio;
            alpha = 1.0f;
            z = 16.0f;
            x = Math.abs(this.transitionRight2Center) < Math.abs(this.transitionRight2Center * (float)(viewLeft - this.transitionEnd) / (float)this.transitionDistance) ? -this.transitionRight2Center : -this.transitionRight2Center * (float)(viewLeft - this.transitionEnd) / (float)this.transitionDistance;
        } else {
            scale = 0.8f;
            alpha = 1.0f;
            z = 8.0f;
            if (this.previewView != null) {
                float prevTransition;
                int prevRight;
                float prevViewScale;
                boolean isFirstRight;
                boolean bl = isFirstRight = this.lm.getDecoratedRight(this.previewView) <= this.activeCardRight;
                if (isFirstRight) {
                    prevViewScale = 0.95f;
                    prevRight = this.activeCardRight;
                    prevTransition = 0.0f;
                } else {
                    prevViewScale = ViewCompat.getScaleX((View)this.previewView);
                    prevRight = this.lm.getDecoratedRight(this.previewView);
                    prevTransition = ViewCompat.getTranslationX((View)this.previewView);
                }
                float prevBorder = ((float)this.cardWidth - (float)this.cardWidth * prevViewScale) / 2.0f;
                float currentBorder = ((float)this.cardWidth - (float)this.cardWidth * 0.8f) / 2.0f;
                float distance = (float)this.lm.getDecoratedLeft(view) + currentBorder - ((float)prevRight - prevBorder + prevTransition);
                float transition = distance - this.cardsGap;
                x = -transition;
            } else {
                x = 0.0f;
            }
        }
        ViewCompat.setScaleX((View)view, (float)scale);
        ViewCompat.setScaleY((View)view, (float)scale);
        ViewCompat.setZ((View)view, (float)z);
        ViewCompat.setTranslationX((View)view, (float)x);
        ViewCompat.setAlpha((View)view, (float)alpha);
        this.previewView = view;
    }

    protected CardSliderLayoutManager getLayoutManager() {
        return this.lm;
    }
}

