/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.utils;

import android.graphics.Bitmap;
import android.util.LruCache;

class BackgroundBitmapCache {
    private LruCache<Integer, Bitmap> mBackgroundsCache;
    private static BackgroundBitmapCache instance;

    BackgroundBitmapCache() {
    }

    public static BackgroundBitmapCache getInstance() {
        if (instance == null) {
            instance = new BackgroundBitmapCache();
            instance.init();
        }
        return instance;
    }

    private void init() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 5;
        this.mBackgroundsCache = new LruCache<Integer, Bitmap>(cacheSize){

            protected int sizeOf(Integer key, Bitmap bitmap) {
                return bitmap.getByteCount() / 1024;
            }
        };
    }

    public void addBitmapToBgMemoryCache(Integer key, Bitmap bitmap) {
        if (this.getBitmapFromBgMemCache(key) == null) {
            this.mBackgroundsCache.put((Object)key, (Object)bitmap);
        }
    }

    public Bitmap getBitmapFromBgMemCache(Integer key) {
        return (Bitmap)this.mBackgroundsCache.get((Object)key);
    }
}

