/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.AsyncTask;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import mx.com.atriz.widgets.R;
import mx.com.atriz.widgets.utils.BackgroundBitmapCache;

public class DecodeBitmapTask
extends AsyncTask<Void, Void, Bitmap> {
    private final BackgroundBitmapCache cache = BackgroundBitmapCache.getInstance();
    private final Resources resources;
    private final int bitmapResId;
    private final int reqWidth;
    private final int reqHeight;
    private final Reference<Listener> refListener;

    public DecodeBitmapTask(Resources resources, @DrawableRes int bitmapResId, int reqWidth, int reqHeight, @NonNull Listener listener) {
        this.resources = resources;
        this.bitmapResId = bitmapResId;
        this.reqWidth = reqWidth;
        this.reqHeight = reqHeight;
        this.refListener = new WeakReference<Listener>(listener);
    }

    protected Bitmap doInBackground(Void ... voids) {
        Bitmap cachedBitmap = this.cache.getBitmapFromBgMemCache(this.bitmapResId);
        if (cachedBitmap != null) {
            return cachedBitmap;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)this.resources, (int)this.bitmapResId, (BitmapFactory.Options)options);
        int width = options.outWidth;
        int height = options.outHeight;
        int inSampleSize = 1;
        if (height > this.reqHeight || width > this.reqWidth) {
            int halfWidth = width / 2;
            int halfHeight = height / 2;
            while (halfHeight / inSampleSize >= this.reqHeight && halfWidth / inSampleSize >= this.reqWidth && !this.isCancelled()) {
                inSampleSize *= 2;
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        options.inSampleSize = inSampleSize;
        options.inJustDecodeBounds = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap decodedBitmap = BitmapFactory.decodeResource((Resources)this.resources, (int)this.bitmapResId, (BitmapFactory.Options)options);
        Bitmap result = DecodeBitmapTask.getRoundedCornerBitmap(decodedBitmap, this.resources.getDimension(R.dimen.card_corner_radius), this.reqWidth, this.reqHeight);
        decodedBitmap.recycle();
        this.cache.addBitmapToBgMemoryCache(this.bitmapResId, result);
        return result;
    }

    protected final void onPostExecute(Bitmap bitmap) {
        Listener listener = this.refListener.get();
        if (listener != null) {
            listener.onPostExecuted(bitmap);
        }
    }

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float pixels, int width, int height) {
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int sourceWidth = bitmap.getWidth();
        int sourceHeight = bitmap.getHeight();
        float xScale = (float)width / (float)bitmap.getWidth();
        float yScale = (float)height / (float)bitmap.getHeight();
        float scale = Math.max(xScale, yScale);
        float scaledWidth = scale * (float)sourceWidth;
        float scaledHeight = scale * (float)sourceHeight;
        float left = ((float)width - scaledWidth) / 2.0f;
        float top = ((float)height - scaledHeight) / 2.0f;
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, width, height);
        RectF rectF = new RectF(rect);
        RectF targetRect = new RectF(left, top, left + scaledWidth, top + scaledHeight);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, pixels, pixels, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, null, targetRect, paint);
        return output;
    }

    public static interface Listener {
        public void onPostExecuted(Bitmap var1);
    }
}

