/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.ui.view.components.background;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import mx.com.atriz.widgets.R;
import mx.com.atriz.widgets.ui.view.components.background.Particle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001PB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u00109\u001a\u00020:2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J\u0006\u0010>\u001a\u00020:J\u0006\u0010?\u001a\u00020:J\u0010\u0010@\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0016J(\u0010A\u001a\u00020:2\u0006\u0010<\u001a\u00020=2\u0006\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0016J\b\u0010E\u001a\u00020:H\u0002J \u0010K\u001a\u00020:2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\rH\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R&\u0010\"\u001a\u00020\b2\b\b\u0001\u0010\u001c\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R&\u0010%\u001a\u00020\b2\b\b\u0001\u0010\u001c\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R&\u0010(\u001a\u00020\b2\b\b\u0001\u0010\u001c\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R&\u0010+\u001a\u00020\b2\b\b\u0001\u0010\u001c\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R&\u0010.\u001a\u00020\b2\b\b\u0001\u0010\u001c\u001a\u00020\b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!R$\u00101\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lmx/com/atriz/widgets/ui/view/components/background/ParticleView;", "Landroid/view/SurfaceView;", "Landroid/view/SurfaceHolder$Callback;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "particles", "", "Lmx/com/atriz/widgets/ui/view/components/background/Particle;", "surfaceViewThread", "Lmx/com/atriz/widgets/ui/view/components/background/ParticleView$SurfaceViewThread;", "hasSurface", "", "hasSetup", "path", "Landroid/graphics/Path;", "_particleCount", "_particleMinRadius", "_particleMaxRadius", "_particlesBackgroundColor", "_particleColor", "_particleLineColor", "_particleLinesEnabled", "value", "particleCount", "getParticleCount", "()I", "setParticleCount", "(I)V", "particleMinRadius", "getParticleMinRadius", "setParticleMinRadius", "particleMaxRadius", "getParticleMaxRadius", "setParticleMaxRadius", "particlesBackgroundColor", "getParticlesBackgroundColor", "setParticlesBackgroundColor", "particleColor", "getParticleColor", "setParticleColor", "particleLineColor", "getParticleLineColor", "setParticleLineColor", "particleLinesEnabled", "getParticleLinesEnabled", "()Z", "setParticleLinesEnabled", "(Z)V", "paintParticles", "Landroid/graphics/Paint;", "paintLines", "obtainStyledAttributes", "", "surfaceCreated", "holder", "Landroid/view/SurfaceHolder;", "resume", "pause", "surfaceDestroyed", "surfaceChanged", "format", "w", "h", "setupParticles", "dx", "", "dy", "dist", "distRatio", "linkParticles", "canvas", "Landroid/graphics/Canvas;", "p1", "p2", "SurfaceViewThread", "widgets_release"})
@StabilityInferred(parameters=0)
public final class ParticleView
extends SurfaceView
implements SurfaceHolder.Callback {
    @NotNull
    private final List<Particle> particles;
    @Nullable
    private SurfaceViewThread surfaceViewThread;
    private boolean hasSurface;
    private boolean hasSetup;
    @NotNull
    private final Path path;
    private int _particleCount;
    @Dimension
    private int _particleMinRadius;
    @Dimension
    private int _particleMaxRadius;
    @ColorInt
    private int _particlesBackgroundColor;
    @ColorInt
    private int _particleColor;
    @ColorInt
    private int _particleLineColor;
    private boolean _particleLinesEnabled;
    @NotNull
    private final Paint paintParticles;
    @NotNull
    private final Paint paintLines;
    private float dx;
    private float dy;
    private float dist;
    private float distRatio;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ParticleView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        void $this$paintLines_u24lambda_u241;
        Paint $this$paintParticles_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.particles = new ArrayList();
        this.path = new Path();
        this._particleCount = 20;
        this._particleMinRadius = 5;
        this._particleMaxRadius = 10;
        this._particleColor = -1;
        this._particleLineColor = -1;
        this._particleLinesEnabled = true;
        Paint paint2 = paint = new Paint();
        ParticleView particleView = this;
        boolean bl = false;
        $this$paintParticles_u24lambda_u240.setAntiAlias(true);
        $this$paintParticles_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$paintParticles_u24lambda_u240.setStrokeWidth(2.0f);
        particleView.paintParticles = paint;
        $this$paintParticles_u24lambda_u240 = paint = new Paint();
        particleView = this;
        boolean bl2 = false;
        $this$paintLines_u24lambda_u241.setAntiAlias(true);
        $this$paintLines_u24lambda_u241.setStyle(Paint.Style.FILL_AND_STROKE);
        $this$paintLines_u24lambda_u241.setStrokeWidth(2.0f);
        particleView.paintLines = paint;
        this.obtainStyledAttributes(attrs, defStyleAttr);
        if (this.getHolder() != null) {
            this.setZOrderOnTop(true);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            this.getHolder().setFormat(-2);
        }
        this.hasSurface = false;
    }

    public /* synthetic */ ParticleView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = R.attr.ParticleViewStyle;
        }
        this(context, attributeSet, n);
    }

    public final int getParticleCount() {
        return this._particleCount;
    }

    public final void setParticleCount(int value) {
        this._particleCount = value > 50 ? 50 : (value < 0 ? 0 : value);
    }

    @Dimension
    public final int getParticleMinRadius() {
        return this._particleMinRadius;
    }

    public final void setParticleMinRadius(@Dimension int value) {
        this._particleMinRadius = value <= 0 ? 1 : (value >= this.getParticleMaxRadius() ? 1 : value);
    }

    @Dimension
    public final int getParticleMaxRadius() {
        return this._particleMaxRadius;
    }

    public final void setParticleMaxRadius(@Dimension int value) {
        this._particleMaxRadius = value <= this.getParticleMinRadius() ? this.getParticleMinRadius() + 1 : value;
    }

    @ColorInt
    public final int getParticlesBackgroundColor() {
        return this._particlesBackgroundColor;
    }

    public final void setParticlesBackgroundColor(@ColorInt int value) {
        this._particlesBackgroundColor = value;
    }

    @ColorInt
    public final int getParticleColor() {
        return this._particleColor;
    }

    public final void setParticleColor(@ColorInt int value) {
        this._particleColor = value;
        this.paintParticles.setColor(value);
    }

    @ColorInt
    public final int getParticleLineColor() {
        return this._particleLineColor;
    }

    public final void setParticleLineColor(@ColorInt int value) {
        this._particleLineColor = value;
        this.paintLines.setColor(value);
    }

    public final boolean getParticleLinesEnabled() {
        return this._particleLinesEnabled;
    }

    public final void setParticleLinesEnabled(boolean value) {
        this._particleLinesEnabled = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void obtainStyledAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ParticleView, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray typedArray2 = typedArray;
        try {
            this.setParticleCount(typedArray2.getInt(R.styleable.ParticleView_particleCount, this.getParticleCount()));
            this.setParticleMinRadius(typedArray2.getInt(R.styleable.ParticleView_particleMinRadius, this.getParticleMinRadius()));
            this.setParticleMaxRadius(typedArray2.getInt(R.styleable.ParticleView_particleMaxRadius, this.getParticleMaxRadius()));
            this.setParticlesBackgroundColor(typedArray2.getColor(R.styleable.ParticleView_particlesBackgroundColor, this.getParticlesBackgroundColor()));
            this.setParticleColor(typedArray2.getColor(R.styleable.ParticleView_particleColor, this.getParticleColor()));
            this.setParticleLineColor(typedArray2.getColor(R.styleable.ParticleView_particleLineColor, this.getParticleLineColor()));
            this.setParticleLinesEnabled(typedArray2.getBoolean(R.styleable.ParticleView_particleLinesEnabled, this.getParticleLinesEnabled()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            typedArray2.recycle();
        }
    }

    public void surfaceCreated(@NotNull SurfaceHolder holder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.hasSurface = true;
            if (this.surfaceViewThread == null) {
                this.surfaceViewThread = new SurfaceViewThread();
            }
            SurfaceViewThread surfaceViewThread = this.surfaceViewThread;
            if (surfaceViewThread == null) break block1;
            surfaceViewThread.start();
        }
    }

    public final void resume() {
        block2: {
            if (this.surfaceViewThread != null) break block2;
            this.surfaceViewThread = new SurfaceViewThread();
            if (this.hasSurface) {
                SurfaceViewThread surfaceViewThread = this.surfaceViewThread;
                if (surfaceViewThread != null) {
                    surfaceViewThread.start();
                }
            }
        }
    }

    public final void pause() {
        SurfaceViewThread surfaceViewThread = this.surfaceViewThread;
        if (surfaceViewThread != null) {
            surfaceViewThread.requestExitAndWait();
        }
        this.surfaceViewThread = null;
    }

    public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.hasSurface = false;
        SurfaceViewThread surfaceViewThread = this.surfaceViewThread;
        if (surfaceViewThread != null) {
            surfaceViewThread.requestExitAndWait();
        }
        this.surfaceViewThread = null;
    }

    public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    private final void setupParticles() {
        if (!this.hasSetup) {
            this.hasSetup = true;
            this.particles.clear();
            int n = this.getParticleCount();
            for (int i = 0; i < n; ++i) {
                this.particles.add(new Particle(Random.Default.nextInt(this.getParticleMinRadius(), this.getParticleMaxRadius()), Random.Default.nextInt(0, this.getWidth()), Random.Default.nextInt(0, this.getHeight()), Random.Default.nextInt(-2, 2), Random.Default.nextInt(-2, 2), Random.Default.nextInt(150, 255)));
            }
        }
    }

    private final void linkParticles(Canvas canvas, Particle p1, Particle p2) {
        this.dx = p1.getX() - p2.getX();
        this.dy = p1.getY() - p2.getY();
        this.dist = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        if (this.dist < 220.0f) {
            this.path.moveTo(p1.getX(), p1.getY());
            this.path.lineTo(p2.getX(), p2.getY());
            this.distRatio = ((float)220 - this.dist) / (float)220;
            this.paintLines.setAlpha((int)((float)Math.min(p1.getAlpha(), p2.getAlpha()) * this.distRatio / (float)2));
            canvas.drawPath(this.path, this.paintLines);
            this.path.reset();
        }
    }

    @JvmOverloads
    public ParticleView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        this(context, attrs, 0, 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmx/com/atriz/widgets/ui/view/components/background/ParticleView$SurfaceViewThread;", "Ljava/lang/Thread;", "<init>", "(Lmx/com/atriz/widgets/ui/view/components/background/ParticleView;)V", "running", "", "canvas", "Landroid/graphics/Canvas;", "run", "", "requestExitAndWait", "widgets_release"})
    private final class SurfaceViewThread
    extends Thread {
        private boolean running = true;
        @Nullable
        private Canvas canvas;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ParticleView.this.setupParticles();
            while (this.running) {
                try {
                    SurfaceHolder surfaceHolder;
                    this.canvas = ParticleView.this.getHolder().lockCanvas();
                    Intrinsics.checkNotNullExpressionValue((Object)ParticleView.this.getHolder(), (String)"getHolder(...)");
                    ParticleView particleView = ParticleView.this;
                    SurfaceHolder surfaceHolder2 = surfaceHolder;
                    synchronized (surfaceHolder2) {
                        boolean bl = false;
                        Canvas canvas = this.canvas;
                        if (canvas != null) {
                            canvas.drawColor(particleView.getParticlesBackgroundColor(), PorterDuff.Mode.SRC);
                        }
                        int n = particleView.getParticleCount();
                        for (int i = 0; i < n; ++i) {
                            Particle particle = (Particle)particleView.particles.get(i);
                            particle.setX(particle.getX() + (float)((Particle)particleView.particles.get(i)).getVx());
                            particle = (Particle)particleView.particles.get(i);
                            particle.setY(particle.getY() + (float)((Particle)particleView.particles.get(i)).getVy());
                            if (((Particle)particleView.particles.get(i)).getX() < 0.0f) {
                                ((Particle)particleView.particles.get(i)).setX(particleView.getWidth());
                            } else if (((Particle)particleView.particles.get(i)).getX() > (float)particleView.getWidth()) {
                                ((Particle)particleView.particles.get(i)).setX(0.0f);
                            }
                            if (((Particle)particleView.particles.get(i)).getY() < 0.0f) {
                                ((Particle)particleView.particles.get(i)).setY(particleView.getHeight());
                            } else if (((Particle)particleView.particles.get(i)).getY() > (float)particleView.getHeight()) {
                                ((Particle)particleView.particles.get(i)).setY(0.0f);
                            }
                            if (this.canvas != null) {
                                boolean bl2 = false;
                                if (particleView.getParticleLinesEnabled()) {
                                    int n2 = particleView.getParticleCount();
                                    for (int j = 0; j < n2; ++j) {
                                        Canvas it;
                                        if (i == j) continue;
                                        particleView.linkParticles(it, (Particle)particleView.particles.get(i), (Particle)particleView.particles.get(j));
                                    }
                                }
                            }
                            particleView.paintParticles.setAlpha(((Particle)particleView.particles.get(i)).getAlpha());
                            Canvas canvas2 = this.canvas;
                            if (canvas2 == null) continue;
                            canvas2.drawCircle(((Particle)particleView.particles.get(i)).getX(), ((Particle)particleView.particles.get(i)).getY(), ((Particle)particleView.particles.get(i)).getRadius(), particleView.paintParticles);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.canvas == null) continue;
                    ParticleView.this.getHolder().unlockCanvasAndPost(this.canvas);
                }
            }
        }

        public final void requestExitAndWait() {
            this.running = false;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

