/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.ui.view.recyclers.managers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import mx.com.atriz.widgets.R;
import mx.com.atriz.widgets.ui.view.recyclers.managers.DefaultViewUpdater;

public class CardSliderLayoutManager
extends RecyclerView.LayoutManager
implements RecyclerView.SmoothScroller.ScrollVectorProvider {
    private static final int DEFAULT_ACTIVE_CARD_LEFT_OFFSET = 50;
    private static final int DEFAULT_CARD_WIDTH = 148;
    private static final int DEFAULT_CARDS_GAP = 12;
    private static final int LEFT_CARD_COUNT = 2;
    private final SparseArray<View> viewCache = new SparseArray();
    private final SparseIntArray cardsXCoords = new SparseIntArray();
    private int cardWidth;
    private int activeCardLeft;
    private int activeCardRight;
    private int activeCardCenter;
    private float cardsGap;
    private int scrollRequestedPosition = 0;
    private ViewUpdater viewUpdater;
    private RecyclerView recyclerView;

    public CardSliderLayoutManager(@NonNull Context context) {
        this(context, null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardSliderLayoutManager(@NonNull Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        float density = context.getResources().getDisplayMetrics().density;
        int defaultCardWidth = (int)(148.0f * density);
        int defaultActiveCardLeft = (int)(50.0f * density);
        float defaultCardsGap = 12.0f * density;
        if (attrs == null) {
            this.initialize(defaultActiveCardLeft, defaultCardWidth, defaultCardsGap, null);
        } else {
            String viewUpdateClassName;
            float attrCardsGap;
            int attrActiveCardLeft;
            int attrCardWidth;
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardSlider, 0, 0);
            try {
                attrCardWidth = a.getDimensionPixelSize(R.styleable.CardSlider_cardWidth, defaultCardWidth);
                attrActiveCardLeft = a.getDimensionPixelSize(R.styleable.CardSlider_activeCardLeftOffset, defaultActiveCardLeft);
                attrCardsGap = a.getDimension(R.styleable.CardSlider_cardsGap, defaultCardsGap);
                viewUpdateClassName = a.getString(R.styleable.CardSlider_viewUpdater);
            }
            finally {
                a.recycle();
            }
            ViewUpdater viewUpdater = this.loadViewUpdater(context, viewUpdateClassName, attrs);
            this.initialize(attrActiveCardLeft, attrCardWidth, attrCardsGap, viewUpdater);
        }
    }

    public CardSliderLayoutManager(int activeCardLeft, int cardWidth, float cardsGap) {
        this.initialize(activeCardLeft, cardWidth, cardsGap, null);
    }

    private void initialize(int left, int width, float gap, @Nullable ViewUpdater updater) {
        this.cardWidth = width;
        this.activeCardLeft = left;
        this.activeCardRight = this.activeCardLeft + this.cardWidth;
        this.activeCardCenter = this.activeCardLeft + (this.activeCardRight - this.activeCardLeft) / 2;
        this.cardsGap = gap;
        this.viewUpdater = updater;
        if (this.viewUpdater == null) {
            this.viewUpdater = new DefaultViewUpdater();
        }
        this.viewUpdater.onLayoutManagerInitialized(this);
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.getItemCount() == 0) {
            this.removeAndRecycleAllViews(recycler);
            return;
        }
        if (this.getChildCount() == 0 && state.isPreLayout()) {
            return;
        }
        int anchorPos = this.getActiveCardPosition();
        if (state.isPreLayout()) {
            LinkedList<Integer> removed = new LinkedList<Integer>();
            int cnt = this.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                View child = this.getChildAt(i);
                boolean isRemoved = ((RecyclerView.LayoutParams)child.getLayoutParams()).isItemRemoved();
                if (!isRemoved) continue;
                removed.add(this.getPosition(child));
            }
            if (removed.contains(anchorPos)) {
                int first = (Integer)removed.getFirst();
                int last = (Integer)removed.getLast();
                int left = first - 1;
                int right = last == this.getItemCount() + removed.size() - 1 ? -1 : last;
                anchorPos = Math.max(left, right);
            }
            this.scrollRequestedPosition = anchorPos;
        }
        this.detachAndScrapAttachedViews(recycler);
        this.fill(anchorPos, recycler, state);
        if (this.cardsXCoords.size() != 0) {
            this.layoutByCoords();
        }
        if (state.isPreLayout()) {
            this.recyclerView.postOnAnimationDelayed(this::updateViewScale, 415L);
        } else {
            this.updateViewScale();
        }
    }

    public boolean supportsPredictiveItemAnimations() {
        return true;
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        this.removeAllViews();
    }

    public boolean canScrollHorizontally() {
        return this.getChildCount() != 0;
    }

    public void scrollToPosition(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return;
        }
        this.scrollRequestedPosition = position;
        this.requestLayout();
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.scrollRequestedPosition = -1;
        int delta = dx < 0 ? this.scrollRight(Math.max(dx, -this.cardWidth)) : this.scrollLeft(dx);
        this.fill(this.getActiveCardPosition(), recycler, state);
        this.updateViewScale();
        this.cardsXCoords.clear();
        int cnt = this.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            View view = this.getChildAt(i);
            this.cardsXCoords.put(this.getPosition(view), this.getDecoratedLeft(view));
        }
        return delta;
    }

    public PointF computeScrollVectorForPosition(int targetPosition) {
        return new PointF((float)(targetPosition - this.getActiveCardPosition()), 0.0f);
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return;
        }
        LinearSmoothScroller scroller = this.getSmoothScroller(recyclerView);
        scroller.setTargetPosition(position);
        this.startSmoothScroll((RecyclerView.SmoothScroller)scroller);
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int count) {
        int anchorPos = this.getActiveCardPosition();
        if (positionStart + count <= anchorPos) {
            this.scrollRequestedPosition = anchorPos - 1;
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState state = new SavedState();
        state.anchorPos = this.getActiveCardPosition();
        return state;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof SavedState) {
            SavedState state = (SavedState)parcelable;
            this.scrollRequestedPosition = state.anchorPos;
            this.requestLayout();
        }
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.recyclerView = view;
    }

    public void onDetachedFromWindow(RecyclerView view, RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.recyclerView = null;
    }

    public int getActiveCardPosition() {
        if (this.scrollRequestedPosition != -1) {
            return this.scrollRequestedPosition;
        }
        int result = -1;
        View biggestView = null;
        float lastScaleX = 0.0f;
        int cnt = this.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            float scaleX;
            View child = this.getChildAt(i);
            int viewLeft = this.getDecoratedLeft(child);
            if (viewLeft >= this.activeCardRight || !(lastScaleX < (scaleX = ViewCompat.getScaleX((View)child))) || viewLeft >= this.activeCardCenter) continue;
            lastScaleX = scaleX;
            biggestView = child;
        }
        if (biggestView != null) {
            result = this.getPosition(biggestView);
        }
        return result;
    }

    @Nullable
    public View getTopView() {
        if (this.getChildCount() == 0) {
            return null;
        }
        View result = null;
        float lastValue = this.cardWidth;
        int cnt = this.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            int viewLeft;
            int diff;
            View child = this.getChildAt(i);
            if (this.getDecoratedLeft(child) >= this.activeCardRight || !((float)(diff = this.activeCardRight - (viewLeft = this.getDecoratedLeft(child))) < lastValue)) continue;
            lastValue = diff;
            result = child;
        }
        return result;
    }

    public int getActiveCardLeft() {
        return this.activeCardLeft;
    }

    public int getActiveCardRight() {
        return this.activeCardRight;
    }

    public int getActiveCardCenter() {
        return this.activeCardCenter;
    }

    public int getCardWidth() {
        return this.cardWidth;
    }

    public float getCardsGap() {
        return this.cardsGap;
    }

    public LinearSmoothScroller getSmoothScroller(RecyclerView recyclerView) {
        return new LinearSmoothScroller(recyclerView.getContext()){

            public int calculateDxToMakeVisible(View view, int snapPreference) {
                int topViewLeft;
                int viewStart = CardSliderLayoutManager.this.getDecoratedLeft(view);
                if (viewStart > CardSliderLayoutManager.this.activeCardLeft) {
                    return CardSliderLayoutManager.this.activeCardLeft - viewStart;
                }
                int delta = 0;
                int topViewPos = 0;
                View topView = CardSliderLayoutManager.this.getTopView();
                if (topView != null && (topViewPos = CardSliderLayoutManager.this.getPosition(topView)) != this.getTargetPosition() && (topViewLeft = CardSliderLayoutManager.this.getDecoratedLeft(topView)) >= CardSliderLayoutManager.this.activeCardLeft && topViewLeft < CardSliderLayoutManager.this.activeCardRight) {
                    delta = CardSliderLayoutManager.this.activeCardRight - topViewLeft;
                }
                return delta + CardSliderLayoutManager.this.cardWidth * Math.max(0, topViewPos - this.getTargetPosition() - 1);
            }

            protected float calculateSpeedPerPixel(DisplayMetrics displayMetrics) {
                return 0.5f;
            }
        };
    }

    private ViewUpdater loadViewUpdater(Context context, String className, AttributeSet attrs) {
        ViewUpdater updater;
        if (className == null || className.trim().length() == 0) {
            return null;
        }
        String fullClassName = className.charAt(0) == '.' ? context.getPackageName() + className : (className.contains(".") ? className : CardSliderLayoutManager.class.getPackage().getName() + '.' + className);
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<ViewUpdater> viewUpdaterClass = classLoader.loadClass(fullClassName).asSubclass(ViewUpdater.class);
            Constructor<ViewUpdater> constructor = viewUpdaterClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            updater = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(attrs.getPositionDescription() + ": Error creating LayoutManager " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(attrs.getPositionDescription() + ": Unable to find ViewUpdater" + className, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the ViewUpdater: " + className, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(attrs.getPositionDescription() + ": Could not instantiate the ViewUpdater: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(attrs.getPositionDescription() + ": Cannot access non-public constructor " + className, e);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(attrs.getPositionDescription() + ": Class is not a ViewUpdater " + className, e);
        }
        return updater;
    }

    private int scrollRight(int dx) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        View rightestView = this.getChildAt(childCount - 1);
        int deltaBorder = this.activeCardLeft + this.getPosition(rightestView) * this.cardWidth;
        int delta = this.getAllowedRightDelta(rightestView, dx, deltaBorder);
        LinkedList<View> rightViews = new LinkedList<View>();
        LinkedList<View> leftViews = new LinkedList<View>();
        for (int i = childCount - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            int viewLeft = this.getDecoratedLeft(view);
            if (viewLeft >= this.activeCardRight) {
                rightViews.add(view);
                continue;
            }
            leftViews.add(view);
        }
        for (View view : rightViews) {
            int border = this.activeCardLeft + this.getPosition(view) * this.cardWidth;
            int allowedDelta = this.getAllowedRightDelta(view, dx, border);
            view.offsetLeftAndRight(-allowedDelta);
        }
        int step = this.activeCardLeft / 2;
        int jDelta = (int)Math.floor(1.0f * (float)delta * (float)step / (float)this.cardWidth);
        View prevView = null;
        int j = 0;
        int cnt = leftViews.size();
        for (int i = 0; i < cnt; ++i) {
            View view = (View)leftViews.get(i);
            if (prevView == null || this.getDecoratedLeft(prevView) >= this.activeCardRight) {
                border = this.activeCardLeft + this.getPosition(view) * this.cardWidth;
                int allowedDelta = this.getAllowedRightDelta(view, dx, border);
                view.offsetLeftAndRight(-allowedDelta);
            } else {
                border = this.activeCardLeft - step * j;
                view.offsetLeftAndRight(-this.getAllowedRightDelta(view, jDelta, border));
                ++j;
            }
            prevView = view;
        }
        return delta;
    }

    private int scrollLeft(int dx) {
        int childCount = this.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        View lastView = this.getChildAt(childCount - 1);
        boolean isLastItem = this.getPosition(lastView) == this.getItemCount() - 1;
        int delta = isLastItem ? Math.min(dx, this.getDecoratedRight(lastView) - this.activeCardRight) : dx;
        int step = this.activeCardLeft / 2;
        int jDelta = (int)Math.ceil(1.0f * (float)delta * (float)step / (float)this.cardWidth);
        for (int i = childCount - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            int viewLeft = this.getDecoratedLeft(view);
            if (viewLeft > this.activeCardLeft) {
                view.offsetLeftAndRight(this.getAllowedLeftDelta(view, delta, this.activeCardLeft));
                continue;
            }
            int border = this.activeCardLeft - step;
            for (int j = i; j >= 0; --j) {
                View jView = this.getChildAt(j);
                jView.offsetLeftAndRight(this.getAllowedLeftDelta(jView, jDelta, border));
                border -= step;
            }
            break;
        }
        return delta;
    }

    private int getAllowedLeftDelta(@NonNull View view, int dx, int border) {
        int viewLeft = this.getDecoratedLeft(view);
        if (viewLeft - dx > border) {
            return -dx;
        }
        return border - viewLeft;
    }

    private int getAllowedRightDelta(@NonNull View view, int dx, int border) {
        int viewLeft = this.getDecoratedLeft(view);
        if (viewLeft + Math.abs(dx) < border) {
            return dx;
        }
        return viewLeft - border;
    }

    private void layoutByCoords() {
        int count = Math.min(this.getChildCount(), this.cardsXCoords.size());
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            int viewLeft = this.cardsXCoords.get(this.getPosition(view));
            this.layoutDecorated(view, viewLeft, 0, viewLeft + this.cardWidth, this.getDecoratedBottom(view));
        }
        this.cardsXCoords.clear();
    }

    private void fill(int anchorPos, RecyclerView.Recycler recycler, RecyclerView.State state) {
        int i;
        this.viewCache.clear();
        int cnt = this.getChildCount();
        for (i = 0; i < cnt; ++i) {
            View view = this.getChildAt(i);
            int pos = this.getPosition(view);
            this.viewCache.put(pos, (Object)view);
        }
        cnt = this.viewCache.size();
        for (i = 0; i < cnt; ++i) {
            this.detachView((View)this.viewCache.valueAt(i));
        }
        if (!state.isPreLayout()) {
            this.fillLeft(anchorPos, recycler);
            this.fillRight(anchorPos, recycler);
        }
        cnt = this.viewCache.size();
        for (i = 0; i < cnt; ++i) {
            recycler.recycleView((View)this.viewCache.valueAt(i));
        }
    }

    private void fillLeft(int anchorPos, RecyclerView.Recycler recycler) {
        int pos;
        if (anchorPos == -1) {
            return;
        }
        int layoutStep = this.activeCardLeft / 2;
        int viewLeft = Math.max(-1, 2 - (anchorPos - pos)) * layoutStep;
        for (pos = Math.max(0, anchorPos - 2 - 1); pos < anchorPos; ++pos) {
            View view = (View)this.viewCache.get(pos);
            if (view != null) {
                this.attachView(view);
                this.viewCache.remove(pos);
            } else {
                view = recycler.getViewForPosition(pos);
                this.addView(view);
                this.measureChildWithMargins(view, 0, 0);
                int viewHeight = this.getDecoratedMeasuredHeight(view);
                this.layoutDecorated(view, viewLeft, 0, viewLeft + this.cardWidth, viewHeight);
            }
            viewLeft += layoutStep;
        }
    }

    private void fillRight(int anchorPos, RecyclerView.Recycler recycler) {
        if (anchorPos == -1) {
            return;
        }
        int width = this.getWidth();
        int itemCount = this.getItemCount();
        int viewLeft = this.activeCardLeft;
        boolean fillRight = true;
        for (int pos = anchorPos; fillRight && pos < itemCount; ++pos) {
            View view = (View)this.viewCache.get(pos);
            if (view != null) {
                this.attachView(view);
                this.viewCache.remove(pos);
            } else {
                view = recycler.getViewForPosition(pos);
                this.addView(view);
                this.measureChildWithMargins(view, 0, 0);
                int viewHeight = this.getDecoratedMeasuredHeight(view);
                this.layoutDecorated(view, viewLeft, 0, viewLeft + this.cardWidth, viewHeight);
            }
            viewLeft = this.getDecoratedRight(view);
            fillRight = viewLeft < width + this.cardWidth;
        }
    }

    private void updateViewScale() {
        int cnt = this.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            View view = this.getChildAt(i);
            int viewLeft = this.getDecoratedLeft(view);
            float position = (float)(viewLeft - this.activeCardLeft) / (float)this.cardWidth;
            this.viewUpdater.updateView(view, position);
        }
    }

    public static interface ViewUpdater {
        public void onLayoutManagerInitialized(@NonNull CardSliderLayoutManager var1);

        public void updateView(@NonNull View var1, float var2);
    }

    private static class SavedState
    implements Parcelable {
        int anchorPos;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState() {
        }

        SavedState(Parcel in) {
            this.anchorPos = in.readInt();
        }

        public SavedState(SavedState other) {
            this.anchorPos = other.anchorPos;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.anchorPos);
        }
    }
}

