/*
 * Decompiled with CFR 0.152.
 */
package mx.platacard.pagerindicator.internal;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ranges.RangesKt;
import mx.platacard.pagerindicator.internal.DotState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0000\u00a8\u0006\t"}, d2={"calculateVisibleDotIndices", "Lkotlin/Pair;", "", "dotCount", "currentPage", "pageCount", "calculateTargetDotSizeForPage", "Lmx/platacard/pagerindicator/internal/DotState;", "i", "pagerindicator_release"})
public final class CalculationsKt {
    @NotNull
    public static final Pair<Integer, Integer> calculateVisibleDotIndices(int dotCount, int currentPage, int pageCount) {
        int firstVisible = 0;
        int lastVisible = 0;
        if (currentPage < pageCount / 2) {
            firstVisible = RangesKt.coerceAtLeast((int)(currentPage - dotCount / 2), (int)0);
            lastVisible = firstVisible + (dotCount - 1);
        } else {
            lastVisible = RangesKt.coerceAtMost((int)(currentPage + dotCount / 2), (int)(pageCount - 1));
            firstVisible = lastVisible - (dotCount - 1);
        }
        return TuplesKt.to((Object)firstVisible, (Object)lastVisible);
    }

    @NotNull
    public static final DotState calculateTargetDotSizeForPage(int i, int currentPage, int pageCount, int dotCount) {
        DotState dotState;
        block1: {
            int lastVisible;
            int firstVisible;
            int onTheSidesDotCount;
            block0: {
                onTheSidesDotCount = dotCount / 2;
                Pair<Integer, Integer> pair = CalculationsKt.calculateVisibleDotIndices(dotCount, currentPage, pageCount);
                firstVisible = ((Number)pair.component1()).intValue();
                lastVisible = ((Number)pair.component2()).intValue();
                if (currentPage != i) break block0;
                dotState = DotState.Selected;
                break block1;
            }
            int n = -(onTheSidesDotCount - 1);
            int n2 = currentPage - i;
            dotState = (n <= n2 ? n2 < onTheSidesDotCount : false) ? DotState.Normal : (currentPage + onTheSidesDotCount >= pageCount && i > currentPage - (dotCount - (pageCount - currentPage - 1) - 1) ? DotState.Normal : (currentPage - onTheSidesDotCount <= 0 && i < currentPage + (dotCount - currentPage - 1) ? DotState.Normal : (currentPage + onTheSidesDotCount == i && i == pageCount - 1 ? DotState.Normal : (dotCount == pageCount ? DotState.Normal : ((firstVisible <= i ? i <= lastVisible : false) ? DotState.SmallEdge : DotState.Invisible)))));
        }
        return dotState;
    }
}

