/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.HashSet;
import java.util.Vector;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.RuntimeOperationsException;

public class AttributeChangeNotificationFilter
implements NotificationFilter {
    private static final long serialVersionUID = -6347317584796410029L;
    private static final String serialName = "enabledAttributes";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("enabledAttributes", class$java$util$Vector == null ? (class$java$util$Vector = AttributeChangeNotificationFilter.class$("java.util.Vector")) : class$java$util$Vector)};
    private HashSet m_enabledAttributes = new HashSet();
    static /* synthetic */ Class class$java$util$Vector;

    public int hashCode() {
        return this.m_enabledAttributes.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            AttributeChangeNotificationFilter other = (AttributeChangeNotificationFilter)obj;
            return this.m_enabledAttributes.equals(other.m_enabledAttributes);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void enableAttribute(String name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Name cannot be null"));
        }
        HashSet hashSet = this.m_enabledAttributes;
        synchronized (hashSet) {
            if (!this.m_enabledAttributes.contains(name)) {
                this.m_enabledAttributes.add(name);
            }
        }
    }

    public void disableAttribute(String name) {
        if (name != null) {
            HashSet hashSet = this.m_enabledAttributes;
            synchronized (hashSet) {
                this.m_enabledAttributes.remove(name);
            }
        }
    }

    public void disableAllAttributes() {
        HashSet hashSet = this.m_enabledAttributes;
        synchronized (hashSet) {
            this.m_enabledAttributes.clear();
        }
    }

    public Vector getEnabledAttributes() {
        HashSet hashSet = this.m_enabledAttributes;
        synchronized (hashSet) {
            Vector v;
            Vector vector = v = new Vector(this.m_enabledAttributes);
            return vector;
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (!(notification instanceof AttributeChangeNotification)) {
            return false;
        }
        AttributeChangeNotification n = (AttributeChangeNotification)notification;
        if (!"jmx.attribute.change".equals(n.getType())) {
            return false;
        }
        String attributeName = n.getAttributeName();
        if (attributeName != null) {
            HashSet hashSet = this.m_enabledAttributes;
            synchronized (hashSet) {
                if (this.m_enabledAttributes.contains(attributeName)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        Vector vector = (Vector)fields.get(serialName, null);
        if (fields.defaulted(serialName)) {
            throw new IOException("Serialized stream corrupted: expecting a non-null Vector");
        }
        if (this.m_enabledAttributes == null) {
            this.m_enabledAttributes = new HashSet();
        }
        this.m_enabledAttributes.clear();
        this.m_enabledAttributes.addAll(vector);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        Vector vector = this.getEnabledAttributes();
        fields.put(serialName, vector);
        out.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

