/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.AttributeNotFoundException;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.BooleanValueExp;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.StringValueExp;
import javax.management.ValueExp;

public class AttributeValueExp
implements ValueExp {
    private static final long serialVersionUID = -7768025046539163385L;
    private String attr;
    private transient MBeanServer server;

    public AttributeValueExp() {
    }

    public AttributeValueExp(String attr) {
        this.attr = attr;
    }

    public String getAttributeName() {
        return this.attr;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        try {
            Object value = this.getAttribute(name);
            if (value == null) {
                return this.createValueExp(name);
            }
            if (value instanceof Number) {
                return new NumericValueExp((Number)value);
            }
            if (value instanceof Boolean) {
                return new BooleanValueExp((Boolean)value);
            }
            if (value instanceof String) {
                return new StringValueExp((String)value);
            }
            throw new BadAttributeValueExpException(value);
        }
        catch (RuntimeOperationsException x) {
            throw new BadAttributeValueExpException((Object)this.getAttributeName());
        }
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    protected Object getAttribute(ObjectName name) {
        try {
            return this.server.getAttribute(name, this.getAttributeName());
        }
        catch (MBeanException x) {
        }
        catch (AttributeNotFoundException x) {
        }
        catch (InstanceNotFoundException x) {
        }
        catch (ReflectionException x) {
            // empty catch block
        }
        throw new RuntimeOperationsException();
    }

    private ValueExp createValueExp(final ObjectName name) throws BadAttributeValueExpException {
        try {
            MBeanInfo info = (MBeanInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AttributeValueExp.this.server.getMBeanInfo(name);
                }
            });
            MBeanAttributeInfo[] attrs = info.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                MBeanAttributeInfo attribute = attrs[i];
                if (attribute.getName().equals(this.getAttributeName())) {
                    String type = attribute.getType();
                    if (type.equals("java.lang.String")) {
                        return new StringValueExp(null);
                    }
                    throw new BadAttributeValueExpException((Object)null);
                }
                ++i;
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        throw new BadAttributeValueExpException((Object)null);
    }
}

