/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;
import mx4j.log.Log;
import mx4j.log.Logger;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    ObjectName objectName;
    String attribute;
    long granularity = 10000L;
    boolean isActive = false;
    transient boolean errorNotified = false;
    transient boolean mBeanFound = true;
    MBeanServer server;
    static Timer notificationTimer = new Timer();
    static long notificationID = 0L;
    MonitorTask monitorTask = null;

    static synchronized long createNotificationID() {
        return ++notificationID;
    }

    abstract void executeMonitor(Object var1);

    Logger getLogger() {
        return Log.getLogger("jmx.mbean." + this.getClass().getName());
    }

    public abstract void start();

    synchronized void doStart() {
        if (!this.isActive) {
            this.getLogger().info("Starting monitor " + this + " every " + this.granularity + " milliseconds");
            this.isActive = true;
            this.errorNotified = false;
            this.monitorTask = new MonitorTask();
            notificationTimer.scheduleAtFixedRate((TimerTask)this.monitorTask, 0L, this.granularity);
        }
    }

    public abstract void stop();

    synchronized void doStop() {
        if (this.isActive) {
            this.getLogger().info("Stopping monitor " + this.toString());
            this.isActive = false;
            this.monitorTask.cancel();
        }
    }

    public ObjectName getObservedObject() {
        return this.objectName;
    }

    public synchronized void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("The observed object name cannot be null");
        }
        this.errorNotified = false;
        this.objectName = objectName;
    }

    public String getObservedAttribute() {
        return this.attribute;
    }

    public synchronized void setObservedAttribute(String attribute) throws IllegalArgumentException {
        if (attribute == null) {
            throw new IllegalArgumentException("The observed attribute cannot be null");
        }
        this.errorNotified = true;
        this.attribute = attribute;
    }

    public long getGranularityPeriod() {
        return this.granularity;
    }

    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("The monitoring period can't be negative or zero");
        }
        this.granularity = period;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.getLogger().info("Pre register of monitor " + this.toString());
        this.server = server;
        this.errorNotified = false;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.getLogger().info("Pre deregister of monitor " + this.toString());
        this.stop();
    }

    public void postDeregister() {
    }

    void notifyListeners(String type, ObjectName objectName) {
        MonitorNotification not = new MonitorNotification(type, this, Monitor.createNotificationID(), System.currentTimeMillis(), "", objectName, null, null, null);
        this.sendNotification(not);
    }

    void notifyListeners(String type, ObjectName objectName, String attribute) {
        MonitorNotification not = new MonitorNotification(type, this, Monitor.createNotificationID(), System.currentTimeMillis(), "", objectName, attribute, null, null);
        this.sendNotification(not);
    }

    void notifyListeners(String type, ObjectName objectName, String attribute, Throwable e) {
        MonitorNotification not = new MonitorNotification(type, this, Monitor.createNotificationID(), System.currentTimeMillis(), e.toString(), objectName, attribute, null, null);
        this.sendNotification(not);
    }

    public String toString() {
        return (this.objectName != null ? this.objectName.toString() : "?") + " attribute " + this.attribute;
    }

    private class MonitorTask
    extends TimerTask {
        private MonitorTask() {
        }

        public void run() {
            try {
                if (Monitor.this.isActive()) {
                    if (Monitor.this.objectName == null) {
                        Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " object name " + Monitor.this.objectName + " not found");
                        if (!Monitor.this.errorNotified) {
                            Monitor.this.notifyListeners("jmx.monitor.error.mbean", Monitor.this.objectName);
                        }
                        Monitor.this.errorNotified = true;
                        return;
                    }
                    Monitor.this.getLogger().info("Execute monitor " + Monitor.this.toString());
                    if (!Monitor.this.server.isRegistered(Monitor.this.objectName)) {
                        Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " object name " + Monitor.this.objectName + " not found");
                        if (Monitor.this.mBeanFound) {
                            Monitor.this.mBeanFound = false;
                            Monitor.this.notifyListeners("jmx.monitor.error.mbean", Monitor.this.objectName);
                        }
                        return;
                    }
                    Monitor.this.mBeanFound = true;
                    if (Monitor.this.errorNotified) {
                        return;
                    }
                    MBeanInfo info = Monitor.this.server.getMBeanInfo(Monitor.this.objectName);
                    MBeanAttributeInfo[] attributes = info.getAttributes();
                    boolean found = false;
                    if (attributes != null) {
                        int i = 0;
                        while (i < attributes.length) {
                            if (attributes[i].getName().equals(Monitor.this.attribute)) {
                                found = true;
                            }
                            ++i;
                        }
                    }
                    if (!found) {
                        Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " attribute " + Monitor.this.attribute + " not found");
                        Monitor.this.errorNotified = true;
                        Monitor.this.notifyListeners("jmx.monitor.error.attribute", Monitor.this.objectName, Monitor.this.attribute);
                        return;
                    }
                    Object attributeValue = Monitor.this.server.getAttribute(Monitor.this.objectName, Monitor.this.attribute);
                    if (attributeValue == null) {
                        Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " attribute " + Monitor.this.attribute + " is null");
                        Monitor.this.errorNotified = true;
                        Monitor.this.notifyListeners("jmx.monitor.error.type", Monitor.this.objectName, Monitor.this.attribute);
                        return;
                    }
                    Monitor.this.executeMonitor(attributeValue);
                }
            }
            catch (Exception e) {
                Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " object name " + Monitor.this.objectName + " not found");
                Monitor.this.errorNotified = true;
                Monitor.this.notifyListeners("jmx.monitor.error.runtime", Monitor.this.objectName, Monitor.this.attribute, e);
            }
        }
    }
}

