/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.security.Permission;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.util.Utils;

public final class MBeanPermission
extends Permission {
    private String m_actions;
    private transient int m_hash;
    private transient String m_targetName;
    private transient ObjectName m_objectName;
    private transient ArrayList m_actionsList;

    public MBeanPermission(String name) {
        this(name, null);
    }

    public MBeanPermission(String name, String actions) {
        super(name);
        this.m_actions = actions;
        this.parse(name, actions);
    }

    private void parse(String name, String actions) {
        this.m_targetName = this.parseTargetName(name);
        this.m_objectName = this.parseObjectName(name);
        this.m_actionsList = this.parseActions(actions);
    }

    public int hashCode() {
        if (this.m_hash == 0) {
            this.m_hash = this.computeHash();
        }
        return this.m_hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            ArrayList otherActions;
            MBeanPermission other = (MBeanPermission)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            ArrayList thisActions = this.getActionsList();
            if (thisActions.containsAll(otherActions = other.getActionsList()) && otherActions.containsAll(thisActions)) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public String getActions() {
        return this.m_actions;
    }

    public String getTargetName() {
        return this.m_targetName;
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    private ArrayList getActionsList() {
        return this.m_actionsList;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission permission = (MBeanPermission)p;
        if (!this.impliesTargetName(permission)) {
            return false;
        }
        if (!this.impliesObjectName(permission)) {
            return false;
        }
        return this.impliesActions(permission);
    }

    private boolean impliesTargetName(MBeanPermission p) {
        boolean otherWildcard;
        boolean thisWildcard;
        String thisName = this.getTargetName();
        String otherName = p.getTargetName();
        boolean bl = thisWildcard = thisName.endsWith(".*") || thisName.equals("*");
        if (thisWildcard) {
            thisName = thisName.substring(0, thisName.length() - 1);
        }
        boolean bl2 = otherWildcard = otherName.endsWith(".*") || otherName.equals("*");
        if (otherWildcard) {
            otherName = otherName.substring(0, otherName.length() - 1);
        }
        if (thisWildcard) {
            if (otherWildcard) {
                return otherName.startsWith(thisName);
            }
            return otherName.length() > thisName.length() && otherName.startsWith(thisName);
        }
        if (otherWildcard) {
            return false;
        }
        return thisName.equals(otherName);
    }

    private boolean impliesObjectName(MBeanPermission p) {
        boolean otherDomainIsPattern;
        String thisDomain;
        ObjectName otherName;
        ObjectName thisName = this.getObjectName();
        if (thisName == null) {
            try {
                thisName = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        if ((otherName = p.getObjectName()) == null) {
            try {
                otherName = new ObjectName("*:*");
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
        }
        boolean thisDomainIsPattern = (thisDomain = thisName.getDomain()).indexOf(42) >= 0 || thisDomain.indexOf(63) >= 0;
        String otherDomain = otherName.getDomain();
        boolean bl = otherDomainIsPattern = otherDomain.indexOf(42) >= 0 || otherDomain.indexOf(63) >= 0;
        if (!thisDomainIsPattern && otherDomainIsPattern) {
            return false;
        }
        if (!(thisDomainIsPattern || otherDomainIsPattern || thisDomain.equals(otherDomain))) {
            return false;
        }
        if (!Utils.wildcardMatch(thisDomain, otherDomain)) {
            return false;
        }
        Hashtable thisProperties = thisName.getKeyPropertyList();
        boolean thisPropertiesIsPattern = thisName.isPropertyPattern();
        Hashtable otherProperties = otherName.getKeyPropertyList();
        boolean otherPropertiesIsPattern = otherName.isPropertyPattern();
        if (!thisPropertiesIsPattern && otherPropertiesIsPattern) {
            return false;
        }
        if (!(thisPropertiesIsPattern || otherPropertiesIsPattern || thisProperties.equals(otherProperties))) {
            return false;
        }
        return !thisPropertiesIsPattern || otherProperties.entrySet().containsAll(thisProperties.entrySet());
    }

    private boolean impliesActions(MBeanPermission p) {
        ArrayList otherActions = p.getActionsList();
        return this.getActionsList().containsAll(otherActions);
    }

    private String parseTargetName(String name) {
        String cls;
        if (name == null) {
            throw new IllegalArgumentException("Target name cannot be null");
        }
        String target = name.trim();
        int square = target.indexOf(91);
        if (square >= 0) {
            target = target.substring(0, square).trim();
        }
        if (target.length() == 0) {
            throw new IllegalArgumentException("Target name cannot be empty");
        }
        int pound = target.indexOf(35);
        if (pound >= 0 && (cls = target.substring(0, pound).trim()).length() == 0) {
            throw new IllegalArgumentException("MBean class name cannot be empty");
        }
        int wildPound = target.indexOf("*#");
        if (wildPound >= 0) {
            throw new IllegalArgumentException("Invalid wildcard, use only '*'");
        }
        return target.replace('#', '.');
    }

    private ObjectName parseObjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Target name cannot be null");
        }
        String target = name.trim();
        int open = target.indexOf(91);
        if (open < 0) {
            return null;
        }
        int close = target.indexOf(93);
        if (close < 0) {
            throw new IllegalArgumentException("Missing closing ObjectName bracket");
        }
        if (target.substring(open + 1, close).trim().length() == 0) {
            throw new IllegalArgumentException("Empty string in ObjectName brackets");
        }
        String objectNameString = target.substring(open + 1, close);
        try {
            ObjectName objectName = new ObjectName(objectNameString);
            return objectName;
        }
        catch (MalformedObjectNameException x) {
            throw new IllegalArgumentException("Invalid ObjectName");
        }
    }

    private ArrayList parseActions(String actions) {
        ArrayList<String> list = new ArrayList<String>();
        if (actions != null) {
            StringTokenizer tokenizer = new StringTokenizer(actions, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() <= 0) continue;
                list.add(token);
            }
        }
        Collections.sort(list);
        return list;
    }

    private int computeHash() {
        int hash = this.getName().hashCode();
        return hash ^= ((AbstractList)this.getActionsList()).hashCode();
    }
}

