/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.HashMap;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorMBean;

public class CounterMonitor
extends Monitor
implements MonitorMBean,
CounterMonitorMBean {
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number modulus = new Integer(0);
    private Number offset = new Integer(0);
    private Number initThreshold = new Integer(0);
    private HashMap counterInfos = new HashMap();
    private transient Class type = NONE;
    private static final Class NONE = null;
    private static final Class INT = class$java$lang$Integer == null ? (class$java$lang$Integer = CounterMonitor.class$("java.lang.Integer")) : class$java$lang$Integer;
    private static final Class LONG = class$java$lang$Long == null ? (class$java$lang$Long = CounterMonitor.class$("java.lang.Long")) : class$java$lang$Long;
    private static final Class BYTE = class$java$lang$Byte == null ? (class$java$lang$Byte = CounterMonitor.class$("java.lang.Byte")) : class$java$lang$Byte;
    private static final Class SHORT = class$java$lang$Short == null ? (class$java$lang$Short = CounterMonitor.class$("java.lang.Short")) : class$java$lang$Short;
    private static final MBeanNotificationInfo[] notificationInfos = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"}, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
    long time = System.currentTimeMillis();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    public synchronized void start() {
        this.doStart();
    }

    public synchronized void stop() {
        this.doStop();
    }

    void executeMonitor(ObjectName objectName, Object attributeValue) {
        CounterInfo ct = (CounterInfo)this.counterInfos.get(objectName);
        Number threshold = ct.getThreshold();
        if (!(threshold != null && threshold.longValue() != 0L || this.errorNotified)) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" threshold value is null or zero"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        if (!(attributeValue instanceof Number) && !this.errorNotified) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" attribute is not a Number"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.determineType(attributeValue, ct);
        if (this.type == NONE && !this.errorNotified) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" attribute, threshold, offset and modules types don't match"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.calculateDerivedGauge((Number)attributeValue, objectName);
        if (!ct.getWasNotified()) {
            if (((Number)attributeValue).longValue() >= threshold.longValue()) {
                if (this.modulus != null && this.modulus.longValue() > 0L && ((Number)attributeValue).longValue() >= this.modulus.longValue()) {
                    ct.setThreshold(this.initThreshold);
                } else if (this.offset != null && this.offset.longValue() > 0L) {
                    while (ct.getThreshold().longValue() <= ((Number)attributeValue).longValue()) {
                        ct.setThreshold(this.createNumber(ct.getThreshold().longValue() + this.offset.longValue()));
                    }
                }
                if (this.notify) {
                    this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                    this.notifyListeners("jmx.monitor.counter.threshold", objectName, this.attribute);
                }
            }
            ct.setWasNotified(true);
        }
    }

    void determineType(Object attributeValue, CounterInfo counter) {
        Class<?> targetClass = attributeValue.getClass();
        if (counter.getThreshold() != null) {
            if (targetClass.equals(counter.getThreshold().getClass())) {
                boolean match = true;
                if (this.offset != null && !targetClass.equals(this.offset.getClass())) {
                    match = false;
                }
                if (this.modulus != null && !targetClass.equals(this.modulus.getClass())) {
                    match = false;
                }
                if (targetClass != INT && targetClass != LONG && targetClass != BYTE && targetClass != SHORT) {
                    match = false;
                }
                if (match) {
                    this.type = targetClass;
                }
            } else {
                this.type = NONE;
            }
        } else {
            this.type = NONE;
        }
    }

    void calculateDerivedGauge(Number attributeValue, ObjectName objectName) {
        CounterInfo ct = (CounterInfo)this.counterInfos.get(objectName);
        ct.setLastDerivatedGaugeTimestamp(System.currentTimeMillis());
        if (this.differenceMode && ct.getLastValue() != null) {
            long difference = attributeValue.longValue() - ct.getLastValue().longValue();
            if (this.modulus != null && this.modulus.longValue() > 0L && attributeValue.longValue() > this.modulus.longValue()) {
                difference = attributeValue.longValue() - this.modulus.longValue();
            }
            ct.setLastDerivatedGauge(this.createNumber(difference));
        }
        if (ct.getLastValue() != null && !ct.getLastValue().equals(attributeValue)) {
            ct.setWasNotified(false);
        }
        ct.setLastValue(attributeValue);
    }

    Number createNumber(long value) {
        Number result = null;
        if (this.type == INT) {
            result = new Integer((int)value);
        } else if (this.type == LONG) {
            result = new Long(value);
        } else if (this.type == SHORT) {
            result = new Short((short)value);
        } else if (this.type == BYTE) {
            result = new Byte((byte)value);
        }
        return result;
    }

    public Number getDerivedGauge() {
        return this.getDerivedGauge(this.getObservedObject());
    }

    public Number getDerivedGauge(ObjectName objectName) {
        CounterInfo ct = (CounterInfo)this.counterInfos.get(objectName);
        return ct != null ? (Number)ct.getLastDerivatedGauge() : (Number)null;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.getDerivedGaugeTimeStamp(this.getObservedObject());
    }

    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        CounterInfo ct = (CounterInfo)this.counterInfos.get(objectName);
        return ct != null ? ct.getLastDerivatedGaugeTimestamp() : 0L;
    }

    public Number getThreshold() {
        return this.getThreshold(this.getObservedObject());
    }

    public Number getThreshold(ObjectName objectName) {
        CounterInfo ct = (CounterInfo)this.counterInfos.get(objectName);
        return ct != null ? (Number)ct.getThreshold() : (Number)null;
    }

    public Number getInitThreshold() {
        return this.initThreshold;
    }

    public synchronized void setInitThreshold(Number value) throws IllegalArgumentException {
        if (value == null || value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold value has to be a valid number higher than 0");
        }
        this.initThreshold = value;
        for (int i = 0; i < this.objectNames.size(); ++i) {
            CounterInfo ct = (CounterInfo)this.counterInfos.get(this.objectNames.get(i));
            ct.setThreshold(value);
            ct.setLastValue(null);
            ct.setWasNotified(false);
        }
    }

    public void setThreshold(Number value) throws IllegalArgumentException {
        this.setInitThreshold(value);
    }

    public Number getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(Number value) throws IllegalArgumentException {
        if (value == null || value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold value has to be a valid number higher than 0");
        }
        this.offset = value;
        for (int i = 0; i < this.objectNames.size(); ++i) {
            CounterInfo ct = (CounterInfo)this.counterInfos.get(this.objectNames.get(i));
            ct.setWasNotified(false);
        }
    }

    public Number getModulus() {
        return this.modulus;
    }

    public void setModulus(Number value) throws IllegalArgumentException {
        if (value == null || value.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold value has to be a valid number higher than 0");
        }
        this.modulus = value;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean value) {
        this.notify = value;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public String toString() {
        return "CounterMonitor on " + super.toString();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notificationInfos;
    }

    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        super.addObservedObject(objectName);
        this.counterInfos.put(objectName, new CounterInfo());
    }

    public void removeObservedObject(ObjectName objectName) {
        super.removeObservedObject(objectName);
        this.counterInfos.remove(objectName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CounterInfo {
        private Number lastDerivatedGauge = new Integer(0);
        private long lastDerivatedGaugeTimestamp = 0L;
        private transient Number lastValue = null;
        private transient Number threshold = null;
        private transient boolean wasNotified = false;
        private transient boolean errorNotified = false;

        CounterInfo() {
        }

        public boolean getErrorNotified() {
            return this.errorNotified;
        }

        public void setErrorNotified(boolean errorNotified) {
            this.errorNotified = errorNotified;
        }

        public Number getLastDerivatedGauge() {
            return this.lastDerivatedGauge;
        }

        public void setLastDerivatedGauge(Number lastDerivatedGauge) {
            this.lastDerivatedGauge = lastDerivatedGauge;
        }

        public long getLastDerivatedGaugeTimestamp() {
            return this.lastDerivatedGaugeTimestamp;
        }

        public void setLastDerivatedGaugeTimestamp(long lastDerivatedGaugeTimestamp) {
            this.lastDerivatedGaugeTimestamp = lastDerivatedGaugeTimestamp;
        }

        public Number getLastValue() {
            return this.lastValue;
        }

        public void setLastValue(Number lastValue) {
            this.lastValue = lastValue;
        }

        public Number getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Number threshold) {
            this.threshold = threshold;
        }

        public boolean getWasNotified() {
            return this.wasNotified;
        }

        public void setWasNotified(boolean wasNotified) {
            this.wasNotified = wasNotified;
        }
    }
}

