/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.HashMap;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorMBean;

public class GaugeMonitor
extends Monitor
implements MonitorMBean,
GaugeMonitorMBean {
    private static final Integer NULLINTEGER = new Integer(0);
    private static final Class NONE = null;
    private static final Class INT = class$java$lang$Integer == null ? (class$java$lang$Integer = GaugeMonitor.class$("java.lang.Integer")) : class$java$lang$Integer;
    private static final Class LONG = class$java$lang$Long == null ? (class$java$lang$Long = GaugeMonitor.class$("java.lang.Long")) : class$java$lang$Long;
    private static final Class BYTE = class$java$lang$Byte == null ? (class$java$lang$Byte = GaugeMonitor.class$("java.lang.Byte")) : class$java$lang$Byte;
    private static final Class SHORT = class$java$lang$Short == null ? (class$java$lang$Short = GaugeMonitor.class$("java.lang.Short")) : class$java$lang$Short;
    private static final Class FLOAT = class$java$lang$Float == null ? (class$java$lang$Float = GaugeMonitor.class$("java.lang.Float")) : class$java$lang$Float;
    private static final Class DOUBLE = class$java$lang$Double == null ? (class$java$lang$Double = GaugeMonitor.class$("java.lang.Double")) : class$java$lang$Double;
    private Number highThreshold = NULLINTEGER;
    private Number lowThreshold = NULLINTEGER;
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient boolean errorNotified = false;
    private transient Class type = NONE;
    private transient boolean isLong = false;
    private HashMap infos = new HashMap();
    private static final MBeanNotificationInfo[] notificationInfos = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"}, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public synchronized void start() {
        this.doStart();
    }

    public synchronized void stop() {
        this.doStop();
    }

    void executeMonitor(ObjectName objectName, Object attributeValue) {
        GaugeInfo gi = (GaugeInfo)this.infos.get(objectName);
        if (!(this.highThreshold != null && this.highThreshold != NULLINTEGER || this.errorNotified)) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" threshold value is null or zero"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        if (!(this.lowThreshold != null && this.lowThreshold != NULLINTEGER || this.errorNotified)) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" threshold value is null or zero"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        if (!(attributeValue instanceof Number) && !this.errorNotified) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" attribute is not a Number"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.determineType(attributeValue);
        if (this.type == NONE && !this.errorNotified) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" attribute, threshold, offset and modules types don't match"));
            this.notifyListeners("jmx.monitor.error.threshold", objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.calculateDerivedGauge(gi, (Number)attributeValue);
        if (this.isLong) {
            if (((Number)attributeValue).longValue() >= this.highThreshold.longValue()) {
                if (!gi.isHighNotified() && this.notifyHigh) {
                    this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                    this.notifyListeners("jmx.monitor.gauge.high", objectName, this.attribute);
                    gi.setHighNotified(true);
                    gi.setLowNotified(false);
                }
                if (!this.notifyHigh) {
                    gi.setLowNotified(false);
                }
            }
            if (((Number)attributeValue).longValue() <= this.lowThreshold.longValue()) {
                if (!gi.isLowNotified() && this.notifyLow) {
                    this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                    this.notifyListeners("jmx.monitor.gauge.low", objectName, this.attribute);
                    gi.setLowNotified(true);
                    gi.setHighNotified(false);
                }
                if (!this.notifyLow) {
                    gi.setHighNotified(false);
                }
            }
        } else {
            if (((Number)attributeValue).doubleValue() >= this.highThreshold.doubleValue()) {
                if (!gi.isHighNotified() && this.notifyHigh) {
                    this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                    this.notifyListeners("jmx.monitor.gauge.high", objectName, this.attribute);
                    gi.setHighNotified(true);
                    gi.setLowNotified(false);
                }
                if (!this.notifyHigh) {
                    gi.setLowNotified(false);
                }
            }
            if (((Number)attributeValue).doubleValue() <= this.lowThreshold.doubleValue()) {
                if (!gi.isLowNotified() && this.notifyLow) {
                    this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                    this.notifyListeners("jmx.monitor.gauge.low", objectName, this.attribute);
                    gi.setLowNotified(true);
                    gi.setHighNotified(false);
                }
                if (!this.notifyLow) {
                    gi.setHighNotified(false);
                }
            }
        }
    }

    void determineType(Object attributeValue) {
        Class<?> targetClass = attributeValue.getClass();
        if (this.highThreshold != null && this.lowThreshold != null) {
            if (this.highThreshold.getClass().equals(this.lowThreshold.getClass()) && this.highThreshold.getClass().equals(targetClass)) {
                boolean match = true;
                if (targetClass != INT && targetClass != LONG && targetClass != BYTE && targetClass != SHORT && targetClass != FLOAT && targetClass != DOUBLE) {
                    match = false;
                }
                if (match) {
                    this.type = targetClass;
                    this.isLong = !targetClass.equals(FLOAT) && !targetClass.equals(DOUBLE);
                }
            } else {
                this.type = NONE;
            }
        } else {
            this.type = NONE;
        }
    }

    void calculateDerivedGauge(GaugeInfo gi, Number attributeValue) {
        gi.setLastDerivatedGaugeTimestamp(System.currentTimeMillis());
        if (this.differenceMode) {
            if (gi.getLastValue() != null) {
                if (this.isLong) {
                    long difference = attributeValue.longValue() - gi.getLastValue().longValue();
                    gi.setLastDerivatedGauge(this.createNumber(difference));
                } else {
                    double difference = attributeValue.doubleValue() - gi.getLastValue().doubleValue();
                    gi.setLastDerivatedGauge(this.createNumber(difference));
                }
            }
        } else {
            gi.setLastDerivatedGauge(attributeValue);
        }
        gi.setLastValue(attributeValue);
    }

    Number createNumber(long value) {
        Number result = null;
        if (this.type == INT) {
            result = new Integer((int)value);
        } else if (this.type == LONG) {
            result = new Long(value);
        } else if (this.type == SHORT) {
            result = new Short((short)value);
        } else if (this.type == BYTE) {
            result = new Byte((byte)value);
        } else {
            this.getLogger().error((Object)("Invalid type " + this.type + " in createNumber(long)"));
        }
        return result;
    }

    Number createNumber(double value) {
        Number result = null;
        if (this.type == FLOAT) {
            result = new Float((float)value);
        } else if (this.type == DOUBLE) {
            result = new Double(value);
        } else {
            this.getLogger().error((Object)("Invalid type " + this.type + " in createNumber(double)"));
        }
        return result;
    }

    public synchronized Number getDerivedGauge() {
        if (this.objectNames.size() == 0) {
            return null;
        }
        return this.getDerivedGauge((ObjectName)this.objectNames.get(0));
    }

    public Number getDerivedGauge(ObjectName objectName) {
        return ((GaugeInfo)this.infos.get(objectName)).getLastDerivatedGauge();
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.objectNames.size() == 0) {
            return 0L;
        }
        return this.getDerivedGaugeTimeStamp((ObjectName)this.objectNames.get(0));
    }

    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        return ((GaugeInfo)this.infos.get(objectName)).getLastDerivatedGaugeTimestamp();
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException("Threshold values cannot be null");
        }
        if (!highValue.getClass().equals(lowValue.getClass())) {
            throw new IllegalArgumentException("Threshold need to be of the same class");
        }
        if (highValue.doubleValue() < lowValue.doubleValue()) {
            throw new IllegalArgumentException("High threshold value must be greater than low threshold value");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public void setNotifyHigh(boolean value) {
        this.notifyHigh = value;
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    public void setNotifyLow(boolean value) {
        this.notifyLow = value;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notificationInfos;
    }

    public String toString() {
        return "GaugeMonitor on " + super.toString();
    }

    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        super.addObservedObject(objectName);
        this.infos.put(objectName, new GaugeInfo());
    }

    public void removeObservedObject(ObjectName objectName) {
        super.removeObservedObject(objectName);
        this.infos.remove(objectName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class GaugeInfo {
        Number lastDerivatedGauge = new Integer(0);
        long lastDerivatedGaugeTimestamp = 0L;
        boolean highNotified = false;
        boolean lowNotified = false;
        Number lastValue = null;

        public Number getLastDerivatedGauge() {
            return this.lastDerivatedGauge;
        }

        public void setLastDerivatedGauge(Number lastDerivatedGauge) {
            this.lastDerivatedGauge = lastDerivatedGauge;
        }

        public long getLastDerivatedGaugeTimestamp() {
            return this.lastDerivatedGaugeTimestamp;
        }

        public void setLastDerivatedGaugeTimestamp(long lastDerivatedGaugeTimestamp) {
            this.lastDerivatedGaugeTimestamp = lastDerivatedGaugeTimestamp;
        }

        public Number getLastValue() {
            return this.lastValue;
        }

        public void setLastValue(Number lastValue) {
            this.lastValue = lastValue;
        }

        public boolean isHighNotified() {
            return this.highNotified;
        }

        public void setHighNotified(boolean highNotified) {
            this.highNotified = highNotified;
        }

        public boolean isLowNotified() {
            return this.lowNotified;
        }

        public void setLowNotified(boolean lowNotified) {
            this.lowNotified = lowNotified;
        }
    }
}

