/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mx4j.util.Utils;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private static final String WILDCARD = "*";
    private static final String NILCARD = "-";
    private String actions;
    private transient int hash;
    private transient String className;
    private transient String memberName;
    private transient ObjectName objectName;
    private transient ArrayList actionsList;

    public MBeanPermission(String name, String actions) {
        super(name);
        this.actions = actions;
        this.parse(name, actions);
    }

    public MBeanPermission(String className, String memberName, ObjectName objectName, String actions) {
        this(MBeanPermission.createTargetName(className, memberName, objectName), actions);
    }

    private static String createTargetName(String className, String memberName, ObjectName objectName) {
        StringBuffer target = new StringBuffer();
        if (className != null) {
            target.append(className);
        }
        if (memberName != null) {
            target.append("#");
            target.append(memberName);
        }
        if (objectName != null) {
            target.append("[");
            target.append(objectName.getCanonicalName());
            target.append("]");
        }
        if (target.length() == 0) {
            return WILDCARD;
        }
        return target.toString();
    }

    private void parse(String name, String actions) {
        this.className = this.parseClassName(name);
        this.memberName = this.parseMemberName(name);
        this.objectName = this.parseObjectName(name);
        this.actionsList = this.parseActions(actions);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MBeanPermission other = (MBeanPermission)obj;
        if (!this.areEqual(this.getClassName(), other.getClassName())) {
            return false;
        }
        if (!this.areEqual(this.getMemberName(), other.getMemberName())) {
            return false;
        }
        if (!this.areEqual(this.getObjectName(), other.getObjectName())) {
            return false;
        }
        return this.getActionsList().equals(other.getActionsList());
    }

    private boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public String getActions() {
        return this.actions;
    }

    private String getClassName() {
        return this.className;
    }

    private String getMemberName() {
        return this.memberName;
    }

    private ObjectName getObjectName() {
        return this.objectName;
    }

    private ArrayList getActionsList() {
        return this.actionsList;
    }

    public boolean implies(Permission p) {
        if (p == null) {
            return false;
        }
        if (this.getClass() != p.getClass()) {
            return false;
        }
        MBeanPermission permission = (MBeanPermission)p;
        if (!this.impliesClassName(permission)) {
            return false;
        }
        if (!this.impliesMemberName(permission)) {
            return false;
        }
        if (!this.impliesObjectName(permission)) {
            return false;
        }
        return this.impliesActions(permission);
    }

    private boolean impliesClassName(MBeanPermission p) {
        return this.impliesTarget(this.getClassName(), p.getClassName());
    }

    private boolean impliesMemberName(MBeanPermission p) {
        return this.impliesTarget(this.getMemberName(), p.getMemberName());
    }

    private boolean impliesTarget(String thisTarget, String otherTarget) {
        boolean thisWildcard;
        if (thisTarget == null) {
            return otherTarget == null;
        }
        if (otherTarget == null) {
            return true;
        }
        if (thisTarget.equals(otherTarget)) {
            return true;
        }
        boolean otherWildcard = otherTarget.indexOf(WILDCARD) >= 0;
        boolean bl = thisWildcard = thisTarget.indexOf(WILDCARD) >= 0;
        if (thisWildcard) {
            if (otherWildcard) {
                return thisTarget.equals(WILDCARD);
            }
            return Utils.wildcardMatch((String)thisTarget, (String)otherTarget);
        }
        if (otherWildcard) {
            return false;
        }
        return thisTarget.equals(otherTarget);
    }

    private boolean impliesObjectName(MBeanPermission p) {
        ObjectName name1 = this.getObjectName();
        ObjectName name2 = p.getObjectName();
        if (name1 == null) {
            return name2 == null;
        }
        if (name2 == null) {
            return true;
        }
        return name1.implies(name2);
    }

    private boolean impliesActions(MBeanPermission p) {
        ArrayList thisActions = this.getActionsList();
        boolean thisWild = thisActions.contains(WILDCARD);
        ArrayList otherActions = p.getActionsList();
        boolean otherWild = otherActions.contains(WILDCARD);
        if (thisWild) {
            return true;
        }
        if (otherWild) {
            return false;
        }
        if (thisActions.containsAll(otherActions)) {
            return true;
        }
        if (otherActions.contains("queryNames") && thisActions.contains("queryMBeans")) {
            for (int i = 0; i < otherActions.size(); ++i) {
                Object perm = otherActions.get(i);
                if ("queryNames".equals(perm) || thisActions.contains(perm)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String parseClassName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Target name cannot be null");
        }
        String target = name.trim();
        if (target.length() == 0) {
            throw new IllegalArgumentException("Target name cannot be empty");
        }
        int square = target.indexOf(91);
        if (square >= 0) {
            target = target.substring(0, square).trim();
        }
        if (target.length() == 0) {
            return WILDCARD;
        }
        int pound = target.indexOf(35);
        if (pound >= 0) {
            target = target.substring(0, pound).trim();
        }
        if (target.length() == 0) {
            return WILDCARD;
        }
        if (target.equals(NILCARD)) {
            return null;
        }
        return target;
    }

    private String parseMemberName(String name) {
        String target = name.trim();
        int square = target.indexOf(91);
        if (square >= 0) {
            target = target.substring(0, square).trim();
        }
        if (target.length() == 0) {
            return WILDCARD;
        }
        int pound = target.indexOf(35);
        if ((target = pound >= 0 ? target.substring(pound + 1).trim() : WILDCARD).equals(NILCARD)) {
            return null;
        }
        return target;
    }

    private ObjectName parseObjectName(String name) {
        String target = name.trim();
        String inside = "*:*";
        int open = target.indexOf(91);
        if (open >= 0) {
            int close = target.indexOf(93);
            if (close < 0) {
                throw new IllegalArgumentException("Missing closing ObjectName bracket");
            }
            inside = target.substring(open + 1, close).trim();
            if (inside.length() == 0) {
                throw new IllegalArgumentException("Empty string in ObjectName brackets");
            }
            if (inside.equals(NILCARD)) {
                return null;
            }
        }
        try {
            ObjectName objectName = new ObjectName(inside);
            return objectName;
        }
        catch (MalformedObjectNameException x) {
            throw new IllegalArgumentException("Invalid ObjectName: " + inside);
        }
    }

    private ArrayList parseActions(String actions) {
        if (actions == null) {
            throw new IllegalArgumentException("Actions list cannot be null");
        }
        if ((actions = actions.trim()).length() == 0) {
            throw new IllegalArgumentException("Actions list cannot be empty");
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.length() == 0) continue;
            if (token.equals(WILDCARD)) {
                list.clear();
                list.add(WILDCARD);
                return list;
            }
            list.add(token);
        }
        if (list.size() < 1) {
            throw new IllegalArgumentException("No actions specified");
        }
        Collections.sort(list);
        return list;
    }

    private int computeHash() {
        String cls = this.getClassName();
        int hash = cls == null ? NILCARD.hashCode() : cls.hashCode();
        String member = this.getMemberName();
        hash ^= member == null ? NILCARD.hashCode() : member.hashCode();
        ObjectName name = this.getObjectName();
        hash ^= name == null ? NILCARD.hashCode() : name.hashCode();
        return hash ^= this.getActionsList().hashCode();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.parse(this.getName(), this.getActions());
    }
}

