/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.http;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import mx4j.adaptor.http.CommandProcessorUtil;
import mx4j.adaptor.http.HttpCommandProcessor;
import mx4j.adaptor.http.HttpInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class SetAttributeCommandProcessor
implements HttpCommandProcessor {
    private MBeanServer server;
    private DocumentBuilder builder;

    public SetAttributeCommandProcessor(MBeanServer server, DocumentBuilder builder) {
        this.server = server;
        this.builder = builder;
    }

    public Document executeRequest(HttpInputStream in) throws IOException, JMException {
        Document document = this.builder.newDocument();
        Element root = document.createElement("MBeanOperation");
        document.appendChild(root);
        Element operationElement = document.createElement("Operation");
        operationElement.setAttribute("operation", "setattribute");
        root.appendChild(operationElement);
        String objectVariable = in.getVariable("objectname");
        String attributeVariable = in.getVariable("attribute");
        String valueVariable = in.getVariable("value");
        if (objectVariable == null || objectVariable.equals("") || attributeVariable == null || attributeVariable.equals("") || valueVariable == null) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Incorrect parameters in the request");
            return document;
        }
        operationElement.setAttribute("objectname", objectVariable);
        ObjectName name = null;
        try {
            name = new ObjectName(objectVariable);
        }
        catch (MalformedObjectNameException e) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "Malformed object name");
            return document;
        }
        if (this.server.isRegistered(name)) {
            MBeanInfo info = this.server.getMBeanInfo(name);
            MBeanAttributeInfo[] attributes = info.getAttributes();
            MBeanAttributeInfo targetAttribute = null;
            if (attributes != null) {
                int i = 0;
                while (i < attributes.length) {
                    if (attributes[i].getName().equals(attributeVariable)) {
                        targetAttribute = attributes[i];
                        break;
                    }
                    ++i;
                }
            }
            if (targetAttribute != null) {
                String type = targetAttribute.getType();
                Object value = null;
                if (valueVariable != null) {
                    try {
                        value = CommandProcessorUtil.createParameterValue(type, valueVariable);
                    }
                    catch (Exception e) {
                        operationElement.setAttribute("result", "error");
                        operationElement.setAttribute("errorMsg", "Value: " + valueVariable + " could not be converted to " + type);
                    }
                    if (value != null) {
                        try {
                            this.server.setAttribute(name, new Attribute(attributeVariable, value));
                            operationElement.setAttribute("result", "success");
                        }
                        catch (Exception e) {
                            operationElement.setAttribute("result", "error");
                            operationElement.setAttribute("errorMsg", e.getMessage());
                        }
                    }
                }
            } else {
                operationElement.setAttribute("result", "error");
                operationElement.setAttribute("errorMsg", "Attribute " + attributeVariable + " not found");
            }
        } else if (name != null) {
            operationElement.setAttribute("result", "error");
            operationElement.setAttribute("errorMsg", "MBean " + name + " not registered");
        }
        return document;
    }
}

