/*
 * Decompiled with CFR 0.152.
 */
package mx4j.adaptor.rmi.iiop;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import mx4j.adaptor.rmi.RMIAdaptor;
import mx4j.adaptor.rmi.RMIProtocolAdaptorImpl;
import mx4j.adaptor.rmi.iiop.IIOPAdaptorMBean;

public class IIOPAdaptor
extends RMIAdaptor
implements IIOPAdaptorMBean {
    private RMIProtocolAdaptorImpl m_adaptor;
    private boolean m_running;

    public void start() throws RemoteException, NamingException {
        if (!this.isRunning()) {
            this.m_adaptor = new RMIProtocolAdaptorImpl(this.getMBeanServer(), this.getObjectName(), this.getInterceptors());
            PortableRemoteObject.exportObject((Remote)this.m_adaptor);
            String jndiName = this.findJNDIName();
            this.setJNDIName(jndiName);
            this.bind(this.m_adaptor);
            this.m_running = true;
        }
    }

    public void stop() throws NoSuchObjectException, NamingException {
        if (this.isRunning()) {
            PortableRemoteObject.unexportObject((Remote)this.m_adaptor);
            this.unbind();
            this.m_adaptor.unregisterInterceptors();
            this.m_running = false;
        }
    }

    public boolean isRunning() {
        return this.m_running;
    }

    protected ObjectName getDefaultObjectName() throws MalformedObjectNameException {
        return new ObjectName("Adaptor:protocol=IIOP");
    }

    private String findJNDIName() throws RemoteException {
        String jndi = this.getJNDIName();
        if (jndi == null || jndi.trim().length() == 0) {
            StringBuffer buffer = new StringBuffer("jmx-adaptor:iiop:");
            buffer.append(this.getHostName());
            return buffer.toString();
        }
        return jndi;
    }
}

