<?xml version="1.0"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.2 $
																																					-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="yes" encoding="UTF-8"/>

	<!-- Overall parameters -->
	<xsl:param name="html.stylesheet">stylesheet.css</xsl:param>
	<xsl:param name="html.stylesheet.type">text/css</xsl:param>
	<xsl:param name="head.title">MX4J - MBean View</xsl:param>

	<!-- Request parameters -->
	<xsl:param name="request.objectname"/>
	<xsl:param name="request.method"/>

	<xsl:include href="common.xsl"/>

	<xsl:template name="operation" >
		<xsl:for-each select="Operation">
		<table width="100%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td width="100%" class="fronttab">MBean operation: invoke method <xsl:value-of select="$request.method"/> on MBean <xsl:value-of select="$request.objectname"/></td>
			</tr>
			<tr>
				 <td class="clearline">
					 <xsl:if test="@result='success'">
						 Method invokation succesful <br/>
						 <xsl:if test="not (@return='')">Result value: <pre><xsl:value-of select="@return"/></pre></xsl:if>
						 <xsl:if test="@return=''">No Return</xsl:if>
					 </xsl:if>
					 <xsl:if test="@result='error'">
						 Error during MBean operation invokation<br/>
						 Message: <xsl:value-of select="@errorMsg"/>
					 </xsl:if>
				 </td>
			</tr>
			<xsl:call-template name="mbeanview">
				<xsl:with-param name="objectname" select="$request.objectname"/>
			</xsl:call-template>
		</table>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="MBeanOperation">
		<html>
			<xsl:call-template name="head"/>
			<body>
				<xsl:call-template name="toprow"/>
				<xsl:call-template name="tabs">
					<xsl:with-param name="selection">mbean</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="operation"/>
				<xsl:call-template name="bottom"/>
			</body>
	</html>
</xsl:template>
</xsl:stylesheet>

