/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx;

import com.google.protobuf.ByteString;
import com.mysql.cj.api.x.Expression;
import com.mysql.cj.core.exceptions.FeatureNotAvailableException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.mysqlx.ExprParser;
import com.mysql.cj.mysqlx.protobuf.MysqlxCrud;
import com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes;
import com.mysql.cj.mysqlx.protobuf.MysqlxExpr;
import com.mysql.cj.x.json.DbDoc;
import com.mysql.cj.x.json.JsonArray;

public class ExprUtil {
    public static MysqlxExpr.Expr buildLiteralNullScalar() {
        return ExprUtil.buildLiteralExpr(ExprUtil.nullScalar());
    }

    public static MysqlxExpr.Expr buildLiteralScalar(double d) {
        return ExprUtil.buildLiteralExpr(ExprUtil.scalarOf(d));
    }

    public static MysqlxExpr.Expr buildLiteralScalar(long l) {
        return ExprUtil.buildLiteralExpr(ExprUtil.scalarOf(l));
    }

    public static MysqlxExpr.Expr buildLiteralScalar(String str) {
        return ExprUtil.buildLiteralExpr(ExprUtil.scalarOf(str));
    }

    public static MysqlxExpr.Expr buildLiteralScalar(byte[] bytes) {
        return ExprUtil.buildLiteralExpr(ExprUtil.scalarOf(bytes));
    }

    public static MysqlxExpr.Expr buildLiteralScalar(boolean b) {
        return ExprUtil.buildLiteralExpr(ExprUtil.scalarOf(b));
    }

    public static MysqlxExpr.Expr buildLiteralExpr(MysqlxDatatypes.Scalar scalar) {
        return MysqlxExpr.Expr.newBuilder().setType(MysqlxExpr.Expr.Type.LITERAL).setLiteral(scalar).build();
    }

    public static MysqlxDatatypes.Scalar nullScalar() {
        return MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_NULL).build();
    }

    public static MysqlxDatatypes.Scalar scalarOf(double d) {
        return MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_DOUBLE).setVDouble(d).build();
    }

    public static MysqlxDatatypes.Scalar scalarOf(long l) {
        return MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_SINT).setVSignedInt(l).build();
    }

    public static MysqlxDatatypes.Scalar scalarOf(String str) {
        MysqlxDatatypes.Scalar.String sstr = MysqlxDatatypes.Scalar.String.newBuilder().setValue(ByteString.copyFromUtf8((String)str)).build();
        return MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_STRING).setVString(sstr).build();
    }

    public static MysqlxDatatypes.Scalar scalarOf(byte[] bytes) {
        MysqlxDatatypes.Scalar.Octets.Builder o = MysqlxDatatypes.Scalar.Octets.newBuilder().setValue(ByteString.copyFrom((byte[])bytes));
        return MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_OCTETS).setVOctets(o).build();
    }

    public static MysqlxDatatypes.Scalar scalarOf(boolean b) {
        return MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_BOOL).setVBool(b).build();
    }

    public static MysqlxDatatypes.Any buildAny(String str) {
        MysqlxDatatypes.Scalar.String sstr = MysqlxDatatypes.Scalar.String.newBuilder().setValue(ByteString.copyFromUtf8((String)str)).build();
        MysqlxDatatypes.Scalar s = MysqlxDatatypes.Scalar.newBuilder().setType(MysqlxDatatypes.Scalar.Type.V_STRING).setVString(sstr).build();
        MysqlxDatatypes.Any a = MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.SCALAR).setScalar(s).build();
        return a;
    }

    public static MysqlxDatatypes.Any buildAny(boolean b) {
        return MysqlxDatatypes.Any.newBuilder().setType(MysqlxDatatypes.Any.Type.SCALAR).setScalar(ExprUtil.scalarOf(b)).build();
    }

    public static MysqlxCrud.Collection buildCollection(String schemaName, String collectionName) {
        return MysqlxCrud.Collection.newBuilder().setSchema(schemaName).setName(collectionName).build();
    }

    public static MysqlxDatatypes.Scalar argObjectToScalar(Object value) {
        MysqlxExpr.Expr e = ExprUtil.argObjectToExpr(value, false);
        if (!e.hasLiteral()) {
            throw new WrongArgumentException("No literal interpretation of argument: " + value);
        }
        return e.getLiteral();
    }

    public static MysqlxExpr.Expr argObjectToExpr(Object value, boolean allowRelationalColumns) {
        if (value == null) {
            return ExprUtil.buildLiteralNullScalar();
        }
        if (value.getClass() == Boolean.class) {
            return ExprUtil.buildLiteralScalar((Boolean)value);
        }
        if (value.getClass() == Byte.class) {
            return ExprUtil.buildLiteralScalar(((Byte)value).longValue());
        }
        if (value.getClass() == Short.class) {
            return ExprUtil.buildLiteralScalar(((Short)value).longValue());
        }
        if (value.getClass() == Integer.class) {
            return ExprUtil.buildLiteralScalar(((Integer)value).longValue());
        }
        if (value.getClass() == Long.class) {
            return ExprUtil.buildLiteralScalar((Long)value);
        }
        if (value.getClass() == Float.class) {
            return ExprUtil.buildLiteralScalar(((Float)value).doubleValue());
        }
        if (value.getClass() == Double.class) {
            return ExprUtil.buildLiteralScalar((Double)value);
        }
        if (value.getClass() == String.class) {
            return ExprUtil.buildLiteralScalar((String)value);
        }
        if (value.getClass() == Expression.class) {
            return new ExprParser(((Expression)value).getExpressionString(), allowRelationalColumns).parse();
        }
        if (value.getClass() == DbDoc.class || value.getClass() == JsonArray.class) {
            // empty if block
        }
        throw new FeatureNotAvailableException("TODO: other types: BigDecimal, Date, Timestamp, Time");
    }
}

