/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf.url;

import com.mysql.cj.api.conf.DatabaseUrlContainer;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionUrlParser
implements DatabaseUrlContainer {
    private static final String DUMMY_SCHEMA = "cj://";
    private static final String ALTERNATE_HOST_INFO_PREFIX = "ADDRESS=";
    private static final String USER_PASS_SEPARATOR = ":";
    private static final String USERINFO_HOST_SEPARATOR = "@";
    private static final String HOST_PORT_SEPARATOR = ":";
    private static final String HOSTS_SEPARATOR = ",";
    private static final Pattern CONNECTION_STRING_PTRN = Pattern.compile("(?<scheme>[\\w:]+)(?://(?<authority>[^/?#]*))?(?:/(?<path>[^?#]*))?(?:\\?(?<query>[^#]*))?(?<fragment>.*)");
    private static final Pattern ALTERNATE_HOST_INFO_PTRN = Pattern.compile("\\((?<key>\\w+)(?:=(?<value>[^)]*))?\\)");
    private static final Pattern PROPERTIES_PTRN = Pattern.compile("&*(?<key>\\w+)(?:=(?<value>[^&]*))?(?:&+|$)");
    private static final Pattern GENERIC_HOST_PORT_PTRN = Pattern.compile("(?<host>^.*):(?<port>\\d*)$");
    private final String baseConnectionString;
    private String scheme;
    private String authority;
    private String path;
    private String query;
    private List<HostInfo> parsedHosts = null;
    private Map<String, String> parsedProperties = null;

    public static ConnectionUrlParser parseConnectionString(String connString) {
        if (connString == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.0"));
        }
        return new ConnectionUrlParser(connString);
    }

    private ConnectionUrlParser(String connString) {
        this.baseConnectionString = connString;
        this.parseConnectionString();
    }

    private void parseConnectionString() {
        String connString = this.baseConnectionString;
        Matcher matcher = CONNECTION_STRING_PTRN.matcher(connString);
        if (!matcher.matches()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.1"));
        }
        this.scheme = ConnectionUrlParser.decode(matcher.group("scheme"));
        this.authority = matcher.group("authority");
        this.path = ConnectionUrlParser.decode(matcher.group("path"));
        this.query = matcher.group("query");
    }

    private void parseAuthoritySection() {
        String[] authorityParts;
        if (StringUtils.isNullOrEmpty(this.authority)) {
            this.parsedHosts.add(new HostInfo());
            return;
        }
        for (String hi : authorityParts = this.authority.split(HOSTS_SEPARATOR, -1)) {
            HostInfo hostInfo = this.parseHostInfo(hi);
            this.parsedHosts.add(hostInfo);
        }
    }

    private HostInfo parseHostInfo(String hostInfo) {
        if (StringUtils.isNullOrEmpty(hostInfo)) {
            return new HostInfo();
        }
        String host = null;
        int port = -1;
        String user = null;
        String password = null;
        Pair<String, String> userInfo = null;
        try {
            URI uri = URI.create(DUMMY_SCHEMA + hostInfo);
            if (uri.getHost() != null) {
                host = uri.getHost();
            }
            if (uri.getPort() != -1) {
                port = uri.getPort();
            }
            if (uri.getUserInfo() != null) {
                userInfo = ConnectionUrlParser.parseUserInfo(uri.getUserInfo());
                user = (String)userInfo.left;
                password = (String)userInfo.right;
            }
        }
        catch (IllegalArgumentException uri) {
            // empty catch block
        }
        if (host != null || port != -1 || userInfo != null) {
            return new HostInfo(this, host, port, user, password);
        }
        int p = StringUtils.indexOfIgnoreCase(hostInfo, ALTERNATE_HOST_INFO_PREFIX);
        if (p >= 0) {
            String[] altHostInfoParts = hostInfo.split("(?i)ADDRESS=", 2);
            if (!altHostInfoParts[0].isEmpty()) {
                if (!altHostInfoParts[0].endsWith(USERINFO_HOST_SEPARATOR)) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.2", new Object[]{USERINFO_HOST_SEPARATOR, ALTERNATE_HOST_INFO_PREFIX.toLowerCase()}));
                }
                userInfo = ConnectionUrlParser.parseUserInfo(altHostInfoParts[0].substring(0, altHostInfoParts[0].length() - USERINFO_HOST_SEPARATOR.length()));
                user = (String)userInfo.left;
                password = (String)userInfo.right;
            }
            return new HostInfo(this, host, port, user, password, this.parseAlternateHostInfo(altHostInfoParts[1]));
        }
        int s = 0;
        p = hostInfo.indexOf(USERINFO_HOST_SEPARATOR);
        if (p >= 0) {
            userInfo = ConnectionUrlParser.parseUserInfo(hostInfo.substring(0, p));
            user = (String)userInfo.left;
            password = (String)userInfo.right;
            s = p + USERINFO_HOST_SEPARATOR.length();
        }
        if ((p = hostInfo.indexOf(":", s)) >= 0) {
            String[] hostPortParts = hostInfo.substring(s).split(":", 2);
            host = hostPortParts.length > 0 && !hostPortParts[0].isEmpty() ? ConnectionUrlParser.decode(hostPortParts[0]) : null;
            port = hostPortParts.length > 1 && !hostPortParts[1].isEmpty() ? Integer.parseInt(ConnectionUrlParser.decode(hostPortParts[1])) : -1;
        } else {
            String hostPart = ConnectionUrlParser.decode(hostInfo.substring(s));
            host = !hostPart.isEmpty() ? hostPart : null;
        }
        return new HostInfo(this, host, port, user, password);
    }

    private static Pair<String, String> parseUserInfo(String userInfo) {
        String[] userInfoParts = userInfo.split(":", 2);
        String userName = userInfoParts.length > 0 && !userInfoParts[0].isEmpty() ? ConnectionUrlParser.decode(userInfoParts[0]) : null;
        String password = userInfoParts.length > 1 && !userInfoParts[1].isEmpty() ? ConnectionUrlParser.decode(userInfoParts[1]) : null;
        return new Pair<String, Object>(userName, password);
    }

    public static Pair<String, String> parseHostPortPair(String hostPortPair) {
        Matcher matcher = GENERIC_HOST_PORT_PTRN.matcher(hostPortPair);
        if (matcher.matches()) {
            return new Pair<String, String>(matcher.group("host"), matcher.group("port"));
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.3", new Object[]{hostPortPair}));
    }

    private Map<String, String> parseAlternateHostInfo(String altHostInfo) {
        return this.processKeyValuePattern(ALTERNATE_HOST_INFO_PTRN, altHostInfo);
    }

    private void parseQuerySection() {
        if (StringUtils.isNullOrEmpty(this.query)) {
            this.parsedProperties = new HashMap<String, String>();
            return;
        }
        this.parsedProperties = this.processKeyValuePattern(PROPERTIES_PTRN, this.query);
    }

    private Map<String, String> processKeyValuePattern(Pattern pattern, String input) {
        Matcher matcher = pattern.matcher(input);
        int p = 0;
        HashMap<String, String> kvMap = new HashMap<String, String>();
        while (matcher.find()) {
            if (matcher.start() != p) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.4", new Object[]{input.substring(p)}));
            }
            p = matcher.end();
            String key = ConnectionUrlParser.decode(matcher.group("key")).trim();
            String value = ConnectionUrlParser.decode(matcher.group("value"));
            kvMap.put(key, value);
        }
        if (p != input.length()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.4", new Object[]{input.substring(p)}));
        }
        return kvMap;
    }

    private static String decode(String text) {
        if (StringUtils.isNullOrEmpty(text)) {
            return text;
        }
        try {
            return URLDecoder.decode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    @Override
    public String getDatabaseUrl() {
        return this.baseConnectionString;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public List<HostInfo> getHosts() {
        if (this.parsedHosts == null) {
            this.parsedHosts = new ArrayList<HostInfo>();
            this.parseAuthoritySection();
        }
        return this.parsedHosts;
    }

    public Map<String, String> getProperties() {
        if (this.parsedProperties == null) {
            this.parseQuerySection();
        }
        return Collections.unmodifiableMap(this.parsedProperties);
    }

    public String toString() {
        StringBuilder asStr = new StringBuilder(super.toString());
        asStr.append(String.format(" :: {scheme: \"%s\", authority: \"%s\", path: \"%s\", query: \"%s\", parsedHosts: %s, parsedProperties: %s}", this.scheme, this.authority, this.path, this.query, this.parsedHosts, this.parsedProperties));
        return asStr.toString();
    }

    public static class Pair<T, U> {
        public final T left;
        public final U right;

        public Pair(T left, U right) {
            this.left = left;
            this.right = right;
        }
    }
}

