/*
  Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.mysqlx.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_connection.proto

public final class MysqlxConnection {
  private MysqlxConnection() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface CapabilityOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Connection.Capability)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string name = 1;</code>
     */
    boolean hasName();
    /**
     * <code>required string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>required string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any getValue();
    /**
     * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Connection.Capability}
   *
   * <pre>
   * a Capability
   * a tuple of a ``name`` and a :protobuf:msg:`Mysqlx.Datatypes::Any`
   * </pre>
   */
  public static final class Capability extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Connection.Capability)
      CapabilityOrBuilder {
    // Use Capability.newBuilder() to construct.
    private Capability(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Capability(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Capability defaultInstance;
    public static Capability getDefaultInstance() {
      return defaultInstance;
    }

    public Capability getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Capability(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              name_ = bs;
              break;
            }
            case 18: {
              com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = value_.toBuilder();
              }
              value_ = input.readMessage(com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(value_);
                value_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capability_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capability_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder.class);
    }

    public static com.google.protobuf.Parser<Capability> PARSER =
        new com.google.protobuf.AbstractParser<Capability>() {
      public Capability parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Capability(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Capability> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private java.lang.Object name_;
    /**
     * <code>required string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value_;
    /**
     * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any getValue() {
      return value_;
    }
    /**
     * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder() {
      return value_;
    }

    private void initFields() {
      name_ = "";
      value_ = com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasValue()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getValue().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Connection.Capability}
     *
     * <pre>
     * a Capability
     * a tuple of a ``name`` and a :protobuf:msg:`Mysqlx.Datatypes::Any`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Connection.Capability)
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capability_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capability_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capability_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability result = new com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.getDefaultInstance()) return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasName()) {
          
          return false;
        }
        if (!hasValue()) {
          
          return false;
        }
        if (!getValue().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>required string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>required string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value_ = com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> valueBuilder_;
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any getValue() {
        if (valueBuilder_ == null) {
          return value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public Builder setValue(com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public Builder setValue(
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public Builder mergeValue(com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              value_ != com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance()) {
            value_ =
              com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.newBuilder(value_).mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder getValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_;
        }
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Connection.Capability)
    }

    static {
      defaultInstance = new Capability(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Connection.Capability)
  }

  public interface CapabilitiesOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Connection.Capabilities)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability> 
        getCapabilitiesList();
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability getCapabilities(int index);
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    int getCapabilitiesCount();
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder> 
        getCapabilitiesOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder getCapabilitiesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Connection.Capabilities}
   *
   * <pre>
   * Capabilities
   * </pre>
   */
  public static final class Capabilities extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Connection.Capabilities)
      CapabilitiesOrBuilder {
    // Use Capabilities.newBuilder() to construct.
    private Capabilities(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Capabilities(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Capabilities defaultInstance;
    public static Capabilities getDefaultInstance() {
      return defaultInstance;
    }

    public Capabilities getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Capabilities(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                capabilities_ = new java.util.ArrayList<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability>();
                mutable_bitField0_ |= 0x00000001;
              }
              capabilities_.add(input.readMessage(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.PARSER, extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          capabilities_ = java.util.Collections.unmodifiableList(capabilities_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capabilities_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capabilities_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder.class);
    }

    public static com.google.protobuf.Parser<Capabilities> PARSER =
        new com.google.protobuf.AbstractParser<Capabilities>() {
      public Capabilities parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Capabilities(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Capabilities> getParserForType() {
      return PARSER;
    }

    public static final int CAPABILITIES_FIELD_NUMBER = 1;
    private java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability> capabilities_;
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    public java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability> getCapabilitiesList() {
      return capabilities_;
    }
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    public java.util.List<? extends com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder> 
        getCapabilitiesOrBuilderList() {
      return capabilities_;
    }
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    public int getCapabilitiesCount() {
      return capabilities_.size();
    }
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability getCapabilities(int index) {
      return capabilities_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder getCapabilitiesOrBuilder(
        int index) {
      return capabilities_.get(index);
    }

    private void initFields() {
      capabilities_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getCapabilitiesCount(); i++) {
        if (!getCapabilities(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < capabilities_.size(); i++) {
        output.writeMessage(1, capabilities_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < capabilities_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, capabilities_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Connection.Capabilities}
     *
     * <pre>
     * Capabilities
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Connection.Capabilities)
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capabilities_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capabilities_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCapabilitiesFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (capabilitiesBuilder_ == null) {
          capabilities_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          capabilitiesBuilder_.clear();
        }
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Capabilities_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities result = new com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities(this);
        int from_bitField0_ = bitField0_;
        if (capabilitiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            capabilities_ = java.util.Collections.unmodifiableList(capabilities_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.capabilities_ = capabilities_;
        } else {
          result.capabilities_ = capabilitiesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance()) return this;
        if (capabilitiesBuilder_ == null) {
          if (!other.capabilities_.isEmpty()) {
            if (capabilities_.isEmpty()) {
              capabilities_ = other.capabilities_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureCapabilitiesIsMutable();
              capabilities_.addAll(other.capabilities_);
            }
            onChanged();
          }
        } else {
          if (!other.capabilities_.isEmpty()) {
            if (capabilitiesBuilder_.isEmpty()) {
              capabilitiesBuilder_.dispose();
              capabilitiesBuilder_ = null;
              capabilities_ = other.capabilities_;
              bitField0_ = (bitField0_ & ~0x00000001);
              capabilitiesBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getCapabilitiesFieldBuilder() : null;
            } else {
              capabilitiesBuilder_.addAllMessages(other.capabilities_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        for (int i = 0; i < getCapabilitiesCount(); i++) {
          if (!getCapabilities(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability> capabilities_ =
        java.util.Collections.emptyList();
      private void ensureCapabilitiesIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          capabilities_ = new java.util.ArrayList<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability>(capabilities_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder> capabilitiesBuilder_;

      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability> getCapabilitiesList() {
        if (capabilitiesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(capabilities_);
        } else {
          return capabilitiesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public int getCapabilitiesCount() {
        if (capabilitiesBuilder_ == null) {
          return capabilities_.size();
        } else {
          return capabilitiesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability getCapabilities(int index) {
        if (capabilitiesBuilder_ == null) {
          return capabilities_.get(index);
        } else {
          return capabilitiesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder setCapabilities(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability value) {
        if (capabilitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCapabilitiesIsMutable();
          capabilities_.set(index, value);
          onChanged();
        } else {
          capabilitiesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder setCapabilities(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder builderForValue) {
        if (capabilitiesBuilder_ == null) {
          ensureCapabilitiesIsMutable();
          capabilities_.set(index, builderForValue.build());
          onChanged();
        } else {
          capabilitiesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder addCapabilities(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability value) {
        if (capabilitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCapabilitiesIsMutable();
          capabilities_.add(value);
          onChanged();
        } else {
          capabilitiesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder addCapabilities(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability value) {
        if (capabilitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCapabilitiesIsMutable();
          capabilities_.add(index, value);
          onChanged();
        } else {
          capabilitiesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder addCapabilities(
          com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder builderForValue) {
        if (capabilitiesBuilder_ == null) {
          ensureCapabilitiesIsMutable();
          capabilities_.add(builderForValue.build());
          onChanged();
        } else {
          capabilitiesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder addCapabilities(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder builderForValue) {
        if (capabilitiesBuilder_ == null) {
          ensureCapabilitiesIsMutable();
          capabilities_.add(index, builderForValue.build());
          onChanged();
        } else {
          capabilitiesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder addAllCapabilities(
          java.lang.Iterable<? extends com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability> values) {
        if (capabilitiesBuilder_ == null) {
          ensureCapabilitiesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, capabilities_);
          onChanged();
        } else {
          capabilitiesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder clearCapabilities() {
        if (capabilitiesBuilder_ == null) {
          capabilities_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          capabilitiesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public Builder removeCapabilities(int index) {
        if (capabilitiesBuilder_ == null) {
          ensureCapabilitiesIsMutable();
          capabilities_.remove(index);
          onChanged();
        } else {
          capabilitiesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder getCapabilitiesBuilder(
          int index) {
        return getCapabilitiesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder getCapabilitiesOrBuilder(
          int index) {
        if (capabilitiesBuilder_ == null) {
          return capabilities_.get(index);  } else {
          return capabilitiesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder> 
           getCapabilitiesOrBuilderList() {
        if (capabilitiesBuilder_ != null) {
          return capabilitiesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(capabilities_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder addCapabilitiesBuilder() {
        return getCapabilitiesFieldBuilder().addBuilder(
            com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder addCapabilitiesBuilder(
          int index) {
        return getCapabilitiesFieldBuilder().addBuilder(
            index, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Connection.Capability capabilities = 1;</code>
       */
      public java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder> 
           getCapabilitiesBuilderList() {
        return getCapabilitiesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder> 
          getCapabilitiesFieldBuilder() {
        if (capabilitiesBuilder_ == null) {
          capabilitiesBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capability.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilityOrBuilder>(
                  capabilities_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          capabilities_ = null;
        }
        return capabilitiesBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Connection.Capabilities)
    }

    static {
      defaultInstance = new Capabilities(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Connection.Capabilities)
  }

  public interface CapabilitiesGetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Connection.CapabilitiesGet)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Connection.CapabilitiesGet}
   *
   * <pre>
   * get supported connection capabilities and their current state
   *   :returns: :protobuf:msg:`Mysqlx.Connection::Capabilities` or :protobuf:msg:`Mysqlx::Error`
   * </pre>
   */
  public static final class CapabilitiesGet extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Connection.CapabilitiesGet)
      CapabilitiesGetOrBuilder {
    // Use CapabilitiesGet.newBuilder() to construct.
    private CapabilitiesGet(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CapabilitiesGet(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CapabilitiesGet defaultInstance;
    public static CapabilitiesGet getDefaultInstance() {
      return defaultInstance;
    }

    public CapabilitiesGet getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CapabilitiesGet(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesGet_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesGet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.Builder.class);
    }

    public static com.google.protobuf.Parser<CapabilitiesGet> PARSER =
        new com.google.protobuf.AbstractParser<CapabilitiesGet>() {
      public CapabilitiesGet parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CapabilitiesGet(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CapabilitiesGet> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Connection.CapabilitiesGet}
     *
     * <pre>
     * get supported connection capabilities and their current state
     *   :returns: :protobuf:msg:`Mysqlx.Connection::Capabilities` or :protobuf:msg:`Mysqlx::Error`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Connection.CapabilitiesGet)
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesGet_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesGet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesGet_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet result = new com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesGet) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Connection.CapabilitiesGet)
    }

    static {
      defaultInstance = new CapabilitiesGet(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Connection.CapabilitiesGet)
  }

  public interface CapabilitiesSetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Connection.CapabilitiesSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
     */
    boolean hasCapabilities();
    /**
     * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities getCapabilities();
    /**
     * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder getCapabilitiesOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Connection.CapabilitiesSet}
   *
   * <pre>
   * sets connection capabilities atomically
   * only provided values are changed, other values are left unchanged.
   * If any of the changes fails, all changes are discarded.
   * :precond: active sessions == 0
   * :returns: :protobuf:msg:`Mysqlx::Ok` or :protobuf:msg:`Mysqlx::Error`
   * </pre>
   */
  public static final class CapabilitiesSet extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Connection.CapabilitiesSet)
      CapabilitiesSetOrBuilder {
    // Use CapabilitiesSet.newBuilder() to construct.
    private CapabilitiesSet(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private CapabilitiesSet(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final CapabilitiesSet defaultInstance;
    public static CapabilitiesSet getDefaultInstance() {
      return defaultInstance;
    }

    public CapabilitiesSet getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private CapabilitiesSet(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) == 0x00000001)) {
                subBuilder = capabilities_.toBuilder();
              }
              capabilities_ = input.readMessage(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(capabilities_);
                capabilities_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesSet_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.Builder.class);
    }

    public static com.google.protobuf.Parser<CapabilitiesSet> PARSER =
        new com.google.protobuf.AbstractParser<CapabilitiesSet>() {
      public CapabilitiesSet parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CapabilitiesSet(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<CapabilitiesSet> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int CAPABILITIES_FIELD_NUMBER = 1;
    private com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities capabilities_;
    /**
     * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
     */
    public boolean hasCapabilities() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities getCapabilities() {
      return capabilities_;
    }
    /**
     * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder getCapabilitiesOrBuilder() {
      return capabilities_;
    }

    private void initFields() {
      capabilities_ = com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCapabilities()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getCapabilities().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, capabilities_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, capabilities_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Connection.CapabilitiesSet}
     *
     * <pre>
     * sets connection capabilities atomically
     * only provided values are changed, other values are left unchanged.
     * If any of the changes fails, all changes are discarded.
     * :precond: active sessions == 0
     * :returns: :protobuf:msg:`Mysqlx::Ok` or :protobuf:msg:`Mysqlx::Error`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Connection.CapabilitiesSet)
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesSet_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getCapabilitiesFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        if (capabilitiesBuilder_ == null) {
          capabilities_ = com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance();
        } else {
          capabilitiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_CapabilitiesSet_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet result = new com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (capabilitiesBuilder_ == null) {
          result.capabilities_ = capabilities_;
        } else {
          result.capabilities_ = capabilitiesBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet.getDefaultInstance()) return this;
        if (other.hasCapabilities()) {
          mergeCapabilities(other.getCapabilities());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCapabilities()) {
          
          return false;
        }
        if (!getCapabilities().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesSet) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities capabilities_ = com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder> capabilitiesBuilder_;
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public boolean hasCapabilities() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities getCapabilities() {
        if (capabilitiesBuilder_ == null) {
          return capabilities_;
        } else {
          return capabilitiesBuilder_.getMessage();
        }
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public Builder setCapabilities(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities value) {
        if (capabilitiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          capabilities_ = value;
          onChanged();
        } else {
          capabilitiesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public Builder setCapabilities(
          com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder builderForValue) {
        if (capabilitiesBuilder_ == null) {
          capabilities_ = builderForValue.build();
          onChanged();
        } else {
          capabilitiesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public Builder mergeCapabilities(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities value) {
        if (capabilitiesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001) &&
              capabilities_ != com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance()) {
            capabilities_ =
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.newBuilder(capabilities_).mergeFrom(value).buildPartial();
          } else {
            capabilities_ = value;
          }
          onChanged();
        } else {
          capabilitiesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public Builder clearCapabilities() {
        if (capabilitiesBuilder_ == null) {
          capabilities_ = com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.getDefaultInstance();
          onChanged();
        } else {
          capabilitiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder getCapabilitiesBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCapabilitiesFieldBuilder().getBuilder();
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder getCapabilitiesOrBuilder() {
        if (capabilitiesBuilder_ != null) {
          return capabilitiesBuilder_.getMessageOrBuilder();
        } else {
          return capabilities_;
        }
      }
      /**
       * <code>required .Mysqlx.Connection.Capabilities capabilities = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder> 
          getCapabilitiesFieldBuilder() {
        if (capabilitiesBuilder_ == null) {
          capabilitiesBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Capabilities.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CapabilitiesOrBuilder>(
                  getCapabilities(),
                  getParentForChildren(),
                  isClean());
          capabilities_ = null;
        }
        return capabilitiesBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Connection.CapabilitiesSet)
    }

    static {
      defaultInstance = new CapabilitiesSet(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Connection.CapabilitiesSet)
  }

  public interface CloseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Connection.Close)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Connection.Close}
   *
   * <pre>
   * announce to the server that the client wants to close the connection
   * it discards any session state of the server
   * :Returns: :protobuf:msg:`Mysqlx::Ok`
   * </pre>
   */
  public static final class Close extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Connection.Close)
      CloseOrBuilder {
    // Use Close.newBuilder() to construct.
    private Close(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Close(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Close defaultInstance;
    public static Close getDefaultInstance() {
      return defaultInstance;
    }

    public Close getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Close(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Close_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Close_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.Builder.class);
    }

    public static com.google.protobuf.Parser<Close> PARSER =
        new com.google.protobuf.AbstractParser<Close>() {
      public Close parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Close(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Close> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Connection.Close}
     *
     * <pre>
     * announce to the server that the client wants to close the connection
     * it discards any session state of the server
     * :Returns: :protobuf:msg:`Mysqlx::Ok`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Connection.Close)
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.CloseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Close_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Close_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.class, com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.internal_static_Mysqlx_Connection_Close_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close result = new com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxConnection.Close) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Connection.Close)
    }

    static {
      defaultInstance = new Close(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Connection.Close)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Connection_Capability_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Connection_Capability_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Connection_Capabilities_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Connection_Capabilities_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Connection_CapabilitiesGet_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Connection_CapabilitiesGet_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Connection_CapabilitiesSet_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Connection_CapabilitiesSet_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Connection_Close_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Connection_Close_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\027mysqlx_connection.proto\022\021Mysqlx.Connec" +
      "tion\032\026mysqlx_datatypes.proto\"@\n\nCapabili" +
      "ty\022\014\n\004name\030\001 \002(\t\022$\n\005value\030\002 \002(\0132\025.Mysqlx" +
      ".Datatypes.Any\"C\n\014Capabilities\0223\n\014capabi" +
      "lities\030\001 \003(\0132\035.Mysqlx.Connection.Capabil" +
      "ity\"\021\n\017CapabilitiesGet\"H\n\017CapabilitiesSe" +
      "t\0225\n\014capabilities\030\001 \002(\0132\037.Mysqlx.Connect" +
      "ion.Capabilities\"\007\n\005CloseB\036\n\034com.mysql.c" +
      "j.mysqlx.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_Connection_Capability_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Connection_Capability_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Connection_Capability_descriptor,
        new java.lang.String[] { "Name", "Value", });
    internal_static_Mysqlx_Connection_Capabilities_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Connection_Capabilities_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Connection_Capabilities_descriptor,
        new java.lang.String[] { "Capabilities", });
    internal_static_Mysqlx_Connection_CapabilitiesGet_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Connection_CapabilitiesGet_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Connection_CapabilitiesGet_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Connection_CapabilitiesSet_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Connection_CapabilitiesSet_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Connection_CapabilitiesSet_descriptor,
        new java.lang.String[] { "Capabilities", });
    internal_static_Mysqlx_Connection_Close_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Connection_Close_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Connection_Close_descriptor,
        new java.lang.String[] { });
    com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
