/*
  Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_resultset.proto

public final class MysqlxResultset {
  private MysqlxResultset() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface FetchDoneMoreOutParamsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchDoneMoreOutParams)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreOutParams}
   *
   * <pre>
   * resultsets are finished, OUT paramset is next
   * </pre>
   */
  public static final class FetchDoneMoreOutParams extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchDoneMoreOutParams)
      FetchDoneMoreOutParamsOrBuilder {
    // Use FetchDoneMoreOutParams.newBuilder() to construct.
    private FetchDoneMoreOutParams(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FetchDoneMoreOutParams(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FetchDoneMoreOutParams defaultInstance;
    public static FetchDoneMoreOutParams getDefaultInstance() {
      return defaultInstance;
    }

    public FetchDoneMoreOutParams getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FetchDoneMoreOutParams(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.Builder.class);
    }

    public static com.google.protobuf.Parser<FetchDoneMoreOutParams> PARSER =
        new com.google.protobuf.AbstractParser<FetchDoneMoreOutParams>() {
      public FetchDoneMoreOutParams parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FetchDoneMoreOutParams(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FetchDoneMoreOutParams> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreOutParams}
     *
     * <pre>
     * resultsets are finished, OUT paramset is next
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchDoneMoreOutParams)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParamsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreOutParams) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchDoneMoreOutParams)
    }

    static {
      defaultInstance = new FetchDoneMoreOutParams(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchDoneMoreOutParams)
  }

  public interface FetchDoneMoreResultsetsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchDoneMoreResultsets)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreResultsets}
   *
   * <pre>
   * resultset and out-params are finished, but more resultsets available
   * </pre>
   */
  public static final class FetchDoneMoreResultsets extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchDoneMoreResultsets)
      FetchDoneMoreResultsetsOrBuilder {
    // Use FetchDoneMoreResultsets.newBuilder() to construct.
    private FetchDoneMoreResultsets(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FetchDoneMoreResultsets(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FetchDoneMoreResultsets defaultInstance;
    public static FetchDoneMoreResultsets getDefaultInstance() {
      return defaultInstance;
    }

    public FetchDoneMoreResultsets getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FetchDoneMoreResultsets(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.Builder.class);
    }

    public static com.google.protobuf.Parser<FetchDoneMoreResultsets> PARSER =
        new com.google.protobuf.AbstractParser<FetchDoneMoreResultsets>() {
      public FetchDoneMoreResultsets parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FetchDoneMoreResultsets(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FetchDoneMoreResultsets> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Resultset.FetchDoneMoreResultsets}
     *
     * <pre>
     * resultset and out-params are finished, but more resultsets available
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchDoneMoreResultsets)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsetsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneMoreResultsets) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchDoneMoreResultsets)
    }

    static {
      defaultInstance = new FetchDoneMoreResultsets(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchDoneMoreResultsets)
  }

  public interface FetchDoneOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.FetchDone)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Resultset.FetchDone}
   *
   * <pre>
   * all resultsets are finished
   * </pre>
   */
  public static final class FetchDone extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.FetchDone)
      FetchDoneOrBuilder {
    // Use FetchDone.newBuilder() to construct.
    private FetchDone(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private FetchDone(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final FetchDone defaultInstance;
    public static FetchDone getDefaultInstance() {
      return defaultInstance;
    }

    public FetchDone getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private FetchDone(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.Builder.class);
    }

    public static com.google.protobuf.Parser<FetchDone> PARSER =
        new com.google.protobuf.AbstractParser<FetchDone>() {
      public FetchDone parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FetchDone(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<FetchDone> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Resultset.FetchDone}
     *
     * <pre>
     * all resultsets are finished
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.FetchDone)
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDoneOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.class, com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_FetchDone_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone result = new com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxResultset.FetchDone) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.FetchDone)
    }

    static {
      defaultInstance = new FetchDone(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.FetchDone)
  }

  public interface ColumnMetaDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.ColumnMetaData)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     *
     * <pre>
     * datatype of the field in a row
     * </pre>
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     *
     * <pre>
     * datatype of the field in a row
     * </pre>
     */
    com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType getType();

    /**
     * <code>optional bytes name = 2;</code>
     */
    boolean hasName();
    /**
     * <code>optional bytes name = 2;</code>
     */
    com.google.protobuf.ByteString getName();

    /**
     * <code>optional bytes original_name = 3;</code>
     */
    boolean hasOriginalName();
    /**
     * <code>optional bytes original_name = 3;</code>
     */
    com.google.protobuf.ByteString getOriginalName();

    /**
     * <code>optional bytes table = 4;</code>
     */
    boolean hasTable();
    /**
     * <code>optional bytes table = 4;</code>
     */
    com.google.protobuf.ByteString getTable();

    /**
     * <code>optional bytes original_table = 5;</code>
     */
    boolean hasOriginalTable();
    /**
     * <code>optional bytes original_table = 5;</code>
     */
    com.google.protobuf.ByteString getOriginalTable();

    /**
     * <code>optional bytes schema = 6;</code>
     */
    boolean hasSchema();
    /**
     * <code>optional bytes schema = 6;</code>
     */
    com.google.protobuf.ByteString getSchema();

    /**
     * <code>optional bytes catalog = 7;</code>
     */
    boolean hasCatalog();
    /**
     * <code>optional bytes catalog = 7;</code>
     */
    com.google.protobuf.ByteString getCatalog();

    /**
     * <code>optional uint64 collation = 8;</code>
     */
    boolean hasCollation();
    /**
     * <code>optional uint64 collation = 8;</code>
     */
    long getCollation();

    /**
     * <code>optional uint32 fractional_digits = 9;</code>
     */
    boolean hasFractionalDigits();
    /**
     * <code>optional uint32 fractional_digits = 9;</code>
     */
    int getFractionalDigits();

    /**
     * <code>optional uint32 length = 10;</code>
     */
    boolean hasLength();
    /**
     * <code>optional uint32 length = 10;</code>
     */
    int getLength();

    /**
     * <code>optional uint32 flags = 11;</code>
     */
    boolean hasFlags();
    /**
     * <code>optional uint32 flags = 11;</code>
     */
    int getFlags();

    /**
     * <code>optional uint32 content_type = 12;</code>
     */
    boolean hasContentType();
    /**
     * <code>optional uint32 content_type = 12;</code>
     */
    int getContentType();
  }
  /**
   * Protobuf type {@code Mysqlx.Resultset.ColumnMetaData}
   *
   * <pre>
   * meta data of a Column
   * .. note:: the encoding used for the different ``bytes`` fields in the meta data is externally
   *   controlled.
   *   .. seealso:: https://dev.mysql.com/doc/refman/5.0/en/charset-connection.html
   * .. note::
   *   The server may not set the ``original_{table|name}`` fields if they are equal to the plain
   *   ``{table|name}`` field.
   *   A client has to reconstruct it like::
   *     if .original_name is empty and .name is not empty:
   *       .original_name = .name
   *     if .original_table is empty and .table is not empty:
   *       .original_table = .table
   * .. note::
   *   ``compact metadata format`` can be requested by the client. In that case only ``.type`` is set and
   *   all other fields are empty.
   * :param type:
   *   .. table:: Expected Datatype of Mysqlx.Resultset.Row per SQL Type for non NULL values
   *     ================= ============ ======= ========== ====== ========
   *     SQL Type          .type        .length .frac_dig  .flags .charset
   *     ================= ============ ======= ========== ====== ========
   *     TINY              SINT         x
   *     TINY UNSIGNED     UINT         x                  x
   *     SHORT             SINT         x
   *     SHORT UNSIGNED    UINT         x                  x
   *     INT24             SINT         x
   *     INT24 UNSIGNED    UINT         x                  x
   *     INT               SINT         x
   *     INT UNSIGNED      UINT         x                  x
   *     LONGLONG          SINT         x
   *     LONGLONG UNSIGNED UINT         x                  x
   *     DOUBLE            DOUBLE       x       x          x
   *     FLOAT             FLOAT        x       x          x
   *     DECIMAL           DECIMAL      x       x          x
   *     VARCHAR,CHAR,...  BYTES        x                  x      x
   *     GEOMETRY          BYTES
   *     TIME              TIME         x
   *     DATE              DATETIME     x
   *     DATETIME          DATETIME     x
   *     YEAR              UINT         x                  x
   *     TIMESTAMP         DATETIME     x
   *     SET               SET                                    x
   *     ENUM              ENUM                                   x
   *     NULL              BYTES
   *     BIT               BIT          x
   *     ================= ============ ======= ========== ====== ========
   *   .. note:: the SQL "NULL" value is sent as an empty field value in :protobuf:msg:`Mysqlx.Resultset::Row`
   *   .. seealso:: protobuf encoding of primitive datatypes are decribed in https://developers.google.com/protocol-buffers/docs/encoding
   *   SINT
   *     ``.length``
   *       maximum number of displayable decimal digits (including minus sign) of the type
   *       .. note::
   *         valid range is 0-255, but usually you'll see 1-20
   *       =============== ==
   *       SQL Type        max digits per type
   *       =============== ==
   *       TINY SIGNED      4
   *       SHORT SIGNED     6
   *       INT24 SIGNED     8
   *       INT SIGNED      11
   *       LONGLONG SIGNED 20
   *       =============== ==
   *       .. seealso:: definition of ``M`` in https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
   *     ``value``
   *       variable length encoded signed 64 integer
   *   UINT
   *     ``.flags &amp; 1`` (zerofill)
   *       the client has to left pad with 0's up to .length
   *     ``.length``
   *       maximum number of displayable decimal digits of the type
   *       .. note::
   *         valid range is 0-255, but usually you'll see 1-20
   *       ================= ==
   *       SQL Type          max digits per type
   *       ================= ==
   *       TINY UNSIGNED      3
   *       SHORT UNSIGNED     5
   *       INT24 UNSIGNED     8
   *       INT UNSIGNED      10
   *       LONGLONG UNSIGNED 20
   *       ================= ==
   *       .. seealso:: definition of ``M`` in https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
   *     ``value``
   *       variable length encoded unsigned 64 integer
   *   BIT
   *     ``.length``
   *       maximum number of displayable binary digits
   *       .. note:: valid range for M of the ``BIT`` type is 1 - 64
   *       .. seealso:: https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
   *     ``value``
   *       variable length encoded unsigned 64 integer
   *   DOUBLE
   *     ``.length``
   *       maximum number of displayable decimal digits (including the decimal point and ``.fractional_digits``)
   *     ``.fractional_digits``
   *       maximum number of displayable decimal digits following the decimal point
   *     ``value``
   *       encoded as Protobuf's 'double'
   *   FLOAT
   *     ``.length``
   *       maximum number of displayable decimal digits (including the decimal point and ``.fractional_digits``)
   *     ``.fractional_digits``
   *       maximum number of displayable decimal digits following the decimal point
   *     ``value``
   *       encoded as Protobuf's 'float'
   *   BYTES, ENUM
   *     BYTES is used for all opaque byte strings that may have a charset
   *       * TINYBLOB, BLOB, MEDIUMBLOB, LONGBLOB
   *       * TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT
   *       * VARCHAR, VARBINARY
   *       * CHAR, BINARY
   *       * ENUM
   *     ``.length``
   *       the maximum length of characters of the underlying type
   *     ``.flags &amp; 1`` (rightpad)
   *       if the length of the field is less than ``.length``, the receiver is
   *       supposed to add padding characters to the right end of the string.
   *       If the ``.charset`` is "binary", the padding character is ``0x00``,
   *       otherwise it is a space character as defined by that character set.
   *       ============= ======= ======== =======
   *       SQL Type      .length .charset .flags
   *       ============= ======= ======== =======
   *       TINYBLOB      256     binary
   *       BLOB          65535   binary
   *       VARCHAR(32)   32      utf8
   *       VARBINARY(32) 32      utf8_bin
   *       BINARY(32)    32      binary   rightpad
   *       CHAR(32)      32      utf8     rightpad
   *       ============= ======= ======== =======
   *     ``value``
   *       sequence of bytes with added one extra '&#92;0' byte at the end. To obtain the
   *       original string, the extra '&#92;0' should be removed.
   *       .. note:: the length of the string can be acquired with protobuf's field length() method
   *         length of sequence-of-bytes = length-of-field - 1
   *       .. note:: the extra byte allows to distinguish between a NULL and empty byte sequence
   *   TIME
   *     A time value.
   *     ``value``
   *       the following bytes sequence:
   *         ``| negate [ | hour | [ | minutes | [ | seconds | [ | useconds | ]]]]``
   *       * negate - one byte, should be one of: 0x00 for "+", 0x01 for "-"
   *       * hour - optional variable length encoded unsigned64 value for the hour
   *       * minutes - optional variable length encoded unsigned64 value for the minutes
   *       * seconds - optional variable length encoded unsigned64 value for the seconds
   *       * useconds - optional variable length encoded unsigned64 value for the microseconds
   *       .. seealso:: protobuf encoding in https://developers.google.com/protocol-buffers/docs/encoding
   *       .. note:: hour, minutes, seconds, useconds are optional if all the values to the right are 0
   *       Example: 0x00 -&gt; +00:00:00.000000
   *   DATETIME
   *     A date or date and time value.
   *     ``value``
   *       a sequence of variants, arranged as follows:
   *         ``| year | month | day | [ | hour | [ | minutes | [ | seconds | [ | useconds | ]]]]``
   *       * year - variable length encoded unsigned64 value for the year
   *       * month - variable length encoded unsigned64 value for the month
   *       * day - variable length encoded unsigned64 value for the day
   *       * hour - optional variable length encoded unsigned64 value for the hour
   *       * minutes - optional variable length encoded unsigned64 value for the minutes
   *       * seconds - optional variable length encoded unsigned64 value for the seconds
   *       * useconds - optional variable length encoded unsigned64 value for the microseconds
   *       .. note:: hour, minutes, seconds, useconds are optional if all the values to the right are 0
   *     ``.flags &amp; 1`` (timestamp)
   *       ============= =======
   *       SQL Type      .flags
   *       ============= =======
   *       DATETIME
   *       TIMESTAMP     1
   *   DECIMAL
   *     An arbitrary length number. The number is encoded as a single byte
   *     indicating the position of the decimal point followed by the Packed BCD
   *     encoded number. Packed BCD is used to simplify conversion to and
   *     from strings and other native arbitrary precision math datatypes.
   *     .. seealso:: packed BCD in https://en.wikipedia.org/wiki/Binary-coded_decimal
   *     ``.length``
   *       maximum number of displayable decimal digits (*excluding* the decimal point and sign, but including ``.fractional_digits``)
   *       .. note:: should be in the range of 1 - 65
   *     ``.fractional_digits``
   *       is the decimal digits to display out of length
   *       .. note:: should be in the range of 0 - 30
   *     ``value``
   *       the following bytes sequence:
   *         ``| scale | BCD | sign | [0x0] |``
   *       * scale - 8bit scale value (number of decimal digit after the '.')
   *       * BCD - BCD encoded digits (4 bits for each digit)
   *       * sign - sign encoded on 4 bits (0xc = "+", 0xd = "-")
   *       * 0x0 - last 4bits if length(digits) % 2 == 0
   *       Example: x04 0x12 0x34 0x01 0xd0 -&gt; -12.3401
   *   SET
   *     A list of strings representing a SET of values.
   *     ``value``
   *       A sequence of 0 or more of protobuf's bytes (length prepended octets) or one of
   *       the special sequences with a predefined meaning listed below.
   *       Example (length of the bytes array shown in brackets):
   *         * ``[0]`` - the NULL value
   *         * ``[1] 0x00`` - a set containing a blank string ''
   *         * ``[1] 0x01`` - this would be an invalid value, but is to be treated as the empty set
   *         * ``[2] 0x01 0x00`` - a set with a single item, which is the '&#92;0' character
   *         * ``[8] 0x03 F O O 0x03 B A R`` - a set with 2 items: FOO,BAR
   * :param name: name of the column
   * :param original_name: name of the column before an alias was applied
   * :param table: name of the table the column orginates from
   * :param original_table: name of the table the column orginates from before an alias was applied
   * :param schema: schema the column originates from
   * :param catalog:
   *   catalog the schema originates from
   *   .. note::
   *     as there is current no support for catalogs in MySQL, don't expect this field to be set.
   *     In the MySQL C/S protocol the field had the value ``def`` all the time.
   * :param fractional_digits: displayed factional decimal digits for floating point and fixed point numbers
   * :param length: maximum count of displayable characters of .type
   * :param flags:
   *   ``.type`` specific flags
   *   ======= ====== ===========
   *   type    value  description
   *   ======= ====== ===========
   *   UINT    0x0001 zerofill
   *   DOUBLE  0x0001 unsigned
   *   FLOAT   0x0001 unsigned
   *   DECIMAL 0x0001 unsigned
   *   BYTES   0x0001 rightpad
   *   ======= ====== ===========
   *   ====== ================
   *   value  description
   *   ====== ================
   *   0x0010 NOT_NULL
   *   0x0020 PRIMARY_KEY
   *   0x0040 UNIQUE_KEY
   *   0x0080 MULTIPLE_KEY
   *   0x0100 AUTO_INCREMENT
   *   ====== ================
   *   default: 0
   * :param content_type:
   *   a hint about the higher-level encoding of a BYTES field, for more informations
   *   please refer to Mysqlx.Datatypes.ContentType enum.
   * </pre>
   */
  public static final class ColumnMetaData extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.ColumnMetaData)
      ColumnMetaDataOrBuilder {
    // Use ColumnMetaData.newBuilder() to construct.
    private ColumnMetaData(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private ColumnMetaData(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final ColumnMetaData defaultInstance;
    public static ColumnMetaData getDefaultInstance() {
      return defaultInstance;
    }

    public ColumnMetaData getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private ColumnMetaData(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType value = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                type_ = value;
              }
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              name_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              originalName_ = input.readBytes();
              break;
            }
            case 34: {
              bitField0_ |= 0x00000008;
              table_ = input.readBytes();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000010;
              originalTable_ = input.readBytes();
              break;
            }
            case 50: {
              bitField0_ |= 0x00000020;
              schema_ = input.readBytes();
              break;
            }
            case 58: {
              bitField0_ |= 0x00000040;
              catalog_ = input.readBytes();
              break;
            }
            case 64: {
              bitField0_ |= 0x00000080;
              collation_ = input.readUInt64();
              break;
            }
            case 72: {
              bitField0_ |= 0x00000100;
              fractionalDigits_ = input.readUInt32();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000200;
              length_ = input.readUInt32();
              break;
            }
            case 88: {
              bitField0_ |= 0x00000400;
              flags_ = input.readUInt32();
              break;
            }
            case 96: {
              bitField0_ |= 0x00000800;
              contentType_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.class, com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.Builder.class);
    }

    public static com.google.protobuf.Parser<ColumnMetaData> PARSER =
        new com.google.protobuf.AbstractParser<ColumnMetaData>() {
      public ColumnMetaData parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ColumnMetaData(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnMetaData> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Resultset.ColumnMetaData.FieldType}
     */
    public enum FieldType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>SINT = 1;</code>
       */
      SINT(0, 1),
      /**
       * <code>UINT = 2;</code>
       */
      UINT(1, 2),
      /**
       * <code>DOUBLE = 5;</code>
       */
      DOUBLE(2, 5),
      /**
       * <code>FLOAT = 6;</code>
       */
      FLOAT(3, 6),
      /**
       * <code>BYTES = 7;</code>
       */
      BYTES(4, 7),
      /**
       * <code>TIME = 10;</code>
       */
      TIME(5, 10),
      /**
       * <code>DATETIME = 12;</code>
       */
      DATETIME(6, 12),
      /**
       * <code>SET = 15;</code>
       */
      SET(7, 15),
      /**
       * <code>ENUM = 16;</code>
       */
      ENUM(8, 16),
      /**
       * <code>BIT = 17;</code>
       */
      BIT(9, 17),
      /**
       * <code>DECIMAL = 18;</code>
       */
      DECIMAL(10, 18),
      ;

      /**
       * <code>SINT = 1;</code>
       */
      public static final int SINT_VALUE = 1;
      /**
       * <code>UINT = 2;</code>
       */
      public static final int UINT_VALUE = 2;
      /**
       * <code>DOUBLE = 5;</code>
       */
      public static final int DOUBLE_VALUE = 5;
      /**
       * <code>FLOAT = 6;</code>
       */
      public static final int FLOAT_VALUE = 6;
      /**
       * <code>BYTES = 7;</code>
       */
      public static final int BYTES_VALUE = 7;
      /**
       * <code>TIME = 10;</code>
       */
      public static final int TIME_VALUE = 10;
      /**
       * <code>DATETIME = 12;</code>
       */
      public static final int DATETIME_VALUE = 12;
      /**
       * <code>SET = 15;</code>
       */
      public static final int SET_VALUE = 15;
      /**
       * <code>ENUM = 16;</code>
       */
      public static final int ENUM_VALUE = 16;
      /**
       * <code>BIT = 17;</code>
       */
      public static final int BIT_VALUE = 17;
      /**
       * <code>DECIMAL = 18;</code>
       */
      public static final int DECIMAL_VALUE = 18;


      public final int getNumber() { return value; }

      public static FieldType valueOf(int value) {
        switch (value) {
          case 1: return SINT;
          case 2: return UINT;
          case 5: return DOUBLE;
          case 6: return FLOAT;
          case 7: return BYTES;
          case 10: return TIME;
          case 12: return DATETIME;
          case 15: return SET;
          case 16: return ENUM;
          case 17: return BIT;
          case 18: return DECIMAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FieldType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<FieldType>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<FieldType>() {
              public FieldType findValueByNumber(int number) {
                return FieldType.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.getDescriptor().getEnumTypes().get(0);
      }

      private static final FieldType[] VALUES = values();

      public static FieldType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private FieldType(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Resultset.ColumnMetaData.FieldType)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType type_;
    /**
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     *
     * <pre>
     * datatype of the field in a row
     * </pre>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
     *
     * <pre>
     * datatype of the field in a row
     * </pre>
     */
    public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType getType() {
      return type_;
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString name_;
    /**
     * <code>optional bytes name = 2;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bytes name = 2;</code>
     */
    public com.google.protobuf.ByteString getName() {
      return name_;
    }

    public static final int ORIGINAL_NAME_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString originalName_;
    /**
     * <code>optional bytes original_name = 3;</code>
     */
    public boolean hasOriginalName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bytes original_name = 3;</code>
     */
    public com.google.protobuf.ByteString getOriginalName() {
      return originalName_;
    }

    public static final int TABLE_FIELD_NUMBER = 4;
    private com.google.protobuf.ByteString table_;
    /**
     * <code>optional bytes table = 4;</code>
     */
    public boolean hasTable() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional bytes table = 4;</code>
     */
    public com.google.protobuf.ByteString getTable() {
      return table_;
    }

    public static final int ORIGINAL_TABLE_FIELD_NUMBER = 5;
    private com.google.protobuf.ByteString originalTable_;
    /**
     * <code>optional bytes original_table = 5;</code>
     */
    public boolean hasOriginalTable() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional bytes original_table = 5;</code>
     */
    public com.google.protobuf.ByteString getOriginalTable() {
      return originalTable_;
    }

    public static final int SCHEMA_FIELD_NUMBER = 6;
    private com.google.protobuf.ByteString schema_;
    /**
     * <code>optional bytes schema = 6;</code>
     */
    public boolean hasSchema() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional bytes schema = 6;</code>
     */
    public com.google.protobuf.ByteString getSchema() {
      return schema_;
    }

    public static final int CATALOG_FIELD_NUMBER = 7;
    private com.google.protobuf.ByteString catalog_;
    /**
     * <code>optional bytes catalog = 7;</code>
     */
    public boolean hasCatalog() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional bytes catalog = 7;</code>
     */
    public com.google.protobuf.ByteString getCatalog() {
      return catalog_;
    }

    public static final int COLLATION_FIELD_NUMBER = 8;
    private long collation_;
    /**
     * <code>optional uint64 collation = 8;</code>
     */
    public boolean hasCollation() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional uint64 collation = 8;</code>
     */
    public long getCollation() {
      return collation_;
    }

    public static final int FRACTIONAL_DIGITS_FIELD_NUMBER = 9;
    private int fractionalDigits_;
    /**
     * <code>optional uint32 fractional_digits = 9;</code>
     */
    public boolean hasFractionalDigits() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>optional uint32 fractional_digits = 9;</code>
     */
    public int getFractionalDigits() {
      return fractionalDigits_;
    }

    public static final int LENGTH_FIELD_NUMBER = 10;
    private int length_;
    /**
     * <code>optional uint32 length = 10;</code>
     */
    public boolean hasLength() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>optional uint32 length = 10;</code>
     */
    public int getLength() {
      return length_;
    }

    public static final int FLAGS_FIELD_NUMBER = 11;
    private int flags_;
    /**
     * <code>optional uint32 flags = 11;</code>
     */
    public boolean hasFlags() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <code>optional uint32 flags = 11;</code>
     */
    public int getFlags() {
      return flags_;
    }

    public static final int CONTENT_TYPE_FIELD_NUMBER = 12;
    private int contentType_;
    /**
     * <code>optional uint32 content_type = 12;</code>
     */
    public boolean hasContentType() {
      return ((bitField0_ & 0x00000800) == 0x00000800);
    }
    /**
     * <code>optional uint32 content_type = 12;</code>
     */
    public int getContentType() {
      return contentType_;
    }

    private void initFields() {
      type_ = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.SINT;
      name_ = com.google.protobuf.ByteString.EMPTY;
      originalName_ = com.google.protobuf.ByteString.EMPTY;
      table_ = com.google.protobuf.ByteString.EMPTY;
      originalTable_ = com.google.protobuf.ByteString.EMPTY;
      schema_ = com.google.protobuf.ByteString.EMPTY;
      catalog_ = com.google.protobuf.ByteString.EMPTY;
      collation_ = 0L;
      fractionalDigits_ = 0;
      length_ = 0;
      flags_ = 0;
      contentType_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, name_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, originalName_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeBytes(4, table_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeBytes(5, originalTable_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBytes(6, schema_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBytes(7, catalog_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeUInt64(8, collation_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeUInt32(9, fractionalDigits_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeUInt32(10, length_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeUInt32(11, flags_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        output.writeUInt32(12, contentType_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, name_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, originalName_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(4, table_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, originalTable_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(6, schema_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(7, catalog_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(8, collation_);
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(9, fractionalDigits_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(10, length_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(11, flags_);
      }
      if (((bitField0_ & 0x00000800) == 0x00000800)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(12, contentType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Resultset.ColumnMetaData}
     *
     * <pre>
     * meta data of a Column
     * .. note:: the encoding used for the different ``bytes`` fields in the meta data is externally
     *   controlled.
     *   .. seealso:: https://dev.mysql.com/doc/refman/5.0/en/charset-connection.html
     * .. note::
     *   The server may not set the ``original_{table|name}`` fields if they are equal to the plain
     *   ``{table|name}`` field.
     *   A client has to reconstruct it like::
     *     if .original_name is empty and .name is not empty:
     *       .original_name = .name
     *     if .original_table is empty and .table is not empty:
     *       .original_table = .table
     * .. note::
     *   ``compact metadata format`` can be requested by the client. In that case only ``.type`` is set and
     *   all other fields are empty.
     * :param type:
     *   .. table:: Expected Datatype of Mysqlx.Resultset.Row per SQL Type for non NULL values
     *     ================= ============ ======= ========== ====== ========
     *     SQL Type          .type        .length .frac_dig  .flags .charset
     *     ================= ============ ======= ========== ====== ========
     *     TINY              SINT         x
     *     TINY UNSIGNED     UINT         x                  x
     *     SHORT             SINT         x
     *     SHORT UNSIGNED    UINT         x                  x
     *     INT24             SINT         x
     *     INT24 UNSIGNED    UINT         x                  x
     *     INT               SINT         x
     *     INT UNSIGNED      UINT         x                  x
     *     LONGLONG          SINT         x
     *     LONGLONG UNSIGNED UINT         x                  x
     *     DOUBLE            DOUBLE       x       x          x
     *     FLOAT             FLOAT        x       x          x
     *     DECIMAL           DECIMAL      x       x          x
     *     VARCHAR,CHAR,...  BYTES        x                  x      x
     *     GEOMETRY          BYTES
     *     TIME              TIME         x
     *     DATE              DATETIME     x
     *     DATETIME          DATETIME     x
     *     YEAR              UINT         x                  x
     *     TIMESTAMP         DATETIME     x
     *     SET               SET                                    x
     *     ENUM              ENUM                                   x
     *     NULL              BYTES
     *     BIT               BIT          x
     *     ================= ============ ======= ========== ====== ========
     *   .. note:: the SQL "NULL" value is sent as an empty field value in :protobuf:msg:`Mysqlx.Resultset::Row`
     *   .. seealso:: protobuf encoding of primitive datatypes are decribed in https://developers.google.com/protocol-buffers/docs/encoding
     *   SINT
     *     ``.length``
     *       maximum number of displayable decimal digits (including minus sign) of the type
     *       .. note::
     *         valid range is 0-255, but usually you'll see 1-20
     *       =============== ==
     *       SQL Type        max digits per type
     *       =============== ==
     *       TINY SIGNED      4
     *       SHORT SIGNED     6
     *       INT24 SIGNED     8
     *       INT SIGNED      11
     *       LONGLONG SIGNED 20
     *       =============== ==
     *       .. seealso:: definition of ``M`` in https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
     *     ``value``
     *       variable length encoded signed 64 integer
     *   UINT
     *     ``.flags &amp; 1`` (zerofill)
     *       the client has to left pad with 0's up to .length
     *     ``.length``
     *       maximum number of displayable decimal digits of the type
     *       .. note::
     *         valid range is 0-255, but usually you'll see 1-20
     *       ================= ==
     *       SQL Type          max digits per type
     *       ================= ==
     *       TINY UNSIGNED      3
     *       SHORT UNSIGNED     5
     *       INT24 UNSIGNED     8
     *       INT UNSIGNED      10
     *       LONGLONG UNSIGNED 20
     *       ================= ==
     *       .. seealso:: definition of ``M`` in https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
     *     ``value``
     *       variable length encoded unsigned 64 integer
     *   BIT
     *     ``.length``
     *       maximum number of displayable binary digits
     *       .. note:: valid range for M of the ``BIT`` type is 1 - 64
     *       .. seealso:: https://dev.mysql.com/doc/refman/5.5/en/numeric-type-overview.html
     *     ``value``
     *       variable length encoded unsigned 64 integer
     *   DOUBLE
     *     ``.length``
     *       maximum number of displayable decimal digits (including the decimal point and ``.fractional_digits``)
     *     ``.fractional_digits``
     *       maximum number of displayable decimal digits following the decimal point
     *     ``value``
     *       encoded as Protobuf's 'double'
     *   FLOAT
     *     ``.length``
     *       maximum number of displayable decimal digits (including the decimal point and ``.fractional_digits``)
     *     ``.fractional_digits``
     *       maximum number of displayable decimal digits following the decimal point
     *     ``value``
     *       encoded as Protobuf's 'float'
     *   BYTES, ENUM
     *     BYTES is used for all opaque byte strings that may have a charset
     *       * TINYBLOB, BLOB, MEDIUMBLOB, LONGBLOB
     *       * TINYTEXT, TEXT, MEDIUMTEXT, LONGTEXT
     *       * VARCHAR, VARBINARY
     *       * CHAR, BINARY
     *       * ENUM
     *     ``.length``
     *       the maximum length of characters of the underlying type
     *     ``.flags &amp; 1`` (rightpad)
     *       if the length of the field is less than ``.length``, the receiver is
     *       supposed to add padding characters to the right end of the string.
     *       If the ``.charset`` is "binary", the padding character is ``0x00``,
     *       otherwise it is a space character as defined by that character set.
     *       ============= ======= ======== =======
     *       SQL Type      .length .charset .flags
     *       ============= ======= ======== =======
     *       TINYBLOB      256     binary
     *       BLOB          65535   binary
     *       VARCHAR(32)   32      utf8
     *       VARBINARY(32) 32      utf8_bin
     *       BINARY(32)    32      binary   rightpad
     *       CHAR(32)      32      utf8     rightpad
     *       ============= ======= ======== =======
     *     ``value``
     *       sequence of bytes with added one extra '&#92;0' byte at the end. To obtain the
     *       original string, the extra '&#92;0' should be removed.
     *       .. note:: the length of the string can be acquired with protobuf's field length() method
     *         length of sequence-of-bytes = length-of-field - 1
     *       .. note:: the extra byte allows to distinguish between a NULL and empty byte sequence
     *   TIME
     *     A time value.
     *     ``value``
     *       the following bytes sequence:
     *         ``| negate [ | hour | [ | minutes | [ | seconds | [ | useconds | ]]]]``
     *       * negate - one byte, should be one of: 0x00 for "+", 0x01 for "-"
     *       * hour - optional variable length encoded unsigned64 value for the hour
     *       * minutes - optional variable length encoded unsigned64 value for the minutes
     *       * seconds - optional variable length encoded unsigned64 value for the seconds
     *       * useconds - optional variable length encoded unsigned64 value for the microseconds
     *       .. seealso:: protobuf encoding in https://developers.google.com/protocol-buffers/docs/encoding
     *       .. note:: hour, minutes, seconds, useconds are optional if all the values to the right are 0
     *       Example: 0x00 -&gt; +00:00:00.000000
     *   DATETIME
     *     A date or date and time value.
     *     ``value``
     *       a sequence of variants, arranged as follows:
     *         ``| year | month | day | [ | hour | [ | minutes | [ | seconds | [ | useconds | ]]]]``
     *       * year - variable length encoded unsigned64 value for the year
     *       * month - variable length encoded unsigned64 value for the month
     *       * day - variable length encoded unsigned64 value for the day
     *       * hour - optional variable length encoded unsigned64 value for the hour
     *       * minutes - optional variable length encoded unsigned64 value for the minutes
     *       * seconds - optional variable length encoded unsigned64 value for the seconds
     *       * useconds - optional variable length encoded unsigned64 value for the microseconds
     *       .. note:: hour, minutes, seconds, useconds are optional if all the values to the right are 0
     *     ``.flags &amp; 1`` (timestamp)
     *       ============= =======
     *       SQL Type      .flags
     *       ============= =======
     *       DATETIME
     *       TIMESTAMP     1
     *   DECIMAL
     *     An arbitrary length number. The number is encoded as a single byte
     *     indicating the position of the decimal point followed by the Packed BCD
     *     encoded number. Packed BCD is used to simplify conversion to and
     *     from strings and other native arbitrary precision math datatypes.
     *     .. seealso:: packed BCD in https://en.wikipedia.org/wiki/Binary-coded_decimal
     *     ``.length``
     *       maximum number of displayable decimal digits (*excluding* the decimal point and sign, but including ``.fractional_digits``)
     *       .. note:: should be in the range of 1 - 65
     *     ``.fractional_digits``
     *       is the decimal digits to display out of length
     *       .. note:: should be in the range of 0 - 30
     *     ``value``
     *       the following bytes sequence:
     *         ``| scale | BCD | sign | [0x0] |``
     *       * scale - 8bit scale value (number of decimal digit after the '.')
     *       * BCD - BCD encoded digits (4 bits for each digit)
     *       * sign - sign encoded on 4 bits (0xc = "+", 0xd = "-")
     *       * 0x0 - last 4bits if length(digits) % 2 == 0
     *       Example: x04 0x12 0x34 0x01 0xd0 -&gt; -12.3401
     *   SET
     *     A list of strings representing a SET of values.
     *     ``value``
     *       A sequence of 0 or more of protobuf's bytes (length prepended octets) or one of
     *       the special sequences with a predefined meaning listed below.
     *       Example (length of the bytes array shown in brackets):
     *         * ``[0]`` - the NULL value
     *         * ``[1] 0x00`` - a set containing a blank string ''
     *         * ``[1] 0x01`` - this would be an invalid value, but is to be treated as the empty set
     *         * ``[2] 0x01 0x00`` - a set with a single item, which is the '&#92;0' character
     *         * ``[8] 0x03 F O O 0x03 B A R`` - a set with 2 items: FOO,BAR
     * :param name: name of the column
     * :param original_name: name of the column before an alias was applied
     * :param table: name of the table the column orginates from
     * :param original_table: name of the table the column orginates from before an alias was applied
     * :param schema: schema the column originates from
     * :param catalog:
     *   catalog the schema originates from
     *   .. note::
     *     as there is current no support for catalogs in MySQL, don't expect this field to be set.
     *     In the MySQL C/S protocol the field had the value ``def`` all the time.
     * :param fractional_digits: displayed factional decimal digits for floating point and fixed point numbers
     * :param length: maximum count of displayable characters of .type
     * :param flags:
     *   ``.type`` specific flags
     *   ======= ====== ===========
     *   type    value  description
     *   ======= ====== ===========
     *   UINT    0x0001 zerofill
     *   DOUBLE  0x0001 unsigned
     *   FLOAT   0x0001 unsigned
     *   DECIMAL 0x0001 unsigned
     *   BYTES   0x0001 rightpad
     *   ======= ====== ===========
     *   ====== ================
     *   value  description
     *   ====== ================
     *   0x0010 NOT_NULL
     *   0x0020 PRIMARY_KEY
     *   0x0040 UNIQUE_KEY
     *   0x0080 MULTIPLE_KEY
     *   0x0100 AUTO_INCREMENT
     *   ====== ================
     *   default: 0
     * :param content_type:
     *   a hint about the higher-level encoding of a BYTES field, for more informations
     *   please refer to Mysqlx.Datatypes.ContentType enum.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.ColumnMetaData)
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.class, com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.SINT;
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        originalName_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        table_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        originalTable_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000010);
        schema_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000020);
        catalog_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000040);
        collation_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000080);
        fractionalDigits_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        length_ = 0;
        bitField0_ = (bitField0_ & ~0x00000200);
        flags_ = 0;
        bitField0_ = (bitField0_ & ~0x00000400);
        contentType_ = 0;
        bitField0_ = (bitField0_ & ~0x00000800);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData result = new com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.originalName_ = originalName_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.table_ = table_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.originalTable_ = originalTable_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.schema_ = schema_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.catalog_ = catalog_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        result.collation_ = collation_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.fractionalDigits_ = fractionalDigits_;
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000200;
        }
        result.length_ = length_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000400;
        }
        result.flags_ = flags_;
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000800;
        }
        result.contentType_ = contentType_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasName()) {
          setName(other.getName());
        }
        if (other.hasOriginalName()) {
          setOriginalName(other.getOriginalName());
        }
        if (other.hasTable()) {
          setTable(other.getTable());
        }
        if (other.hasOriginalTable()) {
          setOriginalTable(other.getOriginalTable());
        }
        if (other.hasSchema()) {
          setSchema(other.getSchema());
        }
        if (other.hasCatalog()) {
          setCatalog(other.getCatalog());
        }
        if (other.hasCollation()) {
          setCollation(other.getCollation());
        }
        if (other.hasFractionalDigits()) {
          setFractionalDigits(other.getFractionalDigits());
        }
        if (other.hasLength()) {
          setLength(other.getLength());
        }
        if (other.hasFlags()) {
          setFlags(other.getFlags());
        }
        if (other.hasContentType()) {
          setContentType(other.getContentType());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasType()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType type_ = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.SINT;
      /**
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       *
       * <pre>
       * datatype of the field in a row
       * </pre>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       *
       * <pre>
       * datatype of the field in a row
       * </pre>
       */
      public com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType getType() {
        return type_;
      }
      /**
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       *
       * <pre>
       * datatype of the field in a row
       * </pre>
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Resultset.ColumnMetaData.FieldType type = 1;</code>
       *
       * <pre>
       * datatype of the field in a row
       * </pre>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = com.mysql.cj.x.protobuf.MysqlxResultset.ColumnMetaData.FieldType.SINT;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString name_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes name = 2;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bytes name = 2;</code>
       */
      public com.google.protobuf.ByteString getName() {
        return name_;
      }
      /**
       * <code>optional bytes name = 2;</code>
       */
      public Builder setName(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes name = 2;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString originalName_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes original_name = 3;</code>
       */
      public boolean hasOriginalName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bytes original_name = 3;</code>
       */
      public com.google.protobuf.ByteString getOriginalName() {
        return originalName_;
      }
      /**
       * <code>optional bytes original_name = 3;</code>
       */
      public Builder setOriginalName(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        originalName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes original_name = 3;</code>
       */
      public Builder clearOriginalName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        originalName_ = getDefaultInstance().getOriginalName();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString table_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes table = 4;</code>
       */
      public boolean hasTable() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional bytes table = 4;</code>
       */
      public com.google.protobuf.ByteString getTable() {
        return table_;
      }
      /**
       * <code>optional bytes table = 4;</code>
       */
      public Builder setTable(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        table_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes table = 4;</code>
       */
      public Builder clearTable() {
        bitField0_ = (bitField0_ & ~0x00000008);
        table_ = getDefaultInstance().getTable();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString originalTable_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes original_table = 5;</code>
       */
      public boolean hasOriginalTable() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional bytes original_table = 5;</code>
       */
      public com.google.protobuf.ByteString getOriginalTable() {
        return originalTable_;
      }
      /**
       * <code>optional bytes original_table = 5;</code>
       */
      public Builder setOriginalTable(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        originalTable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes original_table = 5;</code>
       */
      public Builder clearOriginalTable() {
        bitField0_ = (bitField0_ & ~0x00000010);
        originalTable_ = getDefaultInstance().getOriginalTable();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString schema_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes schema = 6;</code>
       */
      public boolean hasSchema() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional bytes schema = 6;</code>
       */
      public com.google.protobuf.ByteString getSchema() {
        return schema_;
      }
      /**
       * <code>optional bytes schema = 6;</code>
       */
      public Builder setSchema(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        schema_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes schema = 6;</code>
       */
      public Builder clearSchema() {
        bitField0_ = (bitField0_ & ~0x00000020);
        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString catalog_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes catalog = 7;</code>
       */
      public boolean hasCatalog() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional bytes catalog = 7;</code>
       */
      public com.google.protobuf.ByteString getCatalog() {
        return catalog_;
      }
      /**
       * <code>optional bytes catalog = 7;</code>
       */
      public Builder setCatalog(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
        catalog_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes catalog = 7;</code>
       */
      public Builder clearCatalog() {
        bitField0_ = (bitField0_ & ~0x00000040);
        catalog_ = getDefaultInstance().getCatalog();
        onChanged();
        return this;
      }

      private long collation_ ;
      /**
       * <code>optional uint64 collation = 8;</code>
       */
      public boolean hasCollation() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional uint64 collation = 8;</code>
       */
      public long getCollation() {
        return collation_;
      }
      /**
       * <code>optional uint64 collation = 8;</code>
       */
      public Builder setCollation(long value) {
        bitField0_ |= 0x00000080;
        collation_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 collation = 8;</code>
       */
      public Builder clearCollation() {
        bitField0_ = (bitField0_ & ~0x00000080);
        collation_ = 0L;
        onChanged();
        return this;
      }

      private int fractionalDigits_ ;
      /**
       * <code>optional uint32 fractional_digits = 9;</code>
       */
      public boolean hasFractionalDigits() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional uint32 fractional_digits = 9;</code>
       */
      public int getFractionalDigits() {
        return fractionalDigits_;
      }
      /**
       * <code>optional uint32 fractional_digits = 9;</code>
       */
      public Builder setFractionalDigits(int value) {
        bitField0_ |= 0x00000100;
        fractionalDigits_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 fractional_digits = 9;</code>
       */
      public Builder clearFractionalDigits() {
        bitField0_ = (bitField0_ & ~0x00000100);
        fractionalDigits_ = 0;
        onChanged();
        return this;
      }

      private int length_ ;
      /**
       * <code>optional uint32 length = 10;</code>
       */
      public boolean hasLength() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>optional uint32 length = 10;</code>
       */
      public int getLength() {
        return length_;
      }
      /**
       * <code>optional uint32 length = 10;</code>
       */
      public Builder setLength(int value) {
        bitField0_ |= 0x00000200;
        length_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 length = 10;</code>
       */
      public Builder clearLength() {
        bitField0_ = (bitField0_ & ~0x00000200);
        length_ = 0;
        onChanged();
        return this;
      }

      private int flags_ ;
      /**
       * <code>optional uint32 flags = 11;</code>
       */
      public boolean hasFlags() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <code>optional uint32 flags = 11;</code>
       */
      public int getFlags() {
        return flags_;
      }
      /**
       * <code>optional uint32 flags = 11;</code>
       */
      public Builder setFlags(int value) {
        bitField0_ |= 0x00000400;
        flags_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 flags = 11;</code>
       */
      public Builder clearFlags() {
        bitField0_ = (bitField0_ & ~0x00000400);
        flags_ = 0;
        onChanged();
        return this;
      }

      private int contentType_ ;
      /**
       * <code>optional uint32 content_type = 12;</code>
       */
      public boolean hasContentType() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <code>optional uint32 content_type = 12;</code>
       */
      public int getContentType() {
        return contentType_;
      }
      /**
       * <code>optional uint32 content_type = 12;</code>
       */
      public Builder setContentType(int value) {
        bitField0_ |= 0x00000800;
        contentType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 content_type = 12;</code>
       */
      public Builder clearContentType() {
        bitField0_ = (bitField0_ & ~0x00000800);
        contentType_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.ColumnMetaData)
    }

    static {
      defaultInstance = new ColumnMetaData(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.ColumnMetaData)
  }

  public interface RowOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Resultset.Row)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated bytes field = 1;</code>
     */
    java.util.List<com.google.protobuf.ByteString> getFieldList();
    /**
     * <code>repeated bytes field = 1;</code>
     */
    int getFieldCount();
    /**
     * <code>repeated bytes field = 1;</code>
     */
    com.google.protobuf.ByteString getField(int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Resultset.Row}
   *
   * <pre>
   *   Row in a Resultset
   *   a row is represented as a list of fields encoded as byte blobs.
   *   Blob of size 0 represents the NULL value. Otherwise, if it contains at least
   *   one byte, it encodes a non-null value of the field using encoding appropriate for the
   *   type of the value given by ``ColumnMetadata``, as specified
   *   in the :protobuf:msg:`Mysqlx.Resultset::ColumnMetaData` description.
   * </pre>
   */
  public static final class Row extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Resultset.Row)
      RowOrBuilder {
    // Use Row.newBuilder() to construct.
    private Row(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Row(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Row defaultInstance;
    public static Row getDefaultInstance() {
      return defaultInstance;
    }

    public Row getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Row(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                field_ = new java.util.ArrayList<com.google.protobuf.ByteString>();
                mutable_bitField0_ |= 0x00000001;
              }
              field_.add(input.readBytes());
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          field_ = java.util.Collections.unmodifiableList(field_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxResultset.Row.class, com.mysql.cj.x.protobuf.MysqlxResultset.Row.Builder.class);
    }

    public static com.google.protobuf.Parser<Row> PARSER =
        new com.google.protobuf.AbstractParser<Row>() {
      public Row parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Row(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Row> getParserForType() {
      return PARSER;
    }

    public static final int FIELD_FIELD_NUMBER = 1;
    private java.util.List<com.google.protobuf.ByteString> field_;
    /**
     * <code>repeated bytes field = 1;</code>
     */
    public java.util.List<com.google.protobuf.ByteString>
        getFieldList() {
      return field_;
    }
    /**
     * <code>repeated bytes field = 1;</code>
     */
    public int getFieldCount() {
      return field_.size();
    }
    /**
     * <code>repeated bytes field = 1;</code>
     */
    public com.google.protobuf.ByteString getField(int index) {
      return field_.get(index);
    }

    private void initFields() {
      field_ = java.util.Collections.emptyList();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < field_.size(); i++) {
        output.writeBytes(1, field_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < field_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeBytesSizeNoTag(field_.get(i));
        }
        size += dataSize;
        size += 1 * getFieldList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxResultset.Row parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxResultset.Row prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Resultset.Row}
     *
     * <pre>
     *   Row in a Resultset
     *   a row is represented as a list of fields encoded as byte blobs.
     *   Blob of size 0 represents the NULL value. Otherwise, if it contains at least
     *   one byte, it encodes a non-null value of the field using encoding appropriate for the
     *   type of the value given by ``ColumnMetadata``, as specified
     *   in the :protobuf:msg:`Mysqlx.Resultset::ColumnMetaData` description.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Resultset.Row)
        com.mysql.cj.x.protobuf.MysqlxResultset.RowOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxResultset.Row.class, com.mysql.cj.x.protobuf.MysqlxResultset.Row.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxResultset.Row.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        field_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.internal_static_Mysqlx_Resultset_Row_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.Row getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxResultset.Row.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.Row build() {
        com.mysql.cj.x.protobuf.MysqlxResultset.Row result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxResultset.Row buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxResultset.Row result = new com.mysql.cj.x.protobuf.MysqlxResultset.Row(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          field_ = java.util.Collections.unmodifiableList(field_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.field_ = field_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxResultset.Row) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxResultset.Row)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxResultset.Row other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxResultset.Row.getDefaultInstance()) return this;
        if (!other.field_.isEmpty()) {
          if (field_.isEmpty()) {
            field_ = other.field_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFieldIsMutable();
            field_.addAll(other.field_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxResultset.Row parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxResultset.Row) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.google.protobuf.ByteString> field_ = java.util.Collections.emptyList();
      private void ensureFieldIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          field_ = new java.util.ArrayList<com.google.protobuf.ByteString>(field_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public java.util.List<com.google.protobuf.ByteString>
          getFieldList() {
        return java.util.Collections.unmodifiableList(field_);
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public int getFieldCount() {
        return field_.size();
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public com.google.protobuf.ByteString getField(int index) {
        return field_.get(index);
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public Builder setField(
          int index, com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureFieldIsMutable();
        field_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public Builder addField(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureFieldIsMutable();
        field_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public Builder addAllField(
          java.lang.Iterable<? extends com.google.protobuf.ByteString> values) {
        ensureFieldIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, field_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated bytes field = 1;</code>
       */
      public Builder clearField() {
        field_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Resultset.Row)
    }

    static {
      defaultInstance = new Row(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Resultset.Row)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_FetchDone_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Resultset_Row_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Resultset_Row_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026mysqlx_resultset.proto\022\020Mysqlx.Results" +
      "et\"\030\n\026FetchDoneMoreOutParams\"\031\n\027FetchDon" +
      "eMoreResultsets\"\013\n\tFetchDone\"\237\003\n\016ColumnM" +
      "etaData\0228\n\004type\030\001 \002(\0162*.Mysqlx.Resultset" +
      ".ColumnMetaData.FieldType\022\014\n\004name\030\002 \001(\014\022" +
      "\025\n\roriginal_name\030\003 \001(\014\022\r\n\005table\030\004 \001(\014\022\026\n" +
      "\016original_table\030\005 \001(\014\022\016\n\006schema\030\006 \001(\014\022\017\n" +
      "\007catalog\030\007 \001(\014\022\021\n\tcollation\030\010 \001(\004\022\031\n\021fra" +
      "ctional_digits\030\t \001(\r\022\016\n\006length\030\n \001(\r\022\r\n\005" +
      "flags\030\013 \001(\r\022\024\n\014content_type\030\014 \001(\r\"\202\001\n\tFi",
      "eldType\022\010\n\004SINT\020\001\022\010\n\004UINT\020\002\022\n\n\006DOUBLE\020\005\022" +
      "\t\n\005FLOAT\020\006\022\t\n\005BYTES\020\007\022\010\n\004TIME\020\n\022\014\n\010DATET" +
      "IME\020\014\022\007\n\003SET\020\017\022\010\n\004ENUM\020\020\022\007\n\003BIT\020\021\022\013\n\007DEC" +
      "IMAL\020\022\"\024\n\003Row\022\r\n\005field\030\001 \003(\014B\031\n\027com.mysq" +
      "l.cj.x.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchDoneMoreOutParams_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchDoneMoreResultsets_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_FetchDone_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Resultset_FetchDone_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_FetchDone_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Resultset_ColumnMetaData_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_ColumnMetaData_descriptor,
        new java.lang.String[] { "Type", "Name", "OriginalName", "Table", "OriginalTable", "Schema", "Catalog", "Collation", "FractionalDigits", "Length", "Flags", "ContentType", });
    internal_static_Mysqlx_Resultset_Row_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Resultset_Row_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Resultset_Row_descriptor,
        new java.lang.String[] { "Field", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
