/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Equals;
import com.mysql.management.util.MapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DefaultsMap
implements Map {
    private Map changed;
    private Map original = new LinkedHashMap();
    private Equals equals;

    public DefaultsMap() {
        this.changed = new LinkedHashMap();
        this.equals = new Equals();
    }

    public Map getChanged() {
        return new HashMap(this.changed);
    }

    public Object getDefault(Object key) {
        return this.original.get(key);
    }

    @Override
    public void clear() {
        this.changed.clear();
        this.original.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.original.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            Object val = this.get(iter.next());
            if (!(value == null ? val == null : value.equals(val))) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        LinkedHashSet<MapEntry> entries = new LinkedHashSet<MapEntry>();
        Iterator iter = this.original.entrySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next().getKey();
            entries.add(new MapEntry(key, this.get(key)));
        }
        return entries;
    }

    public Object get(Object key) {
        if (this.changed.containsKey(key)) {
            return this.changed.get(key);
        }
        return this.original.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.original.size() == 0;
    }

    public Set keySet() {
        return this.original.keySet();
    }

    public Object put(Object key, Object value) {
        if (!this.original.containsKey(key)) {
            return this.original.put(key, value);
        }
        Object originalVal = this.original.get(key);
        if (!this.equals.nullSafe(originalVal, value)) {
            return this.changed.put(key, value);
        }
        if (this.changed.containsKey(key)) {
            return this.changed.remove(key);
        }
        return this.original.put(key, value);
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        Object oldVal = this.original.remove(key);
        if (this.changed.containsKey(key)) {
            return this.changed.remove(key);
        }
        return oldVal;
    }

    @Override
    public int size() {
        return this.original.size();
    }

    public Collection values() {
        ArrayList<Object> values = new ArrayList<Object>(this.original.size());
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            values.add(this.get(iter.next()));
        }
        return values;
    }
}

