/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Files;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import junit.framework.Assert;
import junit.framework.TestCase;

public class FilesTest
extends TestCase {
    private Files fileUtil;
    private File foo;
    private File defaultDir;
    private TestUtil testUtil;

    protected void setUp() {
        this.fileUtil = new Files();
        this.testUtil = new TestUtil();
    }

    protected void tearDown() throws Exception {
        if (this.foo != null) {
            this.fileUtil.deleteTree(this.foo);
        }
        if (this.defaultDir != null) {
            this.fileUtil.deleteTree(this.defaultDir);
        }
    }

    public void testTempDir() throws Exception {
        String property = System.getProperty("java.io.tmpdir");
        FilesTest.assertNotNull((Object)property);
        File javaTmp = new File(property);
        FilesTest.assertEquals((String)javaTmp.getPath(), (boolean)true, (boolean)javaTmp.exists());
        File testParent = this.fileUtil.testDir().getParentFile();
        FilesTest.assertEquals((Object)javaTmp.getCanonicalFile(), (Object)testParent.getCanonicalFile());
    }

    private void writeToFile(File file, String text) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter out = new PrintWriter(fos);
        out.print(text);
        out.close();
    }

    public void testDeleteTree() throws FileNotFoundException {
        this.foo = new File(this.fileUtil.testDir(), "foo");
        File bar = new File(this.foo, "bar");
        bar.mkdirs();
        FilesTest.assertEquals((boolean)true, (boolean)bar.exists());
        File baz = new File(this.foo, "baz");
        this.writeToFile(baz, "baz");
        FilesTest.assertEquals((boolean)true, (boolean)baz.exists());
        FilesTest.assertEquals((long)3L, (long)baz.length());
        FilesTest.assertEquals((boolean)true, (boolean)this.fileUtil.deleteTree(this.foo));
        FilesTest.assertEquals((boolean)false, (boolean)this.foo.exists());
    }

    public void testMakeExecutable() {
        class FakeShellStub
        extends Shell.Stub {
            String[] args;
            int runCalled = 0;

            FakeShellStub() {
            }

            @Override
            public void run() {
                ++this.runCalled;
            }
        }
        final FakeShellStub shell = new FakeShellStub();
        class FakeShellFactory
        extends Shell.Factory {
            FakeShellFactory() {
            }

            @Override
            public Shell newShell(String[] args, String name, PrintStream out, PrintStream err) {
                Assert.assertNotNull((Object)name);
                Assert.assertNotNull((Object)out);
                Assert.assertNotNull((Object)err);
                shell.args = args;
                return shell;
            }
        }
        this.fileUtil = new Files(new FakeShellFactory(), '\\', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        FilesTest.assertNull((Object)shell.args);
        FilesTest.assertEquals((int)0, (int)shell.runCalled);
        this.fileUtil = new Files(new FakeShellFactory(), '/', new Streams());
        this.fileUtil.addExecutableRights(new File("bogus"), System.out, System.err);
        FilesTest.assertEquals((int)1, (int)shell.runCalled);
        FilesTest.assertEquals((int)3, (int)shell.args.length);
        FilesTest.assertEquals((String)"chmod", (String)shell.args[0]);
        FilesTest.assertEquals((String)"+x", (String)shell.args[1]);
        FilesTest.assertTrue((shell.args[2].indexOf("bogus") >= 0 ? 1 : 0) != 0);
    }

    public void testValidCononicalDir() throws Exception {
        this.foo = this.fileUtil.tmp("foo");
        File cononicalFoo = this.foo.getCanonicalFile();
        this.defaultDir = this.fileUtil.tmp("defaultDir");
        File valid = this.fileUtil.validCononicalDir(this.foo);
        FilesTest.assertEquals((Object)cononicalFoo, (Object)valid);
        valid = this.fileUtil.validCononicalDir(this.foo, this.defaultDir);
        FilesTest.assertEquals((Object)cononicalFoo, (Object)valid);
        valid = this.fileUtil.validCononicalDir(null, this.defaultDir);
        FilesTest.assertEquals((Object)this.defaultDir, (Object)valid);
        File testDir = this.fileUtil.testDir();
        FilesTest.assertEquals((Object)testDir, (Object)this.fileUtil.validCononicalDir(testDir));
        File bar = new File(testDir, "junkFile.txt");
        bar.deleteOnExit();
        this.writeToFile(bar, "junk");
        IllegalArgumentException expected = null;
        try {
            this.fileUtil.validCononicalDir(bar);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        FilesTest.assertNotNull((Object)expected);
        this.testUtil.assertContainsIgnoreCase(expected.getMessage(), "directory");
        expected = null;
        try {
            this.fileUtil.validCononicalDir(null);
        }
        catch (IllegalArgumentException e) {
            expected = e;
        }
        FilesTest.assertNotNull((Object)expected);
        this.testUtil.assertContainsIgnoreCase(expected.getMessage(), "null");
    }

    public void testIsEmpty() throws Exception {
        this.foo = this.fileUtil.tmp("foo");
        FilesTest.assertEquals((boolean)false, (boolean)this.foo.exists());
        FilesTest.assertEquals((boolean)true, (boolean)this.fileUtil.isEmpty(this.foo));
        this.foo.mkdirs();
        FilesTest.assertEquals((boolean)true, (boolean)this.foo.exists());
        FilesTest.assertEquals((boolean)true, (boolean)this.foo.isDirectory());
        FilesTest.assertEquals((boolean)true, (boolean)this.fileUtil.isEmpty(this.foo));
        File bar = new File(this.foo, "bar");
        FilesTest.assertEquals((boolean)false, (boolean)bar.exists());
        FilesTest.assertEquals((boolean)true, (boolean)this.fileUtil.isEmpty(bar));
        this.writeToFile(bar, "stuff");
        FilesTest.assertEquals((boolean)true, (boolean)bar.exists());
        FilesTest.assertEquals((boolean)false, (boolean)this.fileUtil.isEmpty(bar));
        FilesTest.assertEquals((boolean)false, (boolean)this.fileUtil.isEmpty(this.foo));
        FilesTest.assertEquals((boolean)true, (boolean)bar.delete());
        FilesTest.assertEquals((boolean)true, (boolean)this.fileUtil.isEmpty(this.foo));
    }
}

