/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.SQLRuntimeException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryUtil {
    private final Connection conn;
    private PrintStream err;

    public QueryUtil(Connection conn) {
        this(conn, System.err);
    }

    public QueryUtil(Connection conn, PrintStream err) {
        this.conn = conn;
        this.err = err;
    }

    public List executeQuery(String query, Object[] params) {
        PreparedStatement pStmt = null;
        ResultSet rs = null;
        try {
            pStmt = this.prepareStatement(query, params);
            rs = pStmt.executeQuery();
            List list = this.mapRows(rs);
            return list;
        }
        catch (SQLException sqlEx) {
            throw new SQLRuntimeException(sqlEx, query, params);
        }
        finally {
            this.cleanupRsAndStmt(pStmt, rs, query, null);
        }
    }

    private List mapRows(ResultSet rs) throws SQLException {
        int columns = rs.getMetaData().getColumnCount();
        ArrayList rows = new ArrayList();
        while (rs.next()) {
            LinkedHashMap<String, Object> rowVals = new LinkedHashMap<String, Object>(columns);
            for (int i = 1; i <= columns; ++i) {
                String columnName = rs.getMetaData().getColumnName(i);
                Object columValue = rs.getObject(i);
                rowVals.put(columnName, columValue);
            }
            rows.add(rowVals);
        }
        return rows;
    }

    public List executeQuery(String query) {
        return this.executeQuery(query, null);
    }

    public int executeUpdate(String query, Object[] params) {
        PreparedStatement pStmt = null;
        try {
            pStmt = this.prepareStatement(query, params);
            int n = pStmt.executeUpdate();
            return n;
        }
        catch (SQLException sqlEx) {
            throw new SQLRuntimeException(sqlEx, query, params);
        }
        finally {
            this.cleanupRsAndStmt(pStmt, null, query, params);
        }
    }

    public boolean execute(String query, Object[] params) {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.prepareStatement(query, params);
            boolean bl = pstmt.execute();
            return bl;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e, query, params);
        }
        finally {
            this.cleanupRsAndStmt(pstmt, null, query, null);
        }
    }

    public int[] executeBatch(String query, Object[][] params) {
        PreparedStatement pStmt = null;
        ResultSet resultSet = null;
        try {
            pStmt = this.prepareStatement(query, false);
            for (int i = 0; i < params.length; ++i) {
                this.setParameters(query, params[i], pStmt);
                pStmt.addBatch();
            }
            int[] i = pStmt.executeBatch();
            return i;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e, query, (Object[])params);
        }
        finally {
            this.cleanupRsAndStmt(pStmt, resultSet, query, (Object[])params);
        }
    }

    public int executeUpdate(String query) {
        return this.executeUpdate(query, null);
    }

    public boolean execute(String query) {
        return this.execute(query, null);
    }

    public List executeUpdateReturningKeys(String query) {
        return this.executeUpdateReturningKeys(query, null);
    }

    public List executeUpdateReturningKeys(String query, Object[] params) {
        PreparedStatement pStmt = null;
        ResultSet resultSet = null;
        try {
            pStmt = this.prepareStatement(query, params, true);
            pStmt.executeUpdate();
            resultSet = pStmt.getGeneratedKeys();
            List list = this.mapRows(resultSet);
            this.cleanupRsAndStmt(pStmt, resultSet, query, params);
            return list;
        }
        catch (SQLException e) {
            try {
                throw new SQLRuntimeException(e, query, params);
            }
            catch (Throwable throwable) {
                this.cleanupRsAndStmt(pStmt, resultSet, query, params);
                throw throwable;
            }
        }
    }

    private PreparedStatement prepareStatement(String query, Object[] params) throws SQLException {
        return this.prepareStatement(query, params, false);
    }

    private PreparedStatement prepareStatement(String query, Object[] params, boolean returnKeys) throws SQLException {
        PreparedStatement pStmt = this.prepareStatement(query, returnKeys);
        this.setParameters(query, params, pStmt);
        return pStmt;
    }

    private void setParameters(String query, Object[] params, PreparedStatement pStmt) throws SQLException {
        int paramCount;
        int numParams = pStmt.getParameterMetaData().getParameterCount();
        int n = paramCount = params == null ? 0 : params.length;
        if (numParams != paramCount) {
            String msg = "Expected " + numParams + " parameters, got " + paramCount;
            throw new SQLRuntimeException(msg, query, params);
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                pStmt.setObject(i + 1, param);
            }
        }
    }

    private PreparedStatement prepareStatement(String query, boolean returnKeys) throws SQLException {
        if (query == null) {
            throw new IllegalArgumentException("query string may not be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("query string may not be empty");
        }
        if (returnKeys) {
            return this.conn.prepareStatement(query, 1);
        }
        return this.conn.prepareStatement(query);
    }

    private void cleanupRsAndStmt(Statement stmt, ResultSet rs, String origSql, Object[] params) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable t) {
                new SQLRuntimeException(t, origSql, params).printStackTrace(this.err);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                new SQLRuntimeException(t, origSql, params).printStackTrace(this.err);
            }
        }
    }

    public String queryForString(String query) {
        return this.queryForString(query, null);
    }

    public String queryForString(String query, Object[] params) {
        List restults = this.executeQuery(query, params);
        for (Map row : restults) {
            Iterator it2 = row.entrySet().iterator();
            if (!it2.hasNext()) continue;
            Map.Entry column = it2.next();
            if (column.getValue() == null) {
                return null;
            }
            return column.getValue().toString();
        }
        return null;
    }
}

