/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.mvn;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import name.abuchen.mvn.PropertyReplacer;
import org.apache.commons.codec.binary.Hex;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

@Mojo(name="fix-info-plist", defaultPhase=LifecyclePhase.PACKAGE)
public class FixInfoPlistMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${qualifiedVersion}", required=true)
    private String projectVersion;
    @Parameter(required=true)
    private String productId;
    @Parameter(required=true)
    private String appName;
    @Parameter(required=true)
    private Properties properties;

    public void execute() throws MojoExecutionException {
        String[] architectures;
        for (String arch : architectures = new String[]{"x86_64", "aarch64"}) {
            Path infoPlist = Paths.get(this.outputDirectory.getAbsolutePath(), "products", this.productId, "macosx", "cocoa", arch, this.appName, "Contents", "Info.plist");
            if (!Files.exists(infoPlist, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Cannot find Info.plist: " + infoPlist.toString()));
                continue;
            }
            this.getLog().info((CharSequence)("Fixing " + infoPlist.toString()));
            this.fixInfoPlist(infoPlist);
            this.fixZippedBinaryArchiveInRepository(infoPlist, arch);
        }
    }

    private void fixInfoPlist(Path infoPlist) throws MojoExecutionException {
        try {
            NSDictionary dictionary = (NSDictionary)PropertyListParser.parse((File)infoPlist.toFile());
            new PropertyReplacer().replace(this.getLog(), dictionary, this.properties);
            PropertyListParser.saveAsXML((NSObject)dictionary, (File)infoPlist.toFile());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading/writing Info.plist", e);
        }
    }

    private void fixZippedBinaryArchiveInRepository(Path infoPlist, String arch) throws MojoExecutionException {
        Path archive = Paths.get(this.outputDirectory.getAbsolutePath(), "repository", "binary", this.productId + ".executable.cocoa.macosx." + arch + "_" + this.projectVersion);
        if (!Files.exists(archive, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Skipping archive manipulation; file not found: " + archive.toString()));
            return;
        }
        try {
            String oldMD5Hash = this.getChecksum(archive, "MD5");
            String oldSHA256Hash = this.getChecksum(archive, "SHA-256");
            String oldSHA512Hash = this.getChecksum(archive, "SHA-512");
            URI uri = URI.create("jar:" + archive.toUri());
            try (FileSystem fs = FileSystems.newFileSystem(uri, new HashMap());){
                Path fileToUpdate = fs.getPath("Info.plist", new String[0]);
                Files.copy(infoPlist, fileToUpdate, StandardCopyOption.REPLACE_EXISTING);
            }
            String newMD5Hash = this.getChecksum(archive, "MD5");
            String newSHA256Hash = this.getChecksum(archive, "SHA-256");
            String newSHA512Hash = this.getChecksum(archive, "SHA-512");
            this.getLog().info((CharSequence)MessageFormat.format("Updating binary MD5 hash from {0} to {1}", oldMD5Hash, newMD5Hash));
            this.getLog().info((CharSequence)MessageFormat.format("Updating binary SHA256 hash from {0} to {1}", oldSHA256Hash, newSHA256Hash));
            this.getLog().info((CharSequence)MessageFormat.format("Updating binary SHA512 hash from {0} to {1}", oldSHA512Hash, newSHA512Hash));
            Path artifactsJAR = Paths.get(this.outputDirectory.getAbsolutePath(), "repository", "artifacts.jar");
            String artifactsXML = this.readArtifactsXML(artifactsJAR);
            String messageFormat = "<property name=''download.md5'' value=''{0}''/>";
            artifactsXML = artifactsXML.replace(MessageFormat.format(messageFormat, oldMD5Hash), MessageFormat.format(messageFormat, newMD5Hash));
            messageFormat = "<property name=''download.checksum.md5'' value=''{0}''/>";
            artifactsXML = artifactsXML.replace(MessageFormat.format(messageFormat, oldMD5Hash), MessageFormat.format(messageFormat, newMD5Hash));
            messageFormat = "<property name=''download.checksum.sha-256'' value=''{0}''/>";
            artifactsXML = artifactsXML.replace(MessageFormat.format(messageFormat, oldSHA256Hash), MessageFormat.format(messageFormat, newSHA256Hash));
            messageFormat = "<property name=''download.checksum.sha-512'' value=''{0}''/>";
            artifactsXML = artifactsXML.replace(MessageFormat.format(messageFormat, oldSHA512Hash), MessageFormat.format(messageFormat, newSHA512Hash));
            this.updateArtifactsJAR(artifactsJAR, artifactsXML);
            this.updateArtifactsXZ(artifactsXML);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new MojoExecutionException("Failed to update binary archive", e);
        }
    }

    private void updateArtifactsJAR(Path artifactsJAR, String artifactsXML) throws IOException {
        Path tempFile = Paths.get(this.outputDirectory.getAbsolutePath(), "artifacts_md5_updated.xml");
        Files.write(tempFile, artifactsXML.getBytes(StandardCharsets.UTF_8.name()), new OpenOption[0]);
        URI uri = URI.create("jar:" + artifactsJAR.toUri());
        try (FileSystem fs = FileSystems.newFileSystem(uri, new HashMap());){
            Path fileToUpdate = fs.getPath("artifacts.xml", new String[0]);
            Files.copy(tempFile, fileToUpdate, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void updateArtifactsXZ(String artifactsXML) throws IOException {
        Path xzFile = Paths.get(this.outputDirectory.getAbsolutePath(), "repository", "artifacts.xml.xz");
        try (FileOutputStream outfile = new FileOutputStream(xzFile.toFile());){
            LZMA2Options options = new LZMA2Options();
            options.setDictSize(0x800000);
            options.setLcLp(3, 0);
            options.setPb(4);
            options.setMode(2);
            options.setNiceLen(273);
            options.setMatchFinder(20);
            options.setDepthLimit(512);
            try (XZOutputStream outxz = new XZOutputStream((OutputStream)outfile, (FilterOptions)options);){
                outxz.write(artifactsXML.getBytes(StandardCharsets.UTF_8.name()));
            }
        }
    }

    private String readArtifactsXML(Path artifactsJAR) throws IOException {
        URI uri = URI.create("jar:" + artifactsJAR.toUri());
        try (FileSystem fs = FileSystems.newFileSystem(uri, new HashMap());){
            Path fileToUpdate = fs.getPath("artifacts.xml", new String[0]);
            Scanner scanner = new Scanner(fileToUpdate, StandardCharsets.UTF_8.name());
            try {
                String string = scanner.useDelimiter("\\A").next();
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private String getChecksum(Path file, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(Files.readAllBytes(file));
        byte[] digest = md.digest();
        return Hex.encodeHexString((byte[])digest).toLowerCase(Locale.US);
    }
}

