/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.command;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.subethamail.smtp.internal.server.BaseCommand;
import org.subethamail.smtp.server.Session;

public final class StartTLSCommand
extends BaseCommand {
    private static final Logger log = Logger.getLogger(StartTLSCommand.class.getName());

    public StartTLSCommand() {
        super("STARTTLS", "The starttls command");
    }

    @Override
    public void execute(String commandString, Session sess) throws IOException {
        if (!commandString.trim().toUpperCase(Locale.ENGLISH).equals(this.getName())) {
            sess.sendResponse("501 Syntax error (no parameters allowed)");
            return;
        }
        if (!sess.getServer().getEnableTLS()) {
            sess.sendResponse("454 TLS not supported");
            return;
        }
        try {
            Socket socket = sess.getSocket();
            if (socket instanceof SSLSocket) {
                sess.sendResponse("454 TLS not available due to temporary reason: TLS already active");
                return;
            }
            sess.sendResponse("220 Ready to start TLS");
            SSLSocket s = sess.getServer().createSSLSocket(socket);
            s.startHandshake();
            log.log(Level.FINE, "Cipher suite: " + s.getSession().getCipherSuite());
            sess.setSocket(s);
            sess.resetSmtpProtocol();
            sess.setTlsStarted(true);
            if (s.getNeedClientAuth()) {
                try {
                    Certificate[] peerCertificates = s.getSession().getPeerCertificates();
                    sess.setTlsPeerCertificates(peerCertificates);
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {}
            }
        }
        catch (SSLHandshakeException ex) {
            log.log(Level.WARNING, "startTLS() failed: " + ex);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "startTLS() failed: " + ex.getMessage(), ex);
        }
    }
}

