/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.subethamail.smtp.internal.proxy.ProxyHandler;
import org.subethamail.smtp.internal.util.ArrayUtils;
import org.subethamail.smtp.internal.util.HexUtils;
import org.subethamail.smtp.server.Session;

public class ProxyProtocolV1Handler
implements ProxyHandler {
    private static final Logger log = Logger.getLogger(ProxyProtocolV1Handler.class.getName());
    public static final ProxyProtocolV1Handler INSTANCE = new ProxyProtocolV1Handler();
    public static final int MAX_PROXY_HEADER_LENGTH = 107;
    private static final byte[] PREFIX = "PROXY ".getBytes(StandardCharsets.US_ASCII);
    private static final Pattern PATTERN = Pattern.compile("PROXY (?<family>UNKNOWN|TCP4|TCP6)( (?<asrc>[0-9a-fA-F.:]+) (?<adst>[0-9a-fA-F.:]+) (?<psrc>[0-9]{1,5}) (?<pdst>[0-9]{1,5}))?\r\n");
    private static final int STATE_READING = 0;
    private static final int STATE_READ_TERMINATING = 1;
    private static final int STATE_READ_END = 2;
    private static final int STATE_READ_ERROR = 3;

    private ProxyProtocolV1Handler() {
    }

    static int prefixSize() {
        return PREFIX.length;
    }

    boolean isValidPrefix(byte[] prefix) {
        return prefix.length >= PREFIX.length && ArrayUtils.equals(PREFIX, 0, PREFIX.length, prefix, 0, PREFIX.length);
    }

    @Override
    public ProxyHandler.ProxyResult handle(InputStream in, OutputStream out, Session session) throws IOException {
        InetSocketAddress clientAddress;
        String family;
        log.log(Level.FINE, "(session {0}) Starting PROXY protocol v1 handling", session.getSessionId());
        byte[] header = new byte[107];
        int len = in.read(header, 0, PREFIX.length);
        if (len != PREFIX.length) {
            String headerHex = HexUtils.toHex(header, 0, len);
            log.log(Level.SEVERE, "(session {0}) Failed to fully read PROXY v1 header prefix. Read {1}", new Object[]{session.getSessionId(), headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        if (!ArrayUtils.equals(PREFIX, 0, PREFIX.length, header, 0, PREFIX.length)) {
            String receivedHeader = HexUtils.toHex(header, 0, len);
            log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v1 header prefix {1}", new Object[]{session.getSessionId(), receivedHeader});
            return ProxyHandler.ProxyResult.FAIL;
        }
        int state = 0;
        block18: while (state < 2 && len < 107) {
            int read = in.read();
            if (read < 0) {
                String headerHex = HexUtils.toHex(header, 0, len);
                log.log(Level.SEVERE, "(session {0}) Failed to fully read PROXY v1 header. Read {1}", new Object[]{session.getSessionId(), headerHex});
                return ProxyHandler.ProxyResult.FAIL;
            }
            byte result = (byte)read;
            header[len++] = result;
            switch (state) {
                case 0: {
                    if (read != 13) continue block18;
                    state = 1;
                    continue block18;
                }
                case 1: {
                    if (read == 10) {
                        state = 2;
                        continue block18;
                    }
                    state = 3;
                    continue block18;
                }
            }
            state = 3;
        }
        String headerHex = HexUtils.toHex(header, 0, len);
        log.log(Level.FINE, "(session {0}) Read header {1}", new Object[]{session.getSessionId(), headerHex});
        if (state != 2) {
            log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v1 header {1}", new Object[]{session.getSessionId(), headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        Matcher matcher = PATTERN.matcher(new String(header, 0, len, StandardCharsets.US_ASCII));
        if (!matcher.matches()) {
            log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v1 header {1}", new Object[]{session.getSessionId(), headerHex});
            return ProxyHandler.ProxyResult.FAIL;
        }
        switch (family = matcher.group("family")) {
            case "UNKNOWN": {
                return ProxyHandler.ProxyResult.NOP;
            }
            case "TCP4": {
                InetAddress src;
                String asrc = matcher.group("asrc");
                if (asrc == null) {
                    log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v1 header {1}", new Object[]{session.getSessionId(), headerHex});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                try {
                    src = InetAddress.getByName(asrc);
                }
                catch (UnknownHostException ex) {
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v1 source IPv4 {1}", new Object[]{session.getSessionId(), asrc});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                if (!(src instanceof Inet4Address)) {
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v1 source IPv4 {1}", new Object[]{session.getSessionId(), asrc});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                int psrc = Integer.parseInt(matcher.group("psrc"));
                if (psrc < 1 || psrc > 65535) {
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v1 source IPv4 port {1}", new Object[]{session.getSessionId(), psrc});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                clientAddress = new InetSocketAddress(src, psrc);
                break;
            }
            case "TCP6": {
                InetAddress src;
                String asrc = matcher.group("asrc");
                if (asrc == null) {
                    log.log(Level.SEVERE, "(session {0}) Invalid PROXY protocol v1 header {1}", new Object[]{session.getSessionId(), headerHex});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                try {
                    src = InetAddress.getByName(asrc);
                }
                catch (UnknownHostException ex) {
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v1 source IPv6 {1}", new Object[]{session.getSessionId(), asrc});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                if (!(src instanceof Inet6Address)) {
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v1 source IPv6 {1}", new Object[]{session.getSessionId(), asrc});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                int psrc = Integer.parseInt(matcher.group("psrc"));
                if (psrc < 1 || psrc > 65535) {
                    log.log(Level.SEVERE, "(session {0}) wrong PROXY protocol v1 source IPv6 port {1}", new Object[]{session.getSessionId(), psrc});
                    return ProxyHandler.ProxyResult.FAIL;
                }
                clientAddress = new InetSocketAddress(src, psrc);
                break;
            }
            default: {
                log.log(Level.SEVERE, "(session {0}) Unknown PROXY protocol v1 address family {1}", new Object[]{session.getSessionId(), family});
                return ProxyHandler.ProxyResult.FAIL;
            }
        }
        log.log(Level.FINE, "(session {0}) Accepted PROXY connection: family {1} client {2} original {3}", new Object[]{session.getSessionId(), family, clientAddress.getHostString(), session.getRealRemoteAddress().getHostString()});
        return new ProxyHandler.ProxyResult(clientAddress);
    }

    public static enum Family {
        UNKNOWN,
        TCP4,
        TCP6;

    }
}

