/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.server;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.internal.server.Command;
import org.subethamail.smtp.internal.server.CommandException;
import org.subethamail.smtp.internal.server.CommandRegistry;
import org.subethamail.smtp.internal.server.HelpMessage;
import org.subethamail.smtp.internal.server.InvalidCommandNameException;
import org.subethamail.smtp.internal.server.UnknownCommandException;
import org.subethamail.smtp.server.Session;

public final class CommandHandler {
    private static final Logger log = Logger.getLogger(CommandHandler.class.getName());
    private final Map<String, Command> commandMap = new HashMap<String, Command>();

    public CommandHandler() {
        for (CommandRegistry registry : CommandRegistry.values()) {
            this.addCommand(registry.getCommand());
        }
    }

    public CommandHandler(Collection<Command> availableCommands) {
        for (Command command : availableCommands) {
            this.addCommand(command);
        }
    }

    public void addCommand(Command command) {
        log.log(Level.FINE, "Added command: {0}", command.getName());
        this.commandMap.put(command.getName(), command);
    }

    public Command getCommand(String commandName) {
        String upperCaseCommandName = commandName.toUpperCase(Locale.ENGLISH);
        return this.commandMap.get(upperCaseCommandName);
    }

    public boolean containsCommand(String command) {
        return this.commandMap.containsKey(command);
    }

    public Set<String> getVerbs() {
        return this.commandMap.keySet();
    }

    public void handleCommand(Session context, String commandString) throws SocketTimeoutException, IOException, DropConnectionException {
        try {
            Command command = this.getCommandFromString(commandString);
            command.execute(commandString, context);
        }
        catch (CommandException e) {
            context.sendResponse("500 " + e.getMessage());
        }
    }

    public HelpMessage getHelp(String command) throws CommandException {
        return this.getCommandFromString(command).getHelp();
    }

    private Command getCommandFromString(String commandString) throws UnknownCommandException, InvalidCommandNameException {
        Command command = null;
        String key = CommandHandler.toKey(commandString);
        command = this.commandMap.get(key);
        if (command == null) {
            String verb = CommandHandler.toVerb(commandString);
            command = this.commandMap.get(verb);
        }
        if (command == null) {
            throw new UnknownCommandException("Error: command not implemented");
        }
        return command;
    }

    private static String toKey(String string) throws InvalidCommandNameException {
        if (string == null || string.length() < 4) {
            throw new InvalidCommandNameException("Error: bad syntax");
        }
        return string.substring(0, 4).toUpperCase(Locale.ENGLISH);
    }

    private static String toVerb(String string) throws InvalidCommandNameException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new InvalidCommandNameException("Error: bad syntax");
        }
        return stringTokenizer.nextToken().toUpperCase(Locale.ENGLISH);
    }
}

