/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import org.subethamail.smtp.internal.proxy.ProxyHandler;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.Session;

public final class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger(ServerThread.class.getName());
    private final SMTPServer server;
    private final ServerSocket serverSocket;
    private final ProxyHandler proxyHandler;
    private final Semaphore connectionPermits;
    @GuardedBy(value="this")
    private final Set<Session> sessionThreads;
    private volatile boolean shuttingDown;

    public ServerThread(SMTPServer server, ServerSocket serverSocket, ProxyHandler proxyHandler) {
        super(server.getServerThreadName());
        this.server = server;
        this.serverSocket = serverSocket;
        this.proxyHandler = proxyHandler;
        int countOfConnectionPermits = server.getMaxConnections() + 10;
        this.connectionPermits = new Semaphore(countOfConnectionPermits);
        this.sessionThreads = new HashSet<Session>(countOfConnectionPermits * 4 / 3 + 1);
    }

    @Override
    public void run() {
        log.log(Level.INFO, "SMTP server {0} started", this.server.getDisplayableLocalSocketAddress());
        try {
            this.runAcceptLoop();
            log.log(Level.INFO, "SMTP server {0} stopped accepting connections", this.server.getDisplayableLocalSocketAddress());
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "Unexpected exception in server socket thread, server is stopped", e);
            throw e;
        }
        catch (Error e) {
            log.log(Level.SEVERE, "Unexpected error in server socket thread, server is stopped", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAcceptLoop() {
        while (!this.shuttingDown) {
            try {
                this.connectionPermits.acquire();
            }
            catch (InterruptedException consumed) {
                continue;
            }
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException e) {
                this.connectionPermits.release();
                if (this.shuttingDown) continue;
                log.log(Level.SEVERE, "Error accepting connection", e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Session session = null;
            try {
                session = new Session(this.server, this, socket, this.proxyHandler);
            }
            catch (IOException e) {
                this.connectionPermits.release();
                log.log(Level.SEVERE, "Error while starting a connection", e);
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    log.log(Level.FINE, "Cannot close socket after exception", e1);
                }
                continue;
            }
            ServerThread e = this;
            synchronized (e) {
                this.sessionThreads.add(session);
            }
            try {
                this.server.getExecutorService().execute(session);
            }
            catch (RejectedExecutionException e2) {
                this.connectionPermits.release();
                ServerThread e1 = this;
                synchronized (e1) {
                    this.sessionThreads.remove(session);
                }
                log.log(Level.SEVERE, "Error while executing a session", e2);
                try {
                    socket.close();
                }
                catch (IOException e3) {
                    log.log(Level.FINE, "Cannot close socket after exception", e3);
                }
            }
        }
    }

    public void shutdown() {
        this.shutdownServerThread();
        this.shutdownSessions();
    }

    private void shutdownServerThread() {
        this.shuttingDown = true;
        this.closeServerSocket();
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void closeServerSocket() {
        try {
            this.serverSocket.close();
            log.log(Level.FINE, "SMTP Server socket shut down");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to close server socket.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownSessions() {
        ArrayList<Session> sessionsToBeClosed;
        ServerThread serverThread = this;
        synchronized (serverThread) {
            sessionsToBeClosed = new ArrayList<Session>(this.sessionThreads);
        }
        for (Session sessionThread : sessionsToBeClosed) {
            sessionThread.quit();
        }
        this.server.getExecutorService().shutdown();
        try {
            this.server.getExecutorService().awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            log.log(Level.WARNING, "Interrupted waiting for termination of session threads", e);
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean hasTooManyConnections() {
        return this.sessionThreads.size() > this.server.getMaxConnections();
    }

    public synchronized int getNumberOfConnections() {
        return this.sessionThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(Session session) {
        ServerThread serverThread = this;
        synchronized (serverThread) {
            this.sessionThreads.remove(session);
        }
        this.connectionPermits.release();
    }
}

