/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.util;

import com.github.davidmoten.guavamini.Preconditions;

public final class SMTPResponseHelper {
    private SMTPResponseHelper() {
    }

    public static String buildResponse(String code, CharSequence response) {
        Preconditions.checkArgument(code.length() == 3, "Invalid SMTP response code " + code);
        int len = response.length();
        int evaluatedLen = (len / 506 + 1) * 512;
        StringBuilder result = new StringBuilder(evaluatedLen);
        int lineLen = 4;
        boolean flushLine = false;
        int lastch = -1;
        char[] line = new char[512];
        line[0] = code.charAt(0);
        line[1] = code.charAt(1);
        line[2] = code.charAt(2);
        line[3] = 45;
        for (int i = 0; i < len; ++i) {
            char ch = response.charAt(i);
            switch (ch) {
                case '\r': {
                    if (lastch == 10) break;
                    flushLine = true;
                    break;
                }
                case '\n': {
                    if (lastch == 13) break;
                    flushLine = true;
                    break;
                }
                default: {
                    line[lineLen++] = ch;
                }
            }
            lastch = ch;
            if (lineLen != 510 && !flushLine && i != len - 1) continue;
            flushLine = false;
            if (i != len - 1) {
                line[lineLen++] = 13;
                line[lineLen++] = 10;
            } else {
                line[3] = 32;
            }
            result.append(line, 0, lineLen);
            lineLen = 4;
        }
        return result.toString();
    }

    public static String buildResponse(int code, CharSequence response) {
        Preconditions.checkArgument(code > 99 && code < 1000, "Invalid SMTP response code " + code);
        return SMTPResponseHelper.buildResponse(Integer.toString(code), response);
    }
}

