/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.packager.io.IOConsumer;
import org.eclipse.packager.io.IOFunction;
import org.eclipse.packager.io.SpoolOutTarget;
import org.eclipse.packager.utils.Strings;

public class OutputSpooler {
    private final Set<String> digests = new HashSet<String>();
    private final SpoolOutTarget target;
    private final Map<String, OutputEntry> outputs = new HashMap<String, OutputEntry>();
    private final Map<String, String> checksums = new HashMap<String, String>();
    private final Map<String, Long> sizes = new HashMap<String, Long>();

    public OutputSpooler(SpoolOutTarget target) {
        this.target = target;
    }

    public void addDigest(String algorithm) {
        this.digests.add(algorithm);
    }

    public void addOutput(String fileName, String mimeType) {
        this.addOutput(fileName, mimeType, null);
    }

    public void addOutput(String fileName, String mimeType, IOFunction<OutputStream, OutputStream> transformer) {
        if (transformer == null) {
            this.outputs.put(fileName, new OutputEntry(mimeType, output -> output));
        } else {
            this.outputs.put(fileName, new OutputEntry(mimeType, transformer));
        }
    }

    public void open(IOConsumer<OutputStream> consumer) throws IOException {
        LinkedList<OutputStream> streams = new LinkedList<OutputStream>();
        Iterator<Map.Entry<String, OutputEntry>> entries = this.outputs.entrySet().iterator();
        this.openNext(streams, entries, stream -> {
            try (MultiplexStream multiplexStream = new MultiplexStream(streams);){
                consumer.accept(multiplexStream);
            }
        });
    }

    protected void openNext(List<OutputStream> streams, Iterator<Map.Entry<String, OutputEntry>> entries, IOConsumer<List<OutputStream>> streamsConsumer) throws IOException {
        if (!entries.hasNext()) {
            streamsConsumer.accept(streams);
        } else {
            Map.Entry<String, OutputEntry> entry = entries.next();
            this.target.spoolOut(entry.getKey(), entry.getValue().getMimeType(), stream -> {
                for (String algo : this.digests) {
                    String key = (String)entry.getKey() + ":" + algo;
                    try {
                        stream = new RecordingDigestOutputStream((OutputStream)stream, MessageDigest.getInstance(algo), key);
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IOException(e);
                    }
                }
                stream = new CountingOutputStream((String)entry.getKey(), (OutputStream)stream);
                stream = ((OutputEntry)entry.getValue()).getTransformer().apply((OutputStream)stream);
                streams.add((OutputStream)stream);
                this.openNext(streams, entries, streamsConsumer);
            });
        }
    }

    private void setResult(String key, byte[] result) {
        this.checksums.put(key, Strings.hex(result).toLowerCase());
    }

    private void setResultSize(String key, long length) {
        this.sizes.put(key, length);
    }

    static void closeAll(Stream<OutputStream> stream) throws IOException {
        LinkedList ex = new LinkedList();
        stream.forEach(s -> {
            try {
                s.close();
            }
            catch (IOException e) {
                ex.add(e);
            }
        });
        if (!ex.isEmpty()) {
            IOException base = new IOException();
            for (Exception e : ex) {
                base.addSuppressed(e);
            }
            throw base;
        }
    }

    public String getChecksum(String fileName, String algorithm) {
        if (!this.digests.contains(algorithm)) {
            return null;
        }
        String result = this.checksums.get(fileName + ":" + algorithm);
        if (result == null) {
            throw new IllegalStateException(String.format("Stream '%s' not closed.", fileName));
        }
        return result;
    }

    public long getSize(String fileName) {
        Long result = this.sizes.get(fileName);
        if (result == null) {
            throw new IllegalStateException(String.format("Stream '%s' not closed or was not added", fileName));
        }
        return result;
    }

    private static class OutputEntry {
        private final String mimeType;
        private final IOFunction<OutputStream, OutputStream> transformer;

        public OutputEntry(String mimeType, IOFunction<OutputStream, OutputStream> transformer) {
            this.mimeType = mimeType;
            this.transformer = transformer;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public IOFunction<OutputStream, OutputStream> getTransformer() {
            return this.transformer;
        }
    }

    private class MultiplexStream
    extends OutputStream {
        private final OutputStream[] streams;

        public MultiplexStream(List<OutputStream> streams) {
            this.streams = streams.toArray(new OutputStream[streams.size()]);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.forEach(stream -> stream.write(b, off, len));
        }

        @Override
        public void flush() throws IOException {
            this.forEach(OutputStream::flush);
        }

        @Override
        public void close() throws IOException {
            Stream<OutputStream> s = Arrays.stream(this.streams);
            OutputSpooler.closeAll(s);
        }

        protected void forEach(IOConsumer<OutputStream> consumer) throws IOException {
            for (OutputStream stream : this.streams) {
                consumer.accept(stream);
            }
        }
    }

    public class CountingOutputStream
    extends FilterOutputStream {
        private final String key;
        private long count;

        public CountingOutputStream(String key, OutputStream out) {
            super(out);
            this.key = key;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.count;
        }

        @Override
        public void close() throws IOException {
            super.close();
            OutputSpooler.this.setResultSize(this.key, this.count);
        }
    }

    public class RecordingDigestOutputStream
    extends DigestOutputStream {
        private final String key;

        public RecordingDigestOutputStream(OutputStream stream, MessageDigest digest, String key) {
            super(stream, digest);
            this.key = key;
        }

        @Override
        public void close() throws IOException {
            super.close();
            MessageDigest digest = this.getMessageDigest();
            byte[] result = digest.digest();
            OutputSpooler.this.setResult(this.key, result);
        }
    }
}

