/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow.rc;

import com.sonatype.nexus.staging.client.Profile;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.sonatype.nexus.maven.staging.workflow.AbstractStagingActionMojo;

@Mojo(name="rc-list-profiles", requiresProject=false, requiresDirectInvocation=true, requiresOnline=true)
public class RcListProfilesMojo
extends AbstractStagingActionMojo {
    private static final String FORMAT_MASK = "%-15s %-6s %-30s";

    @Override
    public void doExecute(StagingWorkflowV2Service stagingWorkflow) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Getting list of available staging profiles...");
        List<Profile> stagingProfiles = stagingWorkflow.listProfiles();
        Collections.sort(stagingProfiles, new ProfileComparator());
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)String.format(FORMAT_MASK, "ID", "Mode", "Name"));
        for (Profile stagingProfile : stagingProfiles) {
            String line = String.format(FORMAT_MASK, new Object[]{stagingProfile.id(), stagingProfile.mode(), stagingProfile.name()});
            this.getLog().info((CharSequence)line);
        }
    }

    public static class ProfileComparator
    implements Comparator<Profile> {
        @Override
        public int compare(Profile o1, Profile o2) {
            return o1.name().compareTo(o2.name());
        }
    }
}

