/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.deploy.strategy;

import com.sonatype.nexus.staging.client.Profile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.nexus.maven.staging.deploy.StagingRepository;
import org.sonatype.nexus.maven.staging.deploy.strategy.AbstractStagingDeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployPerModuleRequest;
import org.sonatype.nexus.maven.staging.deploy.strategy.DeployStrategy;
import org.sonatype.nexus.maven.staging.deploy.strategy.FinalizeDeployRequest;
import org.sonatype.nexus.maven.staging.remote.RemoteNexus;
import org.sonatype.nexus.maven.staging.zapper.Zapper;
import org.sonatype.nexus.maven.staging.zapper.ZapperRequest;

@Component(role=DeployStrategy.class, hint="image")
public class ImageDeployStrategy
extends AbstractStagingDeployStrategy {
    @Requirement
    private Zapper zapper;

    @Override
    public void deployPerModule(DeployPerModuleRequest request) throws ArtifactInstallationException, ArtifactDeploymentException, MojoExecutionException {
    }

    @Override
    public void finalizeDeploy(FinalizeDeployRequest request) throws ArtifactDeploymentException, MojoExecutionException {
        this.getLogger().info("Staging remotely locally deployed repository...");
        RemoteNexus remoteNexus = this.createRemoteNexus(request.getMavenSession(), request.getParameters());
        String profileId = request.getParameters().getStagingProfileId();
        Profile stagingProfile = remoteNexus.getStagingWorkflowV2Service().selectProfile(profileId);
        StagingRepository stagingRepository = this.beforeUpload(request.getParameters(), remoteNexus, stagingProfile);
        try {
            this.getLogger().info(" * Uploading locally staged artifacts to profile " + stagingProfile.name());
            this.zapUp(remoteNexus.getServer(), remoteNexus.getProxy(), request.getParameters().getStagingDirectoryRoot(), stagingRepository.getUrl());
            this.getLogger().info(" * Upload of locally staged artifacts finished.");
            this.afterUpload(request.getParameters(), remoteNexus, stagingRepository);
        }
        catch (Exception e) {
            this.afterUploadFailure(request.getParameters(), remoteNexus, Collections.singletonList(stagingRepository), e);
            this.getLogger().error("Remote staging finished with a failure.");
            throw new ArtifactDeploymentException("Remote staging failed: " + e.getMessage(), (Throwable)e);
        }
        this.getLogger().info("Remote staging finished with success.");
    }

    protected void zapUp(Server server, Proxy proxy, File sourceDirectory, String deployUrl) throws IOException {
        ZapperRequest request = new ZapperRequest(sourceDirectory, deployUrl);
        if (server != null) {
            request.setRemoteUsername(server.getUsername());
            request.setRemotePassword(server.getPassword());
        }
        if (proxy != null) {
            request.setProxyProtocol(proxy.getProtocol());
            request.setProxyHost(proxy.getHost());
            request.setProxyPort(proxy.getPort());
            request.setProxyUsername(proxy.getUsername());
            request.setProxyPassword(proxy.getPassword());
        }
        this.zapper.deployDirectory(request);
    }
}

