/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow.rc;

import com.google.common.base.Strings;
import com.sonatype.nexus.staging.client.StagingRepository;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.sonatype.nexus.maven.staging.workflow.AbstractStagingActionMojo;

@Mojo(name="rc-list", requiresProject=false, requiresDirectInvocation=true, requiresOnline=true)
public class RcListRepositoriesMojo
extends AbstractStagingActionMojo {
    private static final String FORMAT_MASK = "%-20s %-8s %-30s";
    @Parameter(property="showReleased", defaultValue="false")
    private boolean showReleased;

    @Override
    public void doExecute(StagingWorkflowV2Service stagingWorkflow) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Getting list of available staging repositories...");
        List<StagingRepository> stagingRepositories = stagingWorkflow.listStagingRepositories();
        Collections.sort(stagingRepositories, new RepositoryComparator());
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)String.format(FORMAT_MASK, "ID", "State", "Description"));
        for (StagingRepository stagingRepository : stagingRepositories) {
            if (StagingRepository.State.RELEASED == stagingRepository.getState() && !this.showReleased) continue;
            String line = String.format(FORMAT_MASK, new Object[]{stagingRepository.getId(), stagingRepository.getState(), this.clean(stagingRepository.getDescription())});
            this.getLog().info((CharSequence)line);
        }
    }

    private String clean(String str) {
        return Strings.nullToEmpty((String)str).replaceAll("\\n", " ");
    }

    public static class RepositoryComparator
    implements Comparator<StagingRepository> {
        @Override
        public int compare(StagingRepository o1, StagingRepository o2) {
            if (o1.getState() != o2.getState()) {
                return o1.getState().compareTo(o2.getState());
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

