/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.schedules;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.AbstractReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.sonatype.nexus.rest.model.ScheduledServiceAdvancedResource;
import org.sonatype.nexus.rest.model.ScheduledServiceBaseResource;
import org.sonatype.nexus.rest.model.ScheduledServiceDailyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceHourlyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceMonthlyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceOnceResource;
import org.sonatype.nexus.rest.model.ScheduledServiceWeeklyResource;
import org.sonatype.plexus.rest.xstream.LookAheadStreamReader;

public class ScheduledServiceBaseResourceConverter
extends AbstractReflectionConverter {
    public static final String SCHEDULE_TYPE_MANUAL = "manual";
    public static final String SCHEDULE_TYPE_RUN_NOW = "internal";
    public static final String SCHEDULE_TYPE_ONCE = "once";
    public static final String SCHEDULE_TYPE_HOURLY = "hourly";
    public static final String SCHEDULE_TYPE_DAILY = "daily";
    public static final String SCHEDULE_TYPE_WEEKLY = "weekly";
    public static final String SCHEDULE_TYPE_MONTHLY = "monthly";
    public static final String SCHEDULE_TYPE_ADVANCED = "advanced";

    public ScheduledServiceBaseResourceConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return ScheduledServiceBaseResource.class.equals((Object)type);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (LookAheadStreamReader.class.isAssignableFrom(reader.getClass()) || LookAheadStreamReader.class.isAssignableFrom(reader.underlyingReader().getClass())) {
            String schedule = null;
            schedule = LookAheadStreamReader.class.isAssignableFrom(reader.getClass()) ? ((LookAheadStreamReader)reader).getFieldValue("schedule") : ((LookAheadStreamReader)reader.underlyingReader()).getFieldValue("schedule");
            if (schedule == null) {
                return super.instantiateNewInstance(reader, context);
            }
            if (SCHEDULE_TYPE_MANUAL.equals(schedule)) {
                return new ScheduledServiceBaseResource();
            }
            if (SCHEDULE_TYPE_ONCE.equals(schedule)) {
                return new ScheduledServiceOnceResource();
            }
            if (SCHEDULE_TYPE_HOURLY.equals(schedule)) {
                return new ScheduledServiceHourlyResource();
            }
            if (SCHEDULE_TYPE_DAILY.equals(schedule)) {
                return new ScheduledServiceDailyResource();
            }
            if (SCHEDULE_TYPE_WEEKLY.equals(schedule)) {
                return new ScheduledServiceWeeklyResource();
            }
            if (SCHEDULE_TYPE_MONTHLY.equals(schedule)) {
                return new ScheduledServiceMonthlyResource();
            }
            if (SCHEDULE_TYPE_ADVANCED.equals(schedule)) {
                return new ScheduledServiceAdvancedResource();
            }
            return new ScheduledServiceBaseResource();
        }
        return super.instantiateNewInstance(reader, context);
    }
}

