/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.client.hc4;

import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.client.hc4.Hc4Client;
import org.sonatype.spice.zapper.internal.Check;

public class Hc4ClientBuilder {
    private Parameters parameters;
    private String remoteUrl;
    private HttpHost proxyServer;
    private CredentialsProvider credentialsProvider;
    private boolean preemptiveAuth;

    public Hc4ClientBuilder(Parameters parameters, String remoteUrl) {
        this.parameters = Check.notNull(parameters, Parameters.class);
        this.remoteUrl = Check.notNull(remoteUrl, "Remote URL is null!");
        this.preemptiveAuth = false;
    }

    public Hc4ClientBuilder withProxy(HttpHost proxyServer) {
        this.proxyServer = proxyServer;
        return this;
    }

    public Hc4ClientBuilder withRealm(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public Hc4ClientBuilder withPreemptiveRealm(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.preemptiveAuth = true;
        return this;
    }

    public Hc4Client build() {
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(this.parameters.getMaximumTrackCount());
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).setUserAgent("Zapper/1.0-HC4");
        if (this.proxyServer != null) {
            httpClientBuilder.setProxy(this.proxyServer);
        }
        if (this.credentialsProvider != null) {
            httpClientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        return new Hc4Client(this.parameters, this.remoteUrl, httpClientBuilder.build(), this.preemptiveAuth ? this.credentialsProvider : null);
    }
}

