/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.util.ArrayList;
import java.util.List;
import org.sonatype.spice.zapper.ZFile;
import org.sonatype.spice.zapper.internal.Segment;
import org.sonatype.spice.zapper.internal.SegmentCreator;
import org.sonatype.spice.zapper.internal.Transfer;

public abstract class ZFileSegmentCreator
implements SegmentCreator {
    private final long maxSegmentSize;

    public ZFileSegmentCreator(long maxSegmentSize) {
        this.maxSegmentSize = maxSegmentSize;
    }

    public int createSegments(Transfer transfer) {
        List<ZFile> zfiles = transfer.getZfiles();
        ArrayList<Segment> segments = new ArrayList<Segment>(zfiles.size());
        for (ZFile zfile : zfiles) {
            if (zfile.getLength() < this.maxSegmentSize) {
                segments.add(this.createSegment(transfer, 0L, zfile.getLength(), zfile));
                continue;
            }
            long offset = 0L;
            long length = this.maxSegmentSize;
            while ((length = Math.min(length, zfile.getLength() - offset)) != 0L) {
                segments.add(this.createSegment(transfer, offset, length, zfile));
                offset += length;
            }
        }
        transfer.setSegments(segments);
        return segments.size();
    }

    protected Segment createSegment(Transfer transfer, long offset, long length, ZFile zfile) {
        return new Segment(offset, length, zfile, transfer.getNextSegmentIdentifier());
    }
}

