/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.hawtbuf;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.hawtbuf.proto.BaseMessage;
import org.sonatype.spice.zapper.internal.hawtbuf.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FileSegmentsBase<T>
extends BaseMessage<T> {
    private String f_fileId = null;
    private boolean b_fileId;
    private List<Segment> f_segments;

    FileSegmentsBase() {
    }

    public boolean hasFileId() {
        return this.b_fileId;
    }

    public String getFileId() {
        return this.f_fileId;
    }

    public T setFileId(String fileId) {
        this.loadAndClear();
        this.b_fileId = true;
        this.f_fileId = fileId;
        return (T)((Object)this);
    }

    public void clearFileId() {
        this.loadAndClear();
        this.b_fileId = false;
        this.f_fileId = null;
    }

    public boolean hasSegments() {
        return this.f_segments != null && !this.f_segments.isEmpty();
    }

    public List<Segment> getSegmentsList() {
        if (this.f_segments == null) {
            this.f_segments = new ArrayList<Segment>();
        }
        return this.f_segments;
    }

    public T setSegmentsList(List<Segment> segments) {
        this.loadAndClear();
        this.f_segments = segments;
        return (T)((Object)this);
    }

    public int getSegmentsCount() {
        if (this.f_segments == null) {
            return 0;
        }
        return this.f_segments.size();
    }

    public Segment getSegments(int index) {
        if (this.f_segments == null) {
            return null;
        }
        return this.f_segments.get(index);
    }

    public T setSegments(int index, Segment value) {
        this.loadAndClear();
        this.getSegmentsList().set(index, value);
        return (T)((Object)this);
    }

    public T addSegments(Segment value) {
        this.loadAndClear();
        this.getSegmentsList().add(value);
        return (T)((Object)this);
    }

    public T addAllSegments(Iterable<? extends Segment> collection) {
        this.loadAndClear();
        BaseMessage.addAll(collection, this.getSegmentsList());
        return (T)((Object)this);
    }

    public void clearSegments() {
        this.loadAndClear();
        this.f_segments = null;
    }
}

