/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.sisu.inject.MildConcurrentKeys;
import org.eclipse.sisu.inject.MildConcurrentValues;
import org.eclipse.sisu.inject.MildElements;
import org.eclipse.sisu.inject.MildKeys;
import org.eclipse.sisu.inject.MildValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Weak {
    private Weak() {
    }

    public static <T> Collection<T> elements() {
        return Weak.elements(10);
    }

    public static <T> Collection<T> elements(int capacity) {
        return new MildElements(new ArrayList(capacity), false);
    }

    public static <K, V> Map<K, V> keys() {
        return Weak.keys(16);
    }

    public static <K, V> Map<K, V> keys(int capacity) {
        return new MildKeys(new HashMap(capacity), false);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentKeys() {
        return Weak.concurrentKeys(16, 4);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentKeys(int capacity, int concurrency) {
        return new MildConcurrentKeys(new ConcurrentHashMap(capacity, 0.75f, concurrency), false);
    }

    public static <K, V> Map<K, V> values() {
        return Weak.values(16);
    }

    public static <K, V> Map<K, V> values(int capacity) {
        return new MildValues(new HashMap(capacity), false);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentValues() {
        return Weak.concurrentValues(16, 4);
    }

    public static <K, V> ConcurrentMap<K, V> concurrentValues(int capacity, int concurrency) {
        return new MildConcurrentValues(new ConcurrentHashMap(capacity, 0.75f, concurrency), false);
    }
}

