/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.Method;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.ClassMethodExistsCallQuery;
import org.anarres.jdiagnostics.ClassMethodExistsQuery;
import org.anarres.jdiagnostics.ClassQuery;
import org.anarres.jdiagnostics.JarQuery;
import org.anarres.jdiagnostics.MethodExistsCallQuery;
import org.anarres.jdiagnostics.Result;

public class SAXQuery
extends AbstractQuery {
    private static final String SAX_VERSION1_CLASS = "org.xml.sax.Parser";
    private static final String SAX_VERSION1_METHOD = "parse";
    private static final String SAX_VERSION2BETA_CLASS = "org.xml.sax.XMLReader";
    private static final String SAX_VERSION2BETA_METHOD = "parse";
    private static final String SAX_VERSION2_CLASS = "org.xml.sax.helpers.AttributesImpl";
    private static final String SAX_VERSION2_METHOD = "setAttributes";

    public String getName() {
        return "sax";
    }

    public void version(Result result, String prefix) {
        Method m2;
        new JarQuery("sax.jar").call(result, prefix + "saxJar/");
        Class<?> c2 = new ClassExistsQuery("org.xml.sax.Attributes").findClass(result, prefix + "v2arg/");
        if (c2 != null && (m2 = new ClassMethodExistsQuery(SAX_VERSION2_CLASS, SAX_VERSION2_METHOD, c2).findMethod(result, prefix + "v2/")) != null) {
            result.put(prefix + "version", ">=2.0");
            return;
        }
        Method m2b = new ClassMethodExistsQuery(SAX_VERSION2BETA_CLASS, "parse", String.class).findMethod(result, prefix + "v2beta/");
        if (m2b != null) {
            result.put(prefix + "saxversion", ">=2.0 beta");
            return;
        }
        Method m1 = new ClassMethodExistsQuery(SAX_VERSION1_CLASS, "parse", String.class).findMethod(result, prefix + "v1/");
        if (m1 != null) {
            result.put(prefix + "saxversion", ">=1.0");
            return;
        }
    }

    public void factory(Result result, String prefix) {
        Object factory = new ClassMethodExistsCallQuery(null, "javax.xml.parsers.SAXParserFactory", "newInstance").invoke(result, prefix);
        if (factory == null) {
            return;
        }
        Object instance = new MethodExistsCallQuery(factory, factory.getClass(), "newSAXParser").invoke(result, prefix + "instance/");
        if (instance == null) {
            return;
        }
        new ClassQuery(instance.getClass()).call(result, prefix + "type/");
    }

    public void call(Result result, String prefix) {
        this.version(result, prefix + "version/");
        this.factory(result, prefix + "factory/");
    }
}

