/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.coding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.eclipse.packager.rpm.coding.PayloadCodingProvider;
import org.eclipse.packager.rpm.deps.Dependency;
import org.eclipse.packager.rpm.deps.RpmDependencyFlags;

public class XZPayloadCoding
implements PayloadCodingProvider {
    protected XZPayloadCoding() {
    }

    @Override
    public String getCoding() {
        return "xz";
    }

    @Override
    public void fillRequirements(Consumer<Dependency> requirementsConsumer) {
        requirementsConsumer.accept(new Dependency("PayloadIsXz", "5.2-1", RpmDependencyFlags.LESS, RpmDependencyFlags.EQUAL, RpmDependencyFlags.RPMLIB));
    }

    @Override
    public InputStream createInputStream(InputStream in) throws IOException {
        return new XZCompressorInputStream(in);
    }

    @Override
    public OutputStream createOutputStream(OutputStream out, Optional<String> optionalFlags) throws IOException {
        String flags;
        int preset = optionalFlags.isPresent() && (flags = optionalFlags.get()).length() > 0 ? Integer.parseInt(flags.substring(0, 1)) : 6;
        return new XZCompressorOutputStream(out, preset);
    }
}

