/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.install;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.StringModelSource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.install.AbstractInstallMojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.project.install.ProjectInstaller;
import org.apache.maven.shared.transfer.project.install.ProjectInstallerRequest;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.ReaderFactory;
import org.apache.maven.shared.utils.WriterFactory;
import org.apache.maven.shared.utils.io.IOUtil;
import org.apache.maven.shared.utils.xml.XmlStreamWriter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="install-file", requiresProject=false, aggregator=true, threadSafe=true)
public class InstallFileMojo
extends AbstractInstallMojo {
    @Parameter(property="groupId")
    private String groupId;
    @Parameter(property="artifactId")
    private String artifactId;
    @Parameter(property="version")
    private String version;
    @Parameter(property="packaging")
    private String packaging;
    @Parameter(property="classifier")
    private String classifier;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="javadoc")
    private File javadoc;
    @Parameter(property="sources")
    private File sources;
    @Parameter(property="pomFile")
    private File pomFile;
    @Parameter(property="generatePom")
    private Boolean generatePom;
    @Parameter(property="localRepositoryPath")
    private File localRepositoryPath;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    private ProjectInstaller installer;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.file.exists()) {
            String message = "The specified file '" + this.file.getPath() + "' not exists";
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message);
        }
        ProjectBuildingRequest buildingRequest = this.session.getProjectBuildingRequest();
        if (this.localRepositoryPath != null) {
            buildingRequest = this.repositoryManager.setLocalRepositoryBasedir(buildingRequest, this.localRepositoryPath);
            this.getLog().debug((CharSequence)("localRepoPath: " + this.repositoryManager.getLocalRepositoryBasedir(buildingRequest)));
        }
        File temporaryPom = null;
        if (this.pomFile != null) {
            this.processModel(this.readModel(this.pomFile));
        } else {
            this.pomFile = temporaryPom = this.readingPomFromJarFile();
        }
        MavenProject project = this.createMavenProject();
        DefaultArtifactHandler ah = new DefaultArtifactHandler(this.packaging);
        ah.setExtension(FileUtils.getExtension((String)this.file.getName()));
        project.getArtifact().setArtifactHandler((ArtifactHandler)ah);
        Artifact artifact = project.getArtifact();
        if (this.file.equals(this.getLocalRepoFile(buildingRequest, artifact))) {
            throw new MojoFailureException("Cannot install artifact. Artifact is already in the local repository.\n\nFile in question is: " + this.file + "\n");
        }
        if (this.classifier == null) {
            artifact.setFile(this.file);
            if ("pom".equals(this.packaging)) {
                project.setFile(this.file);
            }
        } else {
            this.projectHelper.attachArtifact(project, this.packaging, this.classifier, this.file);
        }
        if (!"pom".equals(this.packaging)) {
            if (this.pomFile != null) {
                if (this.classifier == null) {
                    artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, this.pomFile));
                } else {
                    project.setFile(this.pomFile);
                }
            } else {
                temporaryPom = this.generatePomFile();
                ProjectArtifactMetadata pomMetadata = new ProjectArtifactMetadata(artifact, temporaryPom);
                if (Boolean.TRUE.equals(this.generatePom) || this.generatePom == null && !this.getLocalRepoFile(buildingRequest, pomMetadata).exists()) {
                    this.getLog().debug((CharSequence)"Installing generated POM");
                    if (this.classifier == null) {
                        artifact.addMetadata((ArtifactMetadata)pomMetadata);
                    } else {
                        project.setFile(temporaryPom);
                    }
                } else if (this.generatePom == null) {
                    this.getLog().debug((CharSequence)"Skipping installation of generated POM, already present in local repository");
                }
            }
        }
        if (this.sources != null) {
            this.projectHelper.attachArtifact(project, "jar", "sources", this.sources);
        }
        if (this.javadoc != null) {
            this.projectHelper.attachArtifact(project, "jar", "javadoc", this.javadoc);
        }
        try {
            ProjectInstallerRequest projectInstallerRequest = new ProjectInstallerRequest().setProject(project);
            this.installer.install(buildingRequest, projectInstallerRequest);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        finally {
            if (temporaryPom != null) {
                temporaryPom.delete();
            }
        }
    }

    private MavenProject createMavenProject() throws MojoExecutionException, MojoFailureException {
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("The artifact information is incomplete: 'groupId', 'artifactId', 'version' and 'packaging' are required.");
        }
        StringModelSource modelSource = new StringModelSource((CharSequence)("<project><modelVersion>4.0.0</modelVersion><groupId>" + this.groupId + "</groupId><artifactId>" + this.artifactId + "</artifactId><version>" + this.version + "</version><packaging>" + (this.classifier == null ? this.packaging : "pom") + "</packaging></project>"));
        DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        pbr.setProcessPlugins(false);
        try {
            return this.projectBuilder.build((ModelSource)modelSource, (ProjectBuildingRequest)pbr).getProject();
        }
        catch (ProjectBuildingException e) {
            if (e.getCause() instanceof ModelBuildingException) {
                throw new MojoExecutionException("The artifact information is not valid:" + Os.LINE_SEP + e.getCause().getMessage());
            }
            throw new MojoFailureException("Unable to create the project.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File readingPomFromJarFile() throws MojoExecutionException {
        File pomFile = null;
        ZipFile jarFile = null;
        try {
            Pattern pomEntry = Pattern.compile("META-INF/maven/.*/pom\\.xml");
            jarFile = new JarFile(this.file);
            Enumeration<JarEntry> jarEntries = ((JarFile)jarFile).entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                if (!pomEntry.matcher(entry.getName()).matches()) continue;
                this.getLog().debug((CharSequence)("Using " + entry.getName() + " as pomFile"));
                InputStream pomInputStream = null;
                FileOutputStream pomOutputStream = null;
                try {
                    pomInputStream = ((JarFile)jarFile).getInputStream(entry);
                    String base = this.file.getName();
                    if (base.indexOf(46) > 0) {
                        base = base.substring(0, base.lastIndexOf(46));
                    }
                    pomFile = File.createTempFile(base, ".pom");
                    pomOutputStream = new FileOutputStream(pomFile);
                    IOUtil.copy((InputStream)pomInputStream, (OutputStream)pomOutputStream);
                    ((OutputStream)pomOutputStream).close();
                    pomOutputStream = null;
                    pomInputStream.close();
                    pomInputStream = null;
                    this.processModel(this.readModel(pomFile));
                }
                catch (Throwable throwable) {
                    IOUtil.close((InputStream)pomInputStream);
                    IOUtil.close(pomOutputStream);
                    throw throwable;
                }
                IOUtil.close((InputStream)pomInputStream);
                IOUtil.close((OutputStream)pomOutputStream);
                break;
            }
            if (pomFile == null) {
                this.getLog().info((CharSequence)("pom.xml not found in " + this.file.getName()));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return pomFile;
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        Reader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read(reader);
            reader.close();
            reader = null;
            Model model2 = model;
            return model2;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            this.groupId = model.getGroupId();
            if (this.groupId == null && parent != null) {
                this.groupId = parent.getGroupId();
            }
        }
        if (this.artifactId == null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null) {
            this.packaging = model.getPackaging();
        }
    }

    private Model generateModel() {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setPackaging(this.packaging);
        model.setDescription("POM was created from install:install-file");
        return model;
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = this.generateModel();
        XmlStreamWriter writer = null;
        try {
            File pomFile = File.createTempFile("mvninstall", ".pom");
            writer = WriterFactory.newXmlWriter((File)pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            writer.close();
            writer = null;
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }
}

