/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.subsystem.content;

import org.sonatype.nexus.client.internal.util.Check;

public class Location {
    private final String contentType;
    private final String repositoryId;
    private final String repositoryPath;

    public Location(String contentType, String repositoryId, String repositoryPath) {
        this.contentType = Check.notBlank(contentType, "contentType");
        this.repositoryId = Check.notBlank(repositoryId, "repositoryId");
        String repoPath = Check.notBlank(repositoryPath, "repositoryPath");
        while (repoPath.startsWith("/")) {
            repoPath = repoPath.substring(1);
        }
        this.repositoryPath = repoPath;
    }

    public Location(String repositoryId, String repositoryPath) {
        this("repositories", repositoryId, repositoryPath);
    }

    public String toContentPath() {
        return String.format("%s/%s/%s", this.contentType, this.repositoryId, this.repositoryPath);
    }

    public String toString() {
        return this.toContentPath();
    }

    public static Location repositoryLocation(String repositoryId, String path) {
        return new Location("repositories", repositoryId, path);
    }

    public static Location groupLocation(String groupId, String path) {
        return new Location("groups", groupId, path);
    }

    public static Location siteLocation(String siteId, String path) {
        return new Location("sites", siteId, path);
    }
}

