/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.routing;

import com.google.common.base.Throwables;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.sonatype.nexus.client.core.exception.NexusClientNotFoundException;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.routing.DiscoveryConfiguration;
import org.sonatype.nexus.client.core.subsystem.routing.Routing;
import org.sonatype.nexus.client.core.subsystem.routing.Status;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RoutingConfigMessage;
import org.sonatype.nexus.rest.model.RoutingConfigMessageWrapper;
import org.sonatype.nexus.rest.model.RoutingStatusMessage;
import org.sonatype.nexus.rest.model.RoutingStatusMessageWrapper;

public class JerseyRouting
extends SubsystemSupport<JerseyNexusClient>
implements Routing {
    public JerseyRouting(JerseyNexusClient nexusClient) {
        super(nexusClient);
    }

    @Override
    public Status getStatus(String mavenRepositoryId) {
        try {
            Status.DiscoveryStatus discoveryStatus;
            RoutingStatusMessage message = ((RoutingStatusMessageWrapper)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRouting.routingPath(mavenRepositoryId)).get(RoutingStatusMessageWrapper.class)).getData();
            if (message.getDiscovery() == null) {
                discoveryStatus = null;
            } else {
                Status.Outcome discoveryOutcome = Status.Outcome.values()[message.getDiscovery().getDiscoveryLastStatus() + 1];
                discoveryStatus = new Status.DiscoveryStatus(message.getDiscovery().isDiscoveryEnabled(), message.getDiscovery().getDiscoveryIntervalHours(), discoveryOutcome, message.getDiscovery().getDiscoveryLastStrategy(), message.getDiscovery().getDiscoveryLastMessage(), message.getDiscovery().getDiscoveryLastRunTimestamp());
            }
            Status.Outcome publishOutcome = Status.Outcome.values()[message.getPublishedStatus() + 1];
            return new Status(publishOutcome, message.getPublishedMessage(), message.getPublishedTimestamp(), message.getPublishedUrl(), discoveryStatus);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public void updatePrefixFile(String mavenProxyRepositoryId) throws IllegalArgumentException, NexusClientNotFoundException {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRouting.routingPath(mavenProxyRepositoryId)).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public DiscoveryConfiguration getDiscoveryConfigurationFor(String mavenProxyRepositoryId) throws IllegalArgumentException, NexusClientNotFoundException {
        try {
            RoutingConfigMessage message = ((RoutingConfigMessageWrapper)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRouting.routingConfigPath(mavenProxyRepositoryId)).get(RoutingConfigMessageWrapper.class)).getData();
            return new DiscoveryConfiguration(message.isDiscoveryEnabled(), message.getDiscoveryIntervalHours());
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public void setDiscoveryConfigurationFor(String mavenProxyRepositoryId, DiscoveryConfiguration configuration) throws IllegalArgumentException, NexusClientNotFoundException {
        try {
            RoutingConfigMessage message = new RoutingConfigMessage();
            message.setDiscoveryEnabled(configuration.isEnabled());
            message.setDiscoveryIntervalHours(configuration.getIntervalHours());
            RoutingConfigMessageWrapper wrapper = new RoutingConfigMessageWrapper();
            wrapper.setData(message);
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRouting.routingConfigPath(mavenProxyRepositoryId)).put((Object)wrapper);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    static String routingPath(String mavenRepositoryId) {
        try {
            return "repositories/" + URLEncoder.encode(mavenRepositoryId, "UTF-8") + "/routing";
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static String routingConfigPath(String mavenRepositoryId) {
        return JerseyRouting.routingPath(mavenRepositoryId) + "/config";
    }
}

