/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.targets;

import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;
import org.sonatype.nexus.client.core.subsystem.targets.RepositoryTarget;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.JerseyEntitySupport;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.targets.JerseyRepositoryTargets;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryTargetResource;
import org.sonatype.nexus.rest.model.RepositoryTargetResourceResponse;

public class JerseyRepositoryTarget
extends JerseyEntitySupport<RepositoryTarget, RepositoryTargetResource>
implements RepositoryTarget {
    public JerseyRepositoryTarget(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyRepositoryTarget(JerseyNexusClient nexusClient, String id, RepositoryTargetResource settings) {
        super(nexusClient, id, settings);
    }

    @Override
    protected RepositoryTargetResource createSettings(String id) {
        RepositoryTargetResource resource = new RepositoryTargetResource();
        resource.setId(id);
        return resource;
    }

    @Override
    protected RepositoryTargetResource doGet() {
        try {
            return ((RepositoryTargetResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRepositoryTargets.path(this.id())).get(RepositoryTargetResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    protected RepositoryTargetResource doCreate() {
        RepositoryTargetResourceResponse request = new RepositoryTargetResourceResponse();
        request.setData((RepositoryTargetResource)this.settings());
        try {
            return ((RepositoryTargetResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repo_targets").post(RepositoryTargetResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    protected RepositoryTargetResource doUpdate() {
        RepositoryTargetResourceResponse request = new RepositoryTargetResourceResponse();
        request.setData((RepositoryTargetResource)this.settings());
        try {
            return ((RepositoryTargetResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRepositoryTargets.path(this.id())).put(RepositoryTargetResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    protected void doRemove() {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyRepositoryTargets.path(this.id())).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public String name() {
        return ((RepositoryTargetResource)this.settings()).getName();
    }

    @Override
    public String contentClass() {
        return ((RepositoryTargetResource)this.settings()).getContentClass();
    }

    @Override
    public List<String> patterns() {
        return ((RepositoryTargetResource)this.settings()).getPatterns();
    }

    @Override
    public RepositoryTarget withName(String name) {
        ((RepositoryTargetResource)this.settings()).setName(name);
        return this;
    }

    @Override
    public RepositoryTarget withContentClass(String cls) {
        ((RepositoryTargetResource)this.settings()).setContentClass(cls);
        return this;
    }

    @Override
    public RepositoryTarget withPatterns(String ... patterns) {
        ((RepositoryTargetResource)this.settings()).setPatterns((List)Lists.newArrayList((Object[])patterns));
        return this;
    }

    @Override
    public RepositoryTarget addPattern(String pattern) {
        ((RepositoryTargetResource)this.settings()).addPattern(pattern);
        return this;
    }
}

