/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.edit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.Watch;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.NotifyRequest;

public class EditCommand
extends BasicCommand {
    private boolean checkThatUnedited;
    private boolean forceEvenIfEdited;
    private Watch temporaryWatch;
    private transient ClientServices clientServices;

    public static File getEditBackupFile(File file) {
        return new File(file.getParent(), "CVS/Base/" + file.getName());
    }

    public EditCommand() {
        this.resetCVSCommand();
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException {
        this.clientServices = clientServices;
        try {
            clientServices.ensureConnection();
            super.execute(clientServices, eventManager);
            this.addArgumentRequest(this.isCheckThatUnedited(), "-c");
            this.addArgumentRequest(this.isForceEvenIfEdited(), "-f");
            this.addRequestForWorkingDirectory(clientServices);
            this.addRequest(CommandRequest.NOOP);
            clientServices.processRequests(this.requests);
        }
        catch (AuthenticationException authenticationException) {
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (EOFException eOFException) {
            throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
            this.clientServices = null;
        }
    }

    protected void addRequestForFile(File file, Entry entry) {
        String string = Watch.getWatchString(this.getTemporaryWatch());
        this.requests.add(new NotifyRequest(file, "E", string));
        try {
            this.editFile(this.clientServices, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("edit ");
        stringBuffer.append(this.getCVSArguments());
        this.appendFileArguments(stringBuffer);
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rl";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnedited(false);
        this.setForceEvenIfEdited(true);
        this.setTemporaryWatch(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }

    public boolean isCheckThatUnedited() {
        return this.checkThatUnedited;
    }

    public void setCheckThatUnedited(boolean bl) {
        this.checkThatUnedited = bl;
    }

    public boolean isForceEvenIfEdited() {
        return this.forceEvenIfEdited;
    }

    public void setForceEvenIfEdited(boolean bl) {
        this.forceEvenIfEdited = bl;
    }

    public Watch getTemporaryWatch() {
        return this.temporaryWatch;
    }

    public void setTemporaryWatch(Watch watch) {
        this.temporaryWatch = watch;
    }

    private void editFile(ClientServices clientServices, File file) throws IOException {
        this.addBaserevEntry(clientServices, file);
        FileUtils.copyFile(file, EditCommand.getEditBackupFile(file));
        FileUtils.setFileReadOnly(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void addBaserevEntry(ClientServices var1_1, File var2_2) throws IOException {
        block34: {
            block31: {
                var3_3 = var1_1.getEntry(var2_2);
                if (var3_3 == null || var3_3.getRevision() == null || var3_3.isNewUserFile() || var3_3.isUserFileToBeRemoved()) {
                    throw new IllegalArgumentException("File does not have an Entry or Entry is invalid!");
                }
                var4_4 = new File(var2_2.getParentFile(), "CVS/Baserev");
                var5_5 = new File(var4_4.getAbsolutePath() + '~');
                var6_6 = null;
                var7_7 = null;
                var8_8 = true;
                var9_9 = true;
                var10_10 = 'B' + var2_2.getName() + '/';
                var7_7 = new BufferedWriter(new FileWriter(var5_5));
                var9_9 = false;
                var6_6 = new BufferedReader(new FileReader(var4_4));
                var11_11 = var6_6.readLine();
                while (var11_11 != null) {
                    if (var11_11.startsWith(var10_10)) {
                        var8_8 = false;
                    }
                    var9_9 = true;
                    var7_7.write(var11_11);
                    var7_7.newLine();
                    var9_9 = false;
                    var11_11 = var6_6.readLine();
                }
                var13_13 = null;
                if (var6_6 == null) break block31;
                try {
                    var6_6.close();
                }
                catch (IOException var14_16) {
                    // empty catch block
                }
            }
            if (var7_7 == null) break block34;
            try {
                if (!var8_8 || var9_9) ** GOTO lbl94
                var7_7.write(var10_10 + var3_3.getRevision() + '/');
                var7_7.newLine();
            }
            finally {
                try {
                    var7_7.close();
                }
                catch (IOException var14_16) {}
            }
            {
                catch (IOException var11_12) {
                    if (var9_9) {
                        throw var11_12;
                    }
                    var13_14 = null;
                    if (var6_6 != null) {
                        try {
                            var6_6.close();
                        }
                        catch (IOException var14_17) {
                            // empty catch block
                        }
                    }
                    if (var7_7 == null) break block34;
                    try {
                        if (!var8_8 || var9_9) ** GOTO lbl94
                        var7_7.write(var10_10 + var3_3.getRevision() + '/');
                        var7_7.newLine();
                    }
                    finally {
                        try {
                            var7_7.close();
                        }
                        catch (IOException var14_17) {}
                    }
                }
            }
            catch (Throwable var12_25) {
                var13_15 = null;
                if (var6_6 != null) {
                    try {
                        var6_6.close();
                    }
                    catch (IOException var14_18) {
                        // empty catch block
                    }
                }
                if (var7_7 != null) {
                    try {
                        if (var8_8 && !var9_9) {
                            var7_7.write(var10_10 + var3_3.getRevision() + '/');
                            var7_7.newLine();
                        }
                    }
                    finally {
                        try {
                            var7_7.close();
                        }
                        catch (IOException var14_18) {}
                    }
                }
                throw var12_25;
            }
        }
        var4_4.delete();
        var5_5.renameTo(var4_4);
    }
}

