/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal.zapper;

import java.io.IOException;
import java.util.Collections;
import org.sonatype.spice.zapper.Parameters;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.codec.Codec;
import org.sonatype.spice.zapper.hash.HashUtils;
import org.sonatype.spice.zapper.internal.AbstractIdentified;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.MessagePayload;
import org.sonatype.spice.zapper.internal.PayloadCreator;
import org.sonatype.spice.zapper.internal.Protocol;
import org.sonatype.spice.zapper.internal.ProtocolIdentifier;
import org.sonatype.spice.zapper.internal.SegmentCreator;
import org.sonatype.spice.zapper.internal.Transfer;
import org.sonatype.spice.zapper.internal.TransferIdentifier;
import org.sonatype.spice.zapper.internal.transport.AbstractClient;
import org.sonatype.spice.zapper.internal.zapper.ZapperPayloadCreator;
import org.sonatype.spice.zapper.internal.zapper.ZapperSegmentCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZapperProtocol
extends AbstractIdentified<ProtocolIdentifier>
implements Protocol {
    public static ProtocolIdentifier ID = new ProtocolIdentifier("zapper");
    private final Parameters parameters;

    public ZapperProtocol(Parameters parameters) {
        super(ID);
        this.parameters = Check.notNull(parameters, Parameters.class);
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public SegmentCreator getSegmentCreator() {
        return new ZapperSegmentCreator(this.getParameters().getMaximumSegmentLength());
    }

    @Override
    public PayloadCreator getPayloadCreator() {
        return new ZapperPayloadCreator(this.getParameters());
    }

    @Override
    public void beforeUpload(Transfer transfer, AbstractClient<?> client) throws IOException {
        byte[] payload = new byte[]{};
        MessagePayload message = new MessagePayload((TransferIdentifier)transfer.getIdentifier(), new Path("beforeUpload"), payload, HashUtils.getDigest(this.parameters.getHashAlgorithm(), payload), Collections.<Codec>emptyList());
        client.upload(message);
    }

    @Override
    public void afterUpload(Transfer transfer, AbstractClient<?> client) throws IOException {
        byte[] payload = new byte[]{};
        MessagePayload message = new MessagePayload((TransferIdentifier)transfer.getIdentifier(), new Path("afterUpload"), payload, HashUtils.getDigest(this.parameters.getHashAlgorithm(), payload), Collections.<Codec>emptyList());
        client.upload(message);
    }
}

