/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.Response;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.subsystem.content.Content;
import org.sonatype.nexus.client.core.subsystem.content.Location;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;

public class JerseyContent
extends SubsystemSupport<JerseyNexusClient>
implements Content {
    private static final String CONTENT_PREFIX = "content/";

    public JerseyContent(JerseyNexusClient nexusClient) {
        super(nexusClient);
    }

    protected String toUri(Location location, Content.Directive directive) {
        String uri = CONTENT_PREFIX + location.toContentPath();
        if (directive != null) {
            switch (directive) {
                case LOCAL_ONLY: {
                    uri = uri + "?isLocal";
                    break;
                }
                case REMOTE_ONLY: {
                    uri = uri + "?isRemote";
                    break;
                }
                case GROUP_ONLY: {
                    uri = uri + "?asGroupOnly";
                    break;
                }
                case AS_EXPIRED: {
                    uri = uri + "?asExpired";
                    break;
                }
            }
        }
        return uri;
    }

    @Override
    public boolean exists(Location location) {
        return this.exists(location, this.toUri(location, null));
    }

    @Override
    public boolean existsWith(Location location, Content.Directive directive) {
        return this.exists(location, this.toUri(location, directive));
    }

    protected boolean exists(final Location location, String uri) {
        try {
            ClientResponse response = ((JerseyNexusClient)this.getNexusClient()).uri(uri).head();
            if (!ClientResponse.Status.OK.equals((Object)response.getClientResponseStatus())) {
                if (ClientResponse.Status.NOT_FOUND.equals((Object)response.getClientResponseStatus())) {
                    return false;
                }
                throw ((JerseyNexusClient)this.getNexusClient()).convert(new ContextAwareUniformInterfaceException(response){

                    @Override
                    public String getMessage(int status) {
                        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                            return String.format("Inexistent path: %s", location);
                        }
                        return null;
                    }
                });
            }
            return true;
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public void download(Location location, File target) throws IOException {
        this.download(location, this.toUri(location, null), target, null);
    }

    @Override
    public void downloadRange(Location location, File target, Range<Long> range) throws IOException {
        this.download(location, this.toUri(location, null), target, range);
    }

    @Override
    public void downloadRange(Location location, OutputStream stream, Range<Long> range) throws IOException {
        this.download(location, this.toUri(location, null), stream, range);
    }

    @Override
    public void downloadWith(Location location, Content.Directive directive, File target) throws IOException {
        this.download(location, this.toUri(location, directive), target, null);
    }

    @Override
    public void downloadWith(Location location, Content.Directive directive, OutputStream target) throws IOException {
        this.download(location, this.toUri(location, directive), target, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(Location location, String uri, File target, Range<Long> range) throws IOException {
        if (!target.exists()) {
            File targetDir = target.getParentFile();
            FileUtils.forceMkdir((File)targetDir);
        } else {
            Preconditions.checkState((target.isFile() && target.canWrite() ? 1 : 0) != 0, (String)"File '%s' is not a file or could not be written", (Object[])new Object[]{target.getAbsolutePath()});
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(target));
            this.download(location, uri, os, range);
        }
        catch (Throwable throwable) {
            IOUtil.close(os);
            throw throwable;
        }
        IOUtil.close((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(final Location location, String uri, OutputStream target, Range<Long> range) throws IOException {
        try {
            ClientResponse response;
            WebResource.Builder wrb = ((JerseyNexusClient)this.getNexusClient()).uri(uri);
            if (range != null && (range.hasLowerBound() || range.hasUpperBound())) {
                StringBuilder rangeHeaderValue = new StringBuilder("bytes=");
                if (range.hasLowerBound()) {
                    rangeHeaderValue.append(range.lowerEndpoint());
                }
                rangeHeaderValue.append("-");
                if (range.hasUpperBound()) {
                    rangeHeaderValue.append(range.upperEndpoint());
                }
                wrb.header("Range", (Object)rangeHeaderValue);
            }
            if (!ClientResponse.Status.OK.equals((Object)(response = (ClientResponse)wrb.get(ClientResponse.class)).getClientResponseStatus()) && !ClientResponse.Status.PARTIAL_CONTENT.equals((Object)response.getClientResponseStatus())) {
                throw ((JerseyNexusClient)this.getNexusClient()).convert(new ContextAwareUniformInterfaceException(response){

                    @Override
                    public String getMessage(int status) {
                        if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                            return String.format("Inexistent path: %s", location);
                        }
                        return null;
                    }
                });
            }
            try {
                IOUtil.copy((InputStream)response.getEntityInputStream(), (OutputStream)target);
            }
            finally {
                response.close();
            }
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public void upload(final Location location, File target) throws IOException {
        try {
            ((JerseyNexusClient)this.getNexusClient()).uri(CONTENT_PREFIX + location.toContentPath()).put((Object)target);
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(new ContextAwareUniformInterfaceException(e.getResponse()){

                @Override
                public String getMessage(int status) {
                    if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                        return String.format("Inexistent path: %s", location);
                    }
                    return null;
                }
            });
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public void delete(final Location location) throws IOException {
        try {
            ((JerseyNexusClient)this.getNexusClient()).uri(CONTENT_PREFIX + location.toContentPath()).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(new ContextAwareUniformInterfaceException(e.getResponse()){

                @Override
                public String getMessage(int status) {
                    if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                        return String.format("Inexistent path: %s", location);
                    }
                    return null;
                }
            });
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }
}

