/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.client.core.exception.NexusClientException;
import org.sonatype.nexus.client.core.exception.NexusClientNotFoundException;
import org.sonatype.nexus.client.core.spi.SubsystemSupport;
import org.sonatype.nexus.client.core.spi.subsystem.repository.RepositoryFactory;
import org.sonatype.nexus.client.core.subsystem.repository.Repositories;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.rest.jersey.ContextAwareUniformInterfaceException;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryListResource;
import org.sonatype.nexus.rest.model.RepositoryListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;

public class JerseyRepositories
extends SubsystemSupport<JerseyNexusClient>
implements Repositories {
    private final Set<RepositoryFactory> repositoryFactories;

    public JerseyRepositories(JerseyNexusClient nexusClient, Set<RepositoryFactory> repositoryFactories) {
        super(nexusClient);
        this.repositoryFactories = repositoryFactories;
    }

    @Override
    public <R extends Repository> R get(final String id) {
        Preconditions.checkNotNull((Object)id);
        try {
            return this.convert(id, ((RepositoryResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repositories/" + id).get(RepositoryResourceResponse.class)).getData());
        }
        catch (UniformInterfaceException e) {
            NexusClientException converted = ((JerseyNexusClient)this.getNexusClient()).convert(e);
            if (converted instanceof NexusClientNotFoundException) {
                try {
                    return this.convert(id, (RepositoryBaseResource)((RepositoryGroupResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repo_groups/" + id).get(RepositoryGroupResourceResponse.class)).getData());
                }
                catch (UniformInterfaceException e2) {
                    throw ((JerseyNexusClient)this.getNexusClient()).convert(new ContextAwareUniformInterfaceException(e2.getResponse()){

                        @Override
                        public String getMessage(int status) {
                            if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                                return String.format("Repository with id '%s' was not found", id);
                            }
                            return null;
                        }
                    });
                }
                catch (ClientHandlerException e2) {
                    throw ((JerseyNexusClient)this.getNexusClient()).convert(e2);
                }
            }
            throw converted;
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public <R extends Repository> R get(Class<R> type, String id) {
        R repository = this.get(id);
        if (!type.isAssignableFrom(repository.getClass())) {
            throw new ClassCastException(String.format("Expected an '%s' but found repository is an '%s'", type.getName(), repository.getClass().getName()));
        }
        return (R)((Repository)type.cast(repository));
    }

    @Override
    public Collection<Repository> get() {
        try {
            RepositoryListResourceResponse response = (RepositoryListResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("repositories").get(RepositoryListResourceResponse.class);
            if (response.getData() == null || response.getData().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList repositories = Lists.newArrayList();
            for (RepositoryListResource resource : response.getData()) {
                repositories.add(this.get(resource.getId()));
            }
            return repositories;
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public <R extends Repository> Collection<R> get(final Class<R> type) {
        Collection<Repository> repositories = this.get();
        Collection filtered = Collections2.filter(repositories, (Predicate)new Predicate<Repository>(){

            public boolean apply(@Nullable Repository repository) {
                return repository != null && type.isAssignableFrom(repository.getClass());
            }
        });
        return filtered;
    }

    @Override
    public <R extends Repository> R create(Class<R> type, String id) {
        for (RepositoryFactory repositoryFactory : this.repositoryFactories) {
            if (!repositoryFactory.canCreate(type)) continue;
            Object r = repositoryFactory.create((JerseyNexusClient)this.getNexusClient(), id);
            return r;
        }
        throw new IllegalStateException(String.format("No repository factory found for repository of type %s", type.getName()));
    }

    private <R extends Repository> R convert(String id, RepositoryBaseResource rbs) {
        int currentScore = 0;
        RepositoryFactory factory = null;
        for (RepositoryFactory repositoryFactory : this.repositoryFactories) {
            int score = repositoryFactory.canAdapt(rbs);
            if (score <= currentScore) continue;
            currentScore = score;
            factory = repositoryFactory;
        }
        if (factory == null) {
            throw new IllegalStateException(String.format("No repository factory found for repository with id %s", id));
        }
        return factory.adapt((JerseyNexusClient)this.getNexusClient(), rbs);
    }
}

