/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.subsystem.repository.Repository;
import org.sonatype.nexus.client.core.subsystem.repository.maven.MavenHostedRepository;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyHostedRepositoryFactory;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.maven.JerseyMavenHostedRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryResource;

@Named
@Singleton
public class JerseyMavenHostedRepositoryFactory
extends JerseyHostedRepositoryFactory {
    @Override
    public int canAdapt(RepositoryBaseResource resource) {
        int score = super.canAdapt(resource);
        if (score > 0 && "maven2".equals(resource.getProvider())) {
            ++score;
        }
        return score;
    }

    @Override
    public JerseyMavenHostedRepository adapt(JerseyNexusClient nexusClient, RepositoryBaseResource resource) {
        return new JerseyMavenHostedRepository(nexusClient, (RepositoryResource)resource);
    }

    @Override
    public boolean canCreate(Class<? extends Repository> type) {
        return MavenHostedRepository.class.equals(type);
    }

    @Override
    public JerseyMavenHostedRepository create(JerseyNexusClient nexusClient, String id) {
        return new JerseyMavenHostedRepository(nexusClient, id);
    }
}

