/*
 * Decompiled with CFR 0.152.
 */
package se.vandmo.dependencylock.maven;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;

public final class ArtifactIdentifier
implements Comparable<ArtifactIdentifier> {
    public final String groupId;
    public final String artifactId;
    public final Optional<String> classifier;

    public static ArtifactIdentifier from(Artifact artifact) {
        return new ArtifactIdentifier(artifact.getGroupId(), artifact.getArtifactId(), Optional.ofNullable(artifact.getClassifier()));
    }

    ArtifactIdentifier(String groupId, String artifactId, Optional<String> classifier) {
        this.groupId = Objects.requireNonNull(groupId);
        this.artifactId = Objects.requireNonNull(artifactId);
        this.classifier = Objects.requireNonNull(classifier);
    }

    @Override
    public int compareTo(ArtifactIdentifier other) {
        return this.toString().compareTo(other.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(':').append(this.artifactId);
        this.classifier.ifPresent(actualClassifier -> sb.append(':').append((String)actualClassifier));
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.groupId);
        hash = 17 * hash + Objects.hashCode(this.artifactId);
        hash = 17 * hash + Objects.hashCode(this.classifier);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactIdentifier other = (ArtifactIdentifier)obj;
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        return Objects.equals(this.classifier, other.classifier);
    }
}

